$(function () {
  var onBtnTap = false; //防止保存按钮多次点击
  var mask = mui.createMask();
  $.ajax({
    type: "POST",
    url: baseRequestUrl + "/api/User/GetUserInfo",
    contentType: 'application/json; charset=utf-8',
    headers: {
      "Authorization": 'Bearer ' + localStorage.getItem('token')
    },
    data: "",
    dataType: "json",
    beforeSend: function beforeSend() {
      loading();
    },
    success: function success(data) {
      localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      if (data.code == 1) {
        $("#dlzh").html(data.data.loginName);
        $("#txtxm").val(data.data.userName);
        $("#txtphone").text(data.data.phone);
      } else {
        mui.toast(data.msg);
      }
    },
    error: function error() {
      setTimeout(function () {
        mask.close();
        $('#loading').remove();
      }, 50);
      mui.toast("个人信息获取失败，请稍后重试");
    }
  });
  var clearBtn = '<span id="cls" ><i class="mui-icon mui-icon-close-filled"></i></span>';
  $("#txtxm").focus();
  $("#txtxm").after(clearBtn);
  $('#cls').on('tap', function () {
    $("#txtxm").val('');
    $("#txtxm").trigger("propertychange");
    $('#cls').remove();
  });
  $("#zltx-btn").bind("click", function () {
    if (onBtnTap) return;
    onBtnTap = true;
    var $this = $(this);
    if ($(this).attr("canLongin") == 'no') {
      return false;
    }
    var name = $("#txtxm").val();
    var requestData = {
      userName: name
    };
    var mask = mui.createMask();
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/User/EditUserInfo",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        onBtnTap = false;
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          onBtnTap = true;
          var nowUserInfo = JSON.parse(localStorage.getItem('cookieUserInfo'));
          nowUserInfo.userName = name;
          localStorage.setItem("cookieUserInfo", JSON.stringify(nowUserInfo));
          setTimeout(function () {
            mask.close();
            onBtnTap = false;
            window.history.go(-1);
          }, 1000);
          mui.toast('个人信息更新成功');
          success();
        } else {
          mask.close();
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        onBtnTap = false;
        setTimeout(function () {
          mask.close();
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
  $("#txtxm").on("focus keyup", function () {
    var txtxm = $("#txtxm").val();
    if (txtxm == "") {
      $(".btn a").css("background", "#d9d9d9");
      $("#zltx-btn").attr({
        'canLongin': 'no'
      });
    } else {
      $(".btn a").css("background", "linear-gradient(to right, #24b940, #009b4c)");
      $("#zltx-btn").attr({
        'canLongin': 'yes'
      });
    }
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});