$(function () {
  var pageIndex = 1;
  var storeName = JSON.parse(sessionStorage.getItem('storeName'));
  if (storeName) {
    $("#search").val(storeName.queryName);
    loadCrop();
  }
  // function chooseCrop() {
  //     var crop = JSON.parse(sessionStorage.getItem('storeName'));
  //     if (crop) {
  //         for (var i = 0; i < $('#allList li').length; i++) {
  //             var storeId = $('#allList li').eq(i).attr('storeId');
  //             if (crop.storeId == storeId) {
  //                 $('#allList li').eq(i).find('input[name="checkbox1"]').attr('checked', 'checked');
  //             }
  //         }
  //     }
  // }
  var supplierListTemp = $('#supplierListTemp').html();
  $('.page #pullrefresh').css('margin-top', '3rem');
  //获取供应商
  function loadCrop() {
    var storeName = $('#search').val();
    var reg = /^\s*$/g;
    if (storeName == "" || storeName.length == 0 || reg.test(storeName)) {
      mui.toast('查询条件不能为空!');
      return;
    } else {
      var requestData = {
        "keyword": storeName,
        "pageIndex": pageIndex,
        "pageSize": 10
      };
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Store/SearchForPageList",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify(requestData),
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function success(data) {
          //参数为true代表没有更多数据了。
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          if (data.code == 1) {
            if (!data.data || data.data.length == 0) {
              $('.zwsj-box').show();
            } else {
              $('.zwsj-box').hide();
            }
            var tpl = supplierListTemp;
            var html = juicer(tpl, data);
            if (pageIndex == 1) {
              $('#allList').html(html);
            } else {
              $('#allList').append(html);
            }
            // chooseCrop();
          } else {
            $('.zwsj-box').show();
            mui.toast(data.msg);
          }
        },
        error: function error() {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
        }
      });
    }
  }
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: false
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      loadCrop();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    pageIndex++;
    setTimeout(function () {
      loadCrop();
    }, 1500);
  }
  //选择供应商返回新增页面
  $('#allList').on('tap', 'li', function () {
    var storeName = $(this).attr("storeName");
    var storeId = $(this).attr("storeId");
    var queryName = $("#search").val();
    var contactInformation = $(this).attr("contactInformation");
    var legalPersonName = $(this).attr("legalPersonName");
    var provinceCode = $(this).attr("provinceCode");
    var provinceName = $(this).attr("provinceName");
    var cityCode = $(this).attr("cityCode");
    var cityName = $(this).attr("cityName");
    var countyCode = $(this).attr("countyCode");
    var countyName = $(this).attr("countyName");
    var townCode = $(this).attr("townCode");
    var townName = $(this).attr("townName");
    var address = $(this).attr("address");
    var regionId = $(this).attr("regionId");
    var enterpriseCreditCode = $(this).attr("enterpriseCreditCode"); //同意企业信用代码
    var data = {
      queryName: queryName,
      storeId: storeId,
      storeName: storeName,
      contactInformation: contactInformation,
      legalPersonName: legalPersonName,
      provinceCode: provinceCode,
      provinceName: provinceName,
      cityCode: cityCode,
      cityName: cityName,
      countyCode: countyCode,
      countyName: countyName,
      townCode: townCode,
      townName: townName,
      address: address,
      regionId: regionId,
      enterpriseCreditCode: enterpriseCreditCode
    };
    var teststoreName = JSON.parse(sessionStorage.getItem("storeName"));
    if (teststoreName != storeName) {
      sessionStorage.setItem("storeName", JSON.stringify(data));
    }
    window.history.go(-1);
  });
  //搜索
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageIndex = 1;
    loadCrop();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  //返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});