/****
 * 该sdk 页面时间统计方法为：跳转页面的时候存储耗时，然后通过session提交到下一个页面，下一个页面负责提交到后端，因为beforeunload事件执行提交后台任务不稳定
 */
function accessStatistics() {
  var prePathName,
    inTime,
    getAccessStatistcsConfig,
    leaveTime,
    noActivateTime = 0,
    actionMap;
  var initConfigFunc = function initConfigFunc(func) {
    getAccessStatistcsConfig = func;
    actionMap = func().ActionMap;
  };
  //操作统计
  var actionStatistics = function actionStatistics(actionCode) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      value = _ref.value,
      nodeId = _ref.nodeId,
      errorMsg = _ref.errorMsg,
      successMsg = _ref.successMsg;
    var obj = errorMsg ? {
      execResult: 0,
      errorMsg: errorMsg
    } : successMsg ? {
      execResult: 1,
      successMsg: successMsg
    } : {};
    var input = getCommonInput(obj);
    input.action = actionMap[actionCode] ? actionMap[actionCode].name : ""; // (string): 操作名称 ,
    input.label = actionMap[actionCode] ? actionMap[actionCode].desc : ""; // (string, optional): 用于更详细的描述事件 ,
    input.value = value; // (integer, optional): 用于填写打分型事件的分值 ,
    input.nodeId = nodeId; // (string, optional): 填写事件元素的组件元素id ,
    RequestAccessStatistics("/api/v1/Track/TrackEvent", input);
  };
  //页面进入统计
  var pageAccessStatistics = function pageAccessStatistics() {
    var prePageInfo = sessionStorage.getItem("prePageInfo");
    var prePathName = prePageInfo ? JSON.parse(prePageInfo).curPage : "";
    var input = getCommonInput({
      prePathName: prePathName
    });
    RequestAccessStatistics("/api/v1/Track/TrackPageView", input);
  };
  //页面停留统计
  var pageStayTimeStatistics = function pageStayTimeStatistics() {
    var prePageInfo = sessionStorage.getItem("prePageInfo");
    if (prePageInfo) {
      prePageInfo = JSON.parse(prePageInfo);
      var stayTime = prePageInfo.stayTime;
      var input = getCommonInput({
        pathName: prePageInfo.curPage,
        prePathName: prePageInfo.prePage
      });
      input.stayTime = stayTime - prePageInfo.noActivateTime; // (integer): 页面停留的时长（秒） ,
      input.stayTimeAll = stayTime; // (integer): 页面停留的时长（秒）(总时长，不管页面是否被激活) ,
      if (stayTime != 0) RequestAccessStatistics("/api/v1/Track/TrackPageStayTime", input);
    }
  };
  //页面进入
  var pageIn = function pageIn() {
    inTime = new Date();
    //提交上一个页面的时间追踪信息
    pageStayTimeStatistics();
    //提交当前页面的进入信息
    pageAccessStatistics();
  };

  //页面离开
  var pageOut = function pageOut() {
    var prePageInfo = sessionStorage.getItem("prePageInfo");
    var prePage = prePageInfo ? JSON.parse(prePageInfo).curPage : ""; //('/' + document.referrer.split('/').slice(3).join('/'))
    var stayTime = parseInt((new Date() - inTime) / 1000);
    sessionStorage.setItem("prePageInfo", JSON.stringify({
      curPage: location.pathname,
      prePage: prePage,
      stayTime: stayTime,
      noActivateTime: noActivateTime
    }));
  };
  //获取提交参数
  var getCommonInput = function getCommonInput(_ref2) {
    var _ref2$prePathName = _ref2.prePathName,
      prePathName = _ref2$prePathName === void 0 ? "" : _ref2$prePathName,
      pathName = _ref2.pathName,
      execResult = _ref2.execResult,
      execResultDes = _ref2.execResultDes;
    var _getAccessStatistcsCo = getAccessStatistcsConfig(),
      ipOrAnther = _getAccessStatistcsCo.ipOrAnther,
      userId = _getAccessStatistcsCo.userId,
      orgId = _getAccessStatistcsCo.orgId,
      region = _getAccessStatistcsCo.region,
      platformCode = _getAccessStatistcsCo.platformCode,
      appVersion = _getAccessStatistcsCo.appVersion,
      PathNameMap = _getAccessStatistcsCo.PathNameMap;
    var hashSessionCode = sessionStorage.getItem("HashSessionCode");
    if (!hashSessionCode) {
      var myHash = hashCode(ipOrAnther + new Date());
      hashSessionCode = myHash;
      sessionStorage.setItem("HashSessionCode", myHash);
    }
    var browerInfo = getBrowerVersion();
    var input = {
      category: PathNameMap[pathName ? pathName : location.pathname] ? PathNameMap[pathName ? pathName : location.pathname] : "",
      contentUrl: pathName ? pathName : location.pathname,
      //(string): 自定义虚拟PV页面的URL地址 ,
      refererUrl: prePathName,
      //(string, optional): 定义该受访页面的来源页URL地址 ,
      userId: userId,
      //(string, optional): 用户ID ,
      orgId: orgId,
      //(string, optional): 所属组织ID,可以等同UserId ,
      visitRegion: region,
      //(string): 客户端来源的行政区域名称 ,
      deviceBrand: browerInfo.factory,
      //(string): 设备品牌：如果是浏览器就对应什么版本的浏览器，App就对应什么牌子的手机 ,
      deviceVersion: browerInfo.version,
      //(string): 设备版本：如果是浏览器，对应浏览器的版本，App 就对应手机的的系统版本号 ,
      deviceInfo: browerInfo.info,
      //(string): 设备具体信息，XXX浏览器XXX版本，XXXX手机XXXX版本 ,
      platformCode: platformCode,
      //(string): 产品编号,与OC统一，方便OC的查询统计 ,
      appVersion: appVersion,
      //(string): App的版本号 ,
      appVisitSessionId: hashSessionCode,
      //(string): 访问端的session（该值每次启动都应不一致） ,
      execResult: execResult ? execResult : 1,
      //(integer, optional): 执行操作的结果 ,
      execResultDes: execResultDes ? execResultDes : '' //(string): 执行操作的结果的详情说明
    };

    return input;
  };

  //注册页面激活和非激活事件用于计算非激活状态的总共时间
  window.addEventListener('blur', function (e) {
    leaveTime = new Date();
  });
  window.addEventListener('focus', function (e) {
    noActivateTime += parseInt((new Date() - leaveTime) / 1000);
  });

  //返回可调用函数对象
  return {
    initConfigFunc: initConfigFunc,
    pageIn: pageIn,
    pageOut: pageOut,
    actionStatistics: actionStatistics
  };
}

/***********************************
 * 以下为辅助工具方法
 ***********************************/
var baseUrl = 'http://192.168.10.22:8545'; //AccessStatisticsUrl ? AccessStatisticsUrl : ('http://192.168.10.22:8545')
//请求后台方法
function RequestAccessStatistics(url, input) {
  url = baseUrl + url;
  /* delete $.ajaxSettings.headers["clientUrl"];
  delete $.ajaxSettings.headers["clientUrlName"];
  delete $.ajaxSettings.headers["clientDeviceNo"];
  delete $.ajaxSettings.headers["clientSourceType"];
  delete $.ajaxSettings.headers["userIp"];
  delete $.ajaxSettings.headers["clientDeviceSN"];
  delete $.ajaxSettings.headers["Authorization"];
  delete $.ajaxSettings.headers["clientToken"];
  delete $.ajaxSettings.headers["clientPlatformCode"]; */
  $.ajax({
    type: "POST",
    url: url,
    data: JSON.stringify(input),
    contentType: 'application/json; charset=utf-8',
    headers: {
      'Accept': 'application/json'
    },
    success: function success(data) {},
    error: function error(data) {}
  });
}

//获取字符串的hashcode
function hashCode(str) {
  var hash = 0;
  if (str.length == 0) return hash;
  for (var i = 0; i < str.length; i++) {
    var char = str.charCodeAt(i);
    hash = (hash << 5) - hash + char;
    hash = hash & hash; // Convert to 32bit integer
  }

  return hash;
}

//浏览器牌子和版本
var getBrowerVersion;
(function () {
  function isIE(userAgent) {
    var agent = userAgent.toLocaleLowerCase();
    //IE 内核都是使用 trident
    //IE8-IE10 可通过msie 标识判断， IE11 特殊标识 rv:11
    return agent.indexOf('msie') > -1 || agent.indexOf('rv:11') && agent.indexOf('trident') > -1;
  }
  function isEDGE(userAgent) {
    return userAgent.toLocaleLowerCase().indexOf('edge') > -1;
  }
  function isChrome(userAgent) {
    var agent = userAgent.toLocaleLowerCase();
    return agent.indexOf('chrome') > -1 && !isSafari(agent) && !isEDGE(agent);
  }
  function isSafari(userAgent) {
    var agent = userAgent.toLocaleLowerCase();
    return agent.indexOf('safari') > -1 && agent.indexOf('chrome') == -1;
  }
  function isFirefox(userAgent) {
    return userAgent.toLocaleLowerCase().indexOf('firefox') > -1;
  }
  function isOpera(userAgent) {
    return userAgent.indexOf('Opera') > -1;
  }
  function isQQ(userAgent) {
    return userAgent.indexOf('QQ') > -1;
  }
  function isWechat(userAgent) {
    return userAgent.indexOf('MicroMessenger') > -1;
  }
  getBrowerVersion = function getBrowerVersion() {
    var userAgent = window.navigator.userAgent;
    if (!userAgent) {
      return;
    }
    var agentStr = userAgent.toLocaleLowerCase();
    //var isMobile = agentStr.indexOf('mobile')!=-1;
    var agent = {};
    if (isIE(userAgent)) {
      agent.factory = 'IE';
      var partten = /msie\s(\d+)\.?\d?/;
      var sr = agentStr.match(partten);
      if (sr && sr.length > 0) {
        agent.version = sr[1];
      } else if (agentStr.indexOf('rv:11')) {
        agent.version = 11;
      }
    } else if (isEDGE(userAgent)) {
      agent.factory = 'edge';
      var strStart = userAgent.indexOf('Edge');
      var temp = userAgent.match(/Edge\/\S*/);
      agent.version = temp ? temp[0].split('/')[1] : "无法检测";
    } else if (isFirefox(userAgent)) {
      agent.factory = 'firefox';
      var temp = userAgent.match(/Firefox\/\S*/);
      agent.version = temp ? temp[0].split('/')[1] : "无法检测";
    } else if (isSafari(userAgent)) {
      agent.factory = 'safari';
      var temp = userAgent.match(/Version\/\S*/);
      agent.version = temp ? temp[0].split('/')[1] : "无法检测";
    } else if (isSafari(userAgent)) {
      agent.factory = 'opera';
      var temp = userAgent.match(/Opera\/\S*/);
      agent.version = temp ? temp[0].split('/')[1] : "无法检测";
    } else if (isWechat(userAgent)) {
      agent.factory = 'wechat';
      var temp = userAgent.match(/MicroMessenger\/\S*/);
      agent.version = temp ? temp[0].split('/')[1] : "无法检测";
    } else if (isQQ(userAgent)) {
      agent.factory = 'qqbrower';
      var temp = userAgent.match(/QQ\/\S*/);
      agent.version = temp ? temp[0].split('/')[1] : "无法检测";
    } else if (isChrome(userAgent)) {
      agent.factory = 'chrome';
      if (_mime("type", "application/vnd.chromium.remoting-viewer")) {
        agent.factory = "chrome(360)";
      }
      var temp = userAgent.match(/Chrome\/\S*/);
      agent.version = temp ? temp[0].split('/')[1] : "无法检测";
    }
    agent.info = userAgent;
    return agent;
  };
  function _mime(option, value) {
    var mimeTypes = navigator.mimeTypes;
    for (var mt in mimeTypes) {
      if (mimeTypes[mt][option] == value) {
        return true;
      }
    }
    return false;
  }
})();
window.onclick = function (e, a, b) {
  console.info(e, a, b);
};