$(function () {
  //下拉加载
  var count = 1; //count 表示页数
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  var xiaohuodanjuListTemp = $("#xiaohuodanjuListTemp"); //获取前端需要加载的模板
  // 上下拉刷新加载公共代码
  function pullPublic() {
    var table = document.body.querySelector('.mui-table-view');
    var requestData = {
      pageIndex: count,
      pageSize: 10
    };
    //销售单据列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWBankCard/GetList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $("#pullrefresh").show();
          $(".zwsj-box").hide();
          mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
          if (data.data != null) {
            if (data.data.length > 0) {
              data.data.forEach(function (i) {
                i.balanceAmount = ToMoney(i.balanceAmount);
                i.totalOutAmount = ToMoney(i.totalOutAmount);
                i.totalInAmount = ToQuit(i.totalInAmount);
                i.bankCardNumber = i.bankCardNumber.toString();
                i.bankCardNumber = i.bankCardNumber.slice(0, 4) + ' **** **** ' + i.bankCardNumber.slice(11, i.bankCardNumber.length);
              });
              var tpl = xiaohuodanjuListTemp.html();
              var html = juicer(tpl, data);
              if (count == 1) {
                $(table).html(html);
              } else {
                $(table).append(html);
              }
              count++;
            }
            if (data.data == null || data.data.length == 0) {
              if (count == 1) {
                $(table).html("");
                $(".zwsj-box").show();
                $('#loading').remove();
              } else {
                mui.toast("未查询到更多数据");
              }
            }
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      count = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }

  //银行卡  详情
  $('#jhdjList').on('tap', '.orderList', function () {
    var id = $(this).attr("data-id"); //id
    location.href = "bankCardDetail.html?id=" + id;
  });
  //银行卡  编辑
  $('body').on('tap', '#edit', function () {
    var id = $(this).attr("data-id"); //id
    location.href = "bankCardAdd.html?id=" + id;
  });
  //银行卡  设置默认卡
  $('body').on('tap', '#default', function () {
    var id = $(this).attr("data-id"); //id
    mui.confirm('确认设置该卡号为默认卡号？', '设置', ['否', '是'], function (e) {
      if (e.index == 1) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/SWBankCard/SetIsDefault?id=" + id,
          contentType: "application/json; charset=utf-8",
          headers: {
            Authorization: "Bearer " + localStorage.getItem("token")
          },
          dataType: "json",
          beforeSend: function beforeSend() {
            loading();
          },
          success: function (_success) {
            function success(_x) {
              return _success.apply(this, arguments);
            }
            success.toString = function () {
              return _success.toString();
            };
            return success;
          }(function (data) {
            localStorage.setItem("token", data.token ? data.token : localStorage.getItem("token")); //为token重新赋值
            setTimeout(function () {
              $("#loading").remove();
            }, 50);
            if (data.code == 1) {
              success();
              count = 1;
              pullPublic();
            } else {
              mui.toast(data.msg);
            }
          }),
          error: function error() {
            setTimeout(function () {
              $("#loading").remove();
            }, 50);
            mui.toast("数据提交失败，请稍后重试");
          }
        });
      }
    });
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });

  // 删除单据
  $('body').on('tap', '#del', function () {
    var id = $(this).attr('data-id');
    mui.confirm('确认删除？', '删除', ['否', '是'], function (e) {
      if (e.index == 1) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/SWBankCard/Delete?id=" + id,
          contentType: "application/json; charset=utf-8",
          headers: {
            Authorization: "Bearer " + localStorage.getItem("token")
          },
          dataType: "json",
          beforeSend: function beforeSend() {
            loading();
          },
          success: function (_success2) {
            function success(_x2) {
              return _success2.apply(this, arguments);
            }
            success.toString = function () {
              return _success2.toString();
            };
            return success;
          }(function (data) {
            localStorage.setItem("token", data.token ? data.token : localStorage.getItem("token")); //为token重新赋值
            setTimeout(function () {
              $("#loading").remove();
            }, 50);
            if (data.code == 1) {
              success();
              count = 1;
              pullPublic();
            } else {
              mui.toast(data.msg);
            }
          }),
          error: function error() {
            setTimeout(function () {
              $("#loading").remove();
            }, 50);
            mui.toast("数据提交失败，请稍后重试");
          }
        });
      }
    });
  });
});