$(function () {
  //调试使用
  if (window.vDebug) new VConsole();
  var id = getUrlParam('id');
  var phone = getUrlParam('phone');
  var cardName = getUrlParamZW('cardName');
  cardName && $('#cardName').val(cardName);
  var numberTest = /^([1-9]{1})(\d{14,})$/;
  var bankNameCode = '';
  //银行卡号改变
  $("body").on('input propertychange', "#bankCardNumber", decrementRequest(requestBankName, 2000));
  //银行卡号请求银行名字
  function requestBankName() {
    var carNo = $('#bankCardNumber').val();
    //$('#bankName').val('');
    // 判断是否通过验证
    if (numberTest.test(carNo)) {
      $('#bankCardNumber').removeClass('cuowu-input-new');
      $.ajax({
        type: "POST",
        url: baseRequestUrl + '/Api/SWBankCard/GetBankTypeByCardNo?bankNumber=' + carNo,
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        beforeSend: function beforeSend() {
          //loading();
        },
        success: function success(data) {
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          if (data.code == 1 && data.data.bankTypeName) {
            $('#bankName').val(data.data.bankTypeName);
            $('#bankCardNumber').removeClass('cuowu-input-new');
            bankNameCode = data.data.bankTypeCode;
          } else {
            //mui.toast("请输入标准银行卡号");
          }
        },
        error: function error() {
          questFlag = false;
          //mui.toast("数据获取失败，请稍后重试");
        }
      });
    } else {
      $('#bankCardNumber').addClass('cuowu-input-new');
    }
  }
  // 输入名字
  $("body").on('input propertychange', "#cardName", function () {
    $('#cardName').removeClass('cuowu-input-new');
  });
  //防抖请求
  function decrementRequest(cb, delay) {
    var clear = null;
    return function () {
      if (clear) {
        clearTimeout(clear);
        clear = setTimeout(cb, delay);
      } else clear = setTimeout(cb, delay);
    };
  }

  //点击上传银行卡图片
  var imageUpload = document.getElementById("upgteimg1");
  imageUpload.addEventListener('change', function () {
    if (!imageUpload.files.length) return;
    var nowDate = moment().format("YYYY-MM-DD");
    window.getOSSKey(nowDate).then(function (data) {
      if (data.code == 1) {
        window.getOssDecrypt(data.dataExtend, data.data).then(function (res) {
          if (res.code == 1) {
            localStorage.setItem("token", res.token);
            var text = '';
            nowDate.split('-').forEach(function (item) {
              //将日期格式去除--凭借成字符串20221124
              text += item;
            });
            var reg1 = new RegExp(text, 'g');
            var resData = JSON.parse(res.data.replace(reg1, ''));
            var storeAs = "erp/bankCard/" + getGuid() + imageUpload.files[0].name;
            var OSSclient = new OSS({
              region: resData.KKPoint,
              accessKeyId: resData.KKId,
              accessKeySecret: resData.KKKey,
              bucket: resData.KKName
            });
            loading();
            mask.show();
            OSSclient.multipartUpload(storeAs, imageUpload.files[0]).then(function (result) {
              if (result.res.requestUrls[0]) {
                $.ajax({
                  type: "POST",
                  url: baseRequestUrl + "/Api/SWBankCard/GetBankInfoByCardUrl",
                  contentType: 'application/json; charset=utf-8',
                  headers: {
                    "Authorization": 'Bearer ' + localStorage.getItem('token')
                  },
                  data: JSON.stringify({
                    cardUrl: result.res.requestUrls[0].replace(/\?\S+$/g, '')
                  }),
                  dataType: "json",
                  success: function success(data) {
                    localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
                    setTimeout(function () {
                      $('#loading').remove();
                      mask.close();
                    }, 50);
                    imageUpload.value = "";
                    if (data.code == 1) {
                      if (!data.data) mui.toast('无法找到银行信息');else {
                        $('#bankCardNumber').val(data.data.card_num);
                        $('#bankName').val(data.data.bank_name);
                        bankNameCode = data.data.card_type;
                      }
                    } else mui.toast(data.msg);
                  },
                  error: function error() {
                    setTimeout(function () {
                      $('#loading').remove();
                      mask.close();
                    }, 50);
                    mui.toast("数据提交失败，请稍后重试");
                  }
                });
              } else {
                setTimeout(function () {
                  $('#loading').remove();
                  mask.close();
                }, 50);
                mui.toast("数据提交失败，请稍后重试");
              }
            }).catch(function (err) {
              setTimeout(function () {
                $('#loading').remove();
                mask.close();
              }, 50);
              mui.toast("数据提交失败，请稍后重试");
            });
          }
        });
      }
    });
  }, false);
  if (id) {
    $('.titleName').text('编辑银行卡');
    $('#bc-btn').text('保存');
    $.ajax({
      type: "POST",
      url: baseRequestUrl + '/Api/SWBankCard/GetDetail?id=' + id,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        //loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          bankNameCode = data.data.bankNameCode;
          $('#bankCardNumber').val(data.data.bankCardNumber);
          $('#bankName').val(data.data.bankName);
          $('#cardName').val(data.data.cardName);
          $('#remark').val(data.data.remark);
          if (data.data.isDefault == false) {
            $('#mySwitch').removeClass('mui-active');
          }
        }
      },
      error: function error() {
        questFlag = false;
      }
    });
  }
  var questFlag = false;
  var mask = mui.createMask();
  $('#bc-btn').on('tap', function () {
    var req = {
      bankCardNumber: $('#bankCardNumber').val(),
      cardName: $('#cardName').val(),
      bankName: $('#bankName').val(),
      remark: $('#remark').val(),
      isDefault: $('#mySwitch').hasClass('mui-active'),
      id: getUrlParam("id"),
      bankNameCode: bankNameCode
    };
    if (phone) UpdateDYXX({
      phone: phone,
      item: req
    });else UpdateDYXX(req);
  });

  // 更新或新增银行卡信息
  function UpdateDYXX(data) {
    var url = "/Api/SWBankCard/Add";
    if (data.id && data.id != "") {
      url = "/Api/SWBankCard/Update";
    } else if (phone) url = "/Api/SWBankCard/AddBankByFarmer";
    if (!numberTest.test(phone ? data.item.bankCardNumber : data.bankCardNumber)) {
      $('#bankCardNumber').addClass('cuowu-input-new');
      mui.toast("请输入正确的银行卡号");
      return false;
    }
    if (phone ? !data.item.cardName : !data.cardName) {
      $('#cardName').addClass('cuowu-input-new');
      mui.toast("请输入持卡人姓名");
      return false;
    }
    if (phone ? !data.item.bankName : !data.bankName) {
      $('#bankName').addClass('cuowu-input-new');
      mui.toast("请输入银行名称");
      return false;
    }
    if (questFlag) {
      return;
    }
    questFlag = true;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + url,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(data),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          setTimeout(function () {
            mask.close();
            if (phone) window.location.href = 'index.html';else window.history.go(-1);
          }, 1000);
          mui.toast('操作成功');
          success();
        } else {
          questFlag = false;
          mask.close();
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        questFlag = false;
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(phone ? -2 : -1);
  });
});