$(function () {
  getIsBindWx();
  function getIsBindWx() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/User/HasBindYoonopAccount",
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值
        if (data.code === 1) {
          if (data.data) {
            $('#clearBind').show();
          } else {
            $('#bindWx').show();
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  // 解除微信绑定
  $('#clearBind').on('tap', function () {
    var btnArray = ['取消', '确定'];
    var html = "解绑微信账号后将无法继续使用它登录";
    mui.confirm(html, '确定要解除微信绑定？', btnArray, function (e) {
      if (e.index == 1) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/User/UnBindThirdPartAccount",
          dataType: "json",
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          success: function success(data) {
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值
            if (data.code === 1) {
              $('#clearBind').hide();
              $('#bindWx').show();
              mui.toast("已解除绑定");
            } else {
              mui.toast(data.msg);
            }
          }
        });
      }
    });
  });
  // 绑定微信
  $('#bindWx').on('tap', function () {
    if (JiaoHu) JiaoHu.WxAuth();
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = 'shezhi.html';
  });
});
// 微信登录回调
window.getOpenId = function (openId, unionId) {
  if (JiaoHu) {
    var requestData = {
      openId: openId,
      unionId: unionId,
      isOverride: false
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/User/BindThirdPartAccount",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#clearBind').show();
          $('#bindWx').hide();
          mui.toast("绑定成功");
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据获取失败，请稍后重试");
      }
    });
  }
};