$(function () {
  // 能不能绑定
  var canRegister = false;
  // 倒数计时
  function resetCode() {
    var second = 59;
    var timer = null;
    timer = setInterval(function () {
      second -= 1;
      if (second > 0) {
        $('#yzm-btn').html(second + "秒后点击");
        $('#yzm-btn').addClass("disable");
        $('#yzm-btn').attr("disabled", "true");
      } else {
        clearInterval(timer);
        $('#yzm-btn').html("获取验证码");
        $('#yzm-btn').removeClass("disable");
        $('#yzm-btn').removeAttr("disabled");
      }
    }, 1000);
  }
  // 点击获取验证码
  $("body").on("tap", "#yzm-btn", function () {
    if (canRegister == true) {
      yzmSend();
    } else {
      mui.toast("电话号码未注册或电话号码错误!");
      return false;
    }
  });
  $("#phone").on("change", function (e) {
    //console.log("phone blur==", e.target.value)
    window.getPhoneCode(e.target.value);
  });
  //软键盘enter键绑定
  window.del = function () {
    if (13 == event.keyCode) {
      document.activeElement.blur();
      if (!canRegister) return mui.toast("电话号码未注册或电话号码错误!");
      bindPhone();
    }
  };
  //在手机号码输入到11位时判断是否已经注册
  $("body").on("input propertychange", "#phone", function () {
    if ($("#phone").val().length == 11) {
      validUserAndPhone();
    }
  });
  var mask = mui.createMask();
  // 验证手机号是否已经注册。
  function validUserAndPhone() {
    var phone = $("#phone").val() == "" ? null : $("#phone").val();
    var requestData = {
      "loginName": phone,
      "phone": phone
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/UserVerification",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      success: function success(data) {
        if (data.data) {
          // 已有账号————————可以绑定
          canRegister = true;
        } else {
          canRegister = false;
        }
      },
      error: function error() {
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  ;
  function yzmSend() {
    if (!window.phoneCode) {
      window.getPhoneCode($("#phone").val(), function () {
        _yzmSend();
      });
    } else {
      _yzmSend();
    }
  }
  // 发送验证码
  function _yzmSend() {
    var requestData = {
      phoneCode: window.phoneCode,
      phone: $("#phone").val(),
      sendType: 12
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Erp/SendPhoneMsg",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          resetCode(); //验证码倒计时
          mui.toast("验证码已发送，请注意查收");
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  ;
  var winHeight = $(window).height(); //获取当前页面高度
  $(window).resize(function () {
    var thisHeight = $(this).height();
    if (winHeight - thisHeight > 50) {
      //当软键盘弹出，在这里面操作
      $(".logo-mid").hide();
    } else {
      //当软键盘收起，在此处操作
      $(".logo-mid").show();
    }
  });

  // 绑定
  $('#bind-btn').on('tap', function () {
    if (!canRegister) {
      mui.toast("电话号码未注册或电话号码错误!");
      return;
    }
    bindPhone();
    return;
    var loginName = $('#phone').val();
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Erp/HasBindYoonopAccount?phone=" + loginName,
      contentType: 'application/json; charset=utf-8',
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(item) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (item.code == 1) {
          if (item.data) {
            mui.confirm("该账号已经绑定微信", "提示", ["知道了"]);
          } else {
            bindPhone();
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
  function bindPhone() {
    var openId = getUrlParam("openId");
    var unionId = getUrlParam("unionId");
    var loginName = $('#phone').val();
    var verificationCode = $('#code').val();
    var requestData = {
      unionId: unionId,
      openId: openId,
      loginName: loginName,
      verificationCode: verificationCode,
      isVerification: true,
      isOverride: true
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Erp/BindThirdPartAccountByLoginName",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          mui.toast('绑定成功');
          localStorage.setItem('wxLogin', true);
          loginFun(requestData, "/Api/Erp/LoginWxApp");
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
});
window.zhuceVal;
window.checkVal;