/*
 * @Author: hsl
 * @Descripttion: 分店详情
 * @Date: 2022-03-10 13:52:51
 * @LastEditTime: 2022-03-14 10:01:31
 */
$(function () {
  var userInfo = JSON.parse(localStorage.getItem('cookieUserInfo'));
  var timeout = 3000; //查询支付间隔
  var count = 0; //查询支付次数
  var timer; //定时器ID
  var sourceId; //支付商品ID
  var payMoney; //支付金额
  var chainId; //绑定关系ID
  var branchDetail; //分店详情
  //初始化分店详情
  init(getUrlParam('id'));
  function init(id) {
    $.ajax({
      type: 'POST',
      url: baseRequestUrl + '/Api/BranchStore/GetBranchStoreEntity?id=' + id,
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        Authorization: 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        $('#loading').remove();
        if (data.code === 1) {
          branchDetail = data.data;
          $('.maolimingxi-list').html(juicer($('.maolimingxi-list').html(), branchDetail)).show();
        } else mui.toast(data.msg);
      },
      error: function error() {
        $('#loading').remove();
      }
    });
  }

  //返回按钮
  $('.goBack-btn').on('tap', function () {
    sessionStorage.removeItem('branchDetail');
    window.history.back();
  });

  //点击操作
  var operationPicker = new mui.PopPicker({
    layer: 1
  });
  $('#actions').on('tap', function () {
    var bindState = branchDetail.bindState;
    if (bindState == 0) {
      operationPicker.setData([{
        value: 1,
        text: '缴费'
      }, {
        value: 3,
        text: '删除'
      }, {
        value: 4,
        text: '权限设置'
      }]);
    } else if (bindState == 1 || bindState == 2) {
      operationPicker.setData([{
        value: 2,
        text: '续费'
      }, {
        value: 3,
        text: '删除'
      }, {
        value: 4,
        text: '权限设置'
      }]);
    }
    operationPicker.show(function (item) {
      if (item[0].value === 1 || item[0].value === 2) payOrder();else if (item[0].value === 3) deleteBranch();else showPermissionSet();
    });
  });

  //设置权限
  function showPermissionSet() {
    var html = "\n            <div class=\"permission-block\" ><label>\u662F\u5426\u53EF\u4EE5\u67E5\u770B\u5546\u54C1\u8FDB\u8D27\u4EF7\uFF1A</label>\n                <div><div class=\"mui-switch ".concat(branchDetail.isGoodsState ? 'mui-active' : '', "\" id=\"isGoodsState\">\n                    <div class=\"mui-switch-handle\"></div>\n                </div></div>\n            </div>\n            <div class=\"permission-block\" ><label>\u662F\u5426\u53EF\u4EE5\u8BBE\u7F6E\u4F1A\u5458\u8D26\u6B3E\uFF1A</label>\n                    <div><div class=\"mui-switch ").concat(branchDetail.isSetAccount ? 'mui-active' : '', "\" id=\"isSetAccount\">\n                    <div class=\"mui-switch-handle\"></div>\n                    </div></div>\n            </div>\n            <div class=\"permission-block\" ><label>\u662F\u5426\u53EF\u4EE5\u5BFC\u51FA\u4F1A\u5458\u8D26\u6B3E\uFF1A</label>\n               <div><div class=\"mui-switch ").concat(branchDetail.isSetAccountToExcel ? 'mui-active' : '', "\" id=\"isSetAccountToExcel\">\n                    <div class=\"mui-switch-handle\"></div>\n                </div></div>\n            </div>\n            <div class=\"permission-block\" ><label>\u662F\u5426\u53EF\u4EE5\u7F16\u8F91\u4F1A\u5458\u8D44\u6599\uFF1A</label>\n                <div><div class=\"mui-switch ").concat(branchDetail.isSetModify ? 'mui-active' : '', "\" id=\"isSetModify\">\n                    <div class=\"mui-switch-handle\"></div>\n                </div></div>\n            </div>\n            <div class=\"permission-block\" ><label>\u662F\u5426\u53EF\u4EE5\u5220\u9664\u4F1A\u5458\uFF1A</label>\n                <div><div class=\"mui-switch ").concat(branchDetail.isSetDelete ? 'mui-active' : '', "\" id=\"isSetDelete\">\n                    <div class=\"mui-switch-handle\"></div>\n                </div></div>\n            </div>\n            <div class=\"permission-block\" ><label>\u662F\u5426\u53EF\u4EE5\u6279\u91CF\u5220\u9664\u4F1A\u5458\uFF1A</label>\n                <div><div class=\"mui-switch ").concat(branchDetail.isSetDeleteAll ? 'mui-active' : '', "\" id=\"isSetDeleteAll\">\n                    <div class=\"mui-switch-handle\"></div>\n                </div></div>\n            </div>\n            <div class=\"permission-block\" ><label>\u662F\u5426\u53EF\u4EE5\u8BBE\u7F6E\u4F1A\u5458\u8D4A\u9500\u989D\u5EA6\uFF1A</label>\n                <div><div class=\"mui-switch ").concat(branchDetail.isSetCreditAmount ? 'mui-active' : '', "\" id=\"isSetCreditAmount\">\n                    <div class=\"mui-switch-handle\"></div>\n                </div></div>\n            </div>\n        ");
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle("".concat(branchDetail.branchStoreName, "\u6743\u9650\u8BBE\u7F6E"));
    //弹出框取消
    $('.comfirm-layer').on('tap', '#cancel-btn', function () {
      $(".dialog-mask ").remove();
      $('.comfirm-layer').remove();
    });
    //弹出框确定
    $('.comfirm-layer').on('tap', '#require-btn', function () {
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Member/SetAll",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          id: branchDetail.id,
          storeId: localStorage.getItem('storeId'),
          bindingStoreId: branchDetail.branchStoreId,
          isGoodsState: $('#isGoodsState').hasClass('mui-active'),
          isSetAccount: $('#isSetAccount').hasClass('mui-active'),
          isSetAccountToExcel: $('#isSetAccountToExcel').hasClass('mui-active'),
          isSetDeleteAll: $('#isSetDeleteAll').hasClass('mui-active'),
          isSetModify: $('#isSetModify').hasClass('mui-active'),
          isSetDelete: $('#isSetDelete').hasClass('mui-active'),
          isSetCreditAmount: $('#isSetCreditAmount').hasClass('mui-active')
        }),
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function (_success) {
          function success(_x) {
            return _success.apply(this, arguments);
          }
          success.toString = function () {
            return _success.toString();
          };
          return success;
        }(function (data) {
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          $('#loading').remove();
          if (data.code == 1) {
            mui.toast('设置成功');
            success();
            setTimeout(function () {
              $(".dialog-mask ").remove();
              $('.comfirm-layer').remove();
              window.location.reload();
            }, 1500);
          } else mui.toast(data.msg);
        }),
        error: function error() {
          $('#loading').remove();
          mui.toast('服务器异常，请稍候再试');
        }
      });
    });
    //开关切换
    $('.comfirm-layer').on('tap', '.mui-switch', function () {
      $(this).toggleClass('mui-active');
    });
  }

  //删除分店
  function deleteBranch() {
    mui.confirm('是否删除分店？再次绑定可能需缴费！', '提示', ['否', '是'], function (ev) {
      if (ev.index === 1) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/BranchStore/DeleteBranchStore?branchStoreId=" + branchDetail.branchStoreId,
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          dataType: "json",
          beforeSend: function beforeSend() {
            loading();
          },
          success: function (_success2) {
            function success(_x2) {
              return _success2.apply(this, arguments);
            }
            success.toString = function () {
              return _success2.toString();
            };
            return success;
          }(function (data) {
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            if (data.code == 1) {
              mui.toast('删除成功');
              success();
              setTimeout(function () {
                window.location.reload();
              }, 1500);
            } else mui.toast(data.msg);
          })
        });
      }
    });
  }

  //缴费 续费
  function payOrder() {
    var mainStoreId = localStorage.getItem('storeId');
    var branchStoreId = branchDetail.branchStoreId;
    chainId = branchDetail.id;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/BranchStore/CheckBindNeedPay?branchStoreId=" + branchStoreId + '&mainStoreId=' + mainStoreId + '&isChainStore=true',
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1 && data.data) {
          sourceId = data.data.id;
          payMoney = data.data.memberPrice;
          addOrder();
        } else mui.toast(data.msg);
      }
    });
  }

  //添加订单
  function addOrder() {
    clearTimeout(timer);
    var requestData = {
      sourceType: 1,
      sourceId: sourceId,
      payMoney: payMoney,
      goodsMoney: payMoney,
      payType: JiaoHu.getPinpai() === 'SUNMI' || JiaoHu.getDeviceInfo().includes('newland') ? 'wp' : 'wa',
      sourceObjectId: userInfo.storeId,
      sourceObjectName: userInfo.storeName,
      sourceObjectPhone: userInfo.storeManPhone,
      sourceCreateId: userInfo.userId,
      createPhone: userInfo.telPhone,
      sourceObjectType: 1,
      sourceUrl: window.location.href,
      app: {
        appName: window.isProjectGx ? '广西农药进销存系统' : '优农帮erp',
        wapnName: window.isProjectGx ? '广西农药进销存系统' : '优农帮erp',
        wapUrl: window.isProjectGx ? 'http://gxerp.download.yoonop.com/html/login.html' : 'http://erpdownload.yoonop.com/html/login.html',
        erpDeviceSN: erpDeviceSN,
        erpDeviceNo: erpDeviceNo,
        appId: window.isProjectGx ? 'wxf10591574aabf213' : ''
      }
    };
    $.ajax({
      type: 'POST',
      url: baseRequestUrl + '/Api/PayOrders/Add',
      data: JSON.stringify(requestData),
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        Authorization: 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        $('#loading').remove();
        if (data.code === 1) {
          if (JiaoHu.getPinpai() === 'SUNMI' || JiaoHu.getDeviceInfo().includes('newland')) {
            var html = '<p><img src="img/wchat.png">&nbsp微信扫码：￥' + requestData.payMoney + '元</p>';
            $('.code .pay').html(html);
            $('.code .wait').text('等待用户支付，等待时间2分钟！');
            $('#qrcode').text('');
            $('#qrcode').qrcode({
              render: 'canvas',
              //table方式
              width: 200,
              //宽度
              height: 200,
              //高度
              text: data.data //任意内容
            });

            $('.code-wrapper').show();
            count = 0;
            timeout = 3000;
            intervalTime(data.dataExtend);
          } else {
            JiaoHu.WxPay(data.data);
          }
          bindChain(data.dataExtend);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        $('#loading').remove();
      }
    });
  }

  //循环获取支付结果
  function intervalTime(id) {
    clearTimeout(timer);
    if (count < 10) {
      timer = setTimeout(function () {
        getInfoById(id);
      }, timeout);
    } else {
      count = 0;
      var btnArray = ['取消', '确认'];
      mui.confirm('由于您长时间未付款，二维码已失效，是否刷新二维码？', '提示', btnArray, function (e) {
        if (e.index == 1) addOrder();else {
          clearTimeout(timer);
          $('.code-wrapper').hide('');
        }
      });
    }
  }

  //获取支付信息
  function getInfoById(id) {
    clearTimeout(timer);
    count++;
    $.ajax({
      type: 'POST',
      url: baseRequestUrl + '/Api/PayOrders/InfoById?id=' + id,
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        Authorization: 'Bearer ' + localStorage.getItem('token')
      },
      success: function (_success3) {
        function success(_x3) {
          return _success3.apply(this, arguments);
        }
        success.toString = function () {
          return _success3.toString();
        };
        return success;
      }(function (data) {
        if (data.code === 1) {
          if (data.dataExtend == '已付款') {
            mui.toast('付款成功!', {
              duration: 'long'
            });
            success();
            $('.code-wrapper').hide('');
            setTimeout(function () {
              window.location.reload();
            }, 1500);
          } else intervalTime(id);
        } else mui.toast(data.msg);
      }),
      error: function error() {}
    });
  }

  //绑定支付关系
  function bindChain(id) {
    $.ajax({
      type: 'POST',
      url: baseRequestUrl + '/Api/BranchStore/SetBindPayNo?id=' + chainId + '&payNo=' + id,
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        Authorization: 'Bearer ' + localStorage.getItem('token')
      },
      success: function success(data) {
        if (data.code === 1) {} else mui.toast(data.msg);
      },
      error: function error() {}
    });
  }

  //点击电话进入拨号界面
  $('body').on('tap', '#lxdh', function () {
    if ($(this).text() && useLocal) JiaoHu.phoneCall($(this).text());
  });
});