/*
 * @Author: hsl
 * @Descripttion: 通用收款
 * @Date: 2022-03-16 16:24:18
 * @LastEditTime: 2022-03-29 15:48:01
 */

window.money = 0;
window.payTypeList = [];
// 扫码回调函数
window.getcode = function (s, _s1) {
  if (JiaoHu) {
    var reg = /^[0-9]{18,19}$/;
    if (reg.test(s)) {
      receiveMoney(window.money, s, window.getGuid());
    }
  }
};

//在线收款
window.receiveMoney = function (money, authCode, orderId) {
  var phoneUi = mui;
  loading();
  var request = {
    merchantId: payTypeList[0].merchantId,
    outTradeNo: orderId,
    totalAmount: money * 100,
    accountNo: authCode,
    payWay: payTypeList[0].payList[0].payWay,
    subPayWay: payTypeList[0].payList[0].subPayList.find(function (item) {
      return item.subPayWayStr == 'ScanM';
    }).subPayWay
  };
  $.ajax({
    type: "POST",
    url: baseRequestUrl + "/Api/Pay/UnifiedOrderResult",
    data: JSON.stringify(request),
    dataType: "json",
    contentType: 'application/json; charset=utf-8',
    headers: {
      "Authorization": 'Bearer ' + localStorage.getItem('token')
    },
    success: function success(data) {
      $('#loading').remove();
      // 付款失败
      if (data.code != 1 || !data.data) {
        mui.toast('下单失败，请稍后再试');
      } else {
        //循环获取付款状态
        var timer;
        var interval = 20;
        var flag = false;
        phoneUi.closePopups();
        phoneUi.confirm("用户正在支付，请等待！如需重新扫码，请点击确定！", "提示", ['确定'], function (e) {
          if (e.index == 0 && !flag) {
            flag = true;
            clearInterval(timer);
            if (useLocal) {
              mui.confirm("店主扫码后提醒客户尽快支付！否则60秒后系统将自动撤单！", "请扫码收款", ['取消', '确定'], function (e) {
                if (e.index == 1) {
                  if (useLocal) {
                    JiaoHu.scan();
                  }
                }
              });
            }
          }
        });
        timer = setInterval(function () {
          interval--;
          if (interval == 0) {
            flag = true;
            clearInterval(timer);
          }
          $.ajax({
            type: "POST",
            url: baseRequestUrl + "/Api/Pay/PayOrderQueryByIdResult?id=" + orderId,
            contentType: 'application/json; charset=utf-8',
            headers: {
              "Authorization": 'Bearer ' + localStorage.getItem('token')
            },
            dataType: "json",
            success: function success(item) {
              localStorage.setItem('token', item.token ? item.token : localStorage.getItem('token')); //为token重新赋值F
              if (item.data) {
                flag = true;
                phoneUi.closePopups();
                clearInterval(timer);
                window.receiveMoneyCallback && window.receiveMoneyCallback(item.dataExtend, orderId);
              } else {
                if (item.dataExtend === flase) {
                  //付款失败
                  flag = true;
                  clearInterval(timer);
                  phoneUi.closePopups();
                  phoneUi.toast('支付失败，请稍后再试');
                }
              }
            }
          });
        }, 3000);
      }
    }
  });
};

//获取收款方式
window.queryPayWay = function () {
  $.ajax({
    type: "POST",
    url: baseRequestUrl + "/Api/Pay/GetPayWayQuery",
    dataType: "json",
    contentType: 'application/json; charset=utf-8',
    success: function success(data) {
      if (data.code == 1) window.payTypeList = data.data;else mui.toast(data.msg);
      if (payTypeList.length) {
        $('.activeBtnPay').removeClass('activeBtnPay').siblings('button').addClass('activeBtnPay');
      }
    }
  });
};
//选择收款方式
$('.receive-btn').on('tap', function () {
  if (!window.payTypeList.length && $(this).text('在线收款')) return mui.confirm('您还未开通在线收款功能，如有需要，请联系客服工作人员申请开通！', "提示", ['取消', '联系客服'], function (e) {
    if (e.index && useLocal) {
      JiaoHu.phoneCall('4006125008');
    }
  });
  $(this).addClass('activeBtnPay').siblings('button').removeClass('activeBtnPay');
});

//生成打印数据
function generatePrintData(data) {
  var HeaderList = [{
    Key: '单据类型',
    Value: data.receiptType
  }, {
    Key: '收款店铺',
    Value: JSON.parse(localStorage.getItem('cookieUserInfo')).storeName
  }, {
    Key: '联系方式',
    Value: JSON.parse(localStorage.getItem('cookieUserInfo')).storeManPhone
  }, {
    Key: '付款客户',
    Value: data.memberName
  }, {
    Key: '客户类型',
    Value: data.memberType
  }, {
    Key: '支付金额',
    Value: '￥' + ToMoney(data.payAmount)
  }, {
    Key: '支付方式',
    Value: $('.receive-btn.activeBtnPay').attr('data_value') == 1 ? '现金' : '在线支付'
  }, {
    Key: '单据日期',
    Value: new Date().toLocaleString()
  }, {
    Key: '备注',
    Value: data.remark || '--'
  }];
  if (!data.memberName) HeaderList = HeaderList.filter(function (item) {
    return item.Key !== '付款客户' && item.Key !== '客户类型';
  });
  var BodyList = [];
  var footerList = [{
    Key: '扫码下载农户端，助力种植收成',
    Value: ''
  }];
  var requestPrintData = [{
    styleEntity: {
      Title: "ERP收款回执单",
      //标题
      FontSize: "24" //标题字体大小
    },

    HeaderList: HeaderList,
    //表头信息
    BodyList: {
      "BodyList": BodyList
    },
    //表体信息
    FooterList: footerList,
    qrUrl: 'http://erpdownload.yoonop.com/app_farmer/download.html'
  }];
  return JSON.stringify(requestPrintData);
}

//选择是否打印
$('body').on('tap', '.print_active', function () {
  $(this).toggleClass('mui-active');
});