$(function () {
  //返回
  $('.goBack-btn').on('tap', function () {
    window.location.href = "compositeGoodsManage.html";
  });
  //获取套装id
  var id = getUrlParam('id');
  getGoods();
  function getGoods() {
    $.ajax({
      type: "POST",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      url: baseRequestUrl + "/Api/Suit/Get?id=".concat(id),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        $('#loading').remove();
        if (data.code == 1) {
          console.log(data);
          goodsRender(data.data);
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  //渲染列表
  var img = '';
  function goodsRender(data) {
    var goods = data.requestAddGoodsSuitDetails.map(function (item, index) {
      return "<ul class=\"mui-table-view\"> \n            <li class=\"mui-table-view-cell mui-collapse\">\n                <a class=\"mui-navigate-right\" href=\"#\">".concat(index + 1 + "." + " " + item.goodsName, "</a>\n                <div class=\"mui-collapse-content\">\n                    <p>\u4E0A\u4E0B\u67B6\uFF1A").concat(item.state == 1 ? '上架' : '下架', "</p>\n                    <p>\u89C4&nbsp;&nbsp;&nbsp;\u683C\uFF1A").concat(item.specMetering + item.specUnit + (item.packageUnit.length > 1 ? '*' : '/') + item.packageUnit, "</p>\n                    <p>\u6570&nbsp;&nbsp;&nbsp;\u91CF\uFF1A").concat(item.quantity, "</p>\n                    <p>\u96F6\u552E\u4EF7\uFF1A").concat(parseFloat(item.oldPrice).toFixed(2), "</p>\n                    <p>\u4F1A\u5458\u4EF7\uFF1A").concat(parseFloat(item.price).toFixed(2), "</p>\n                    <p>\u6279\u53D1\u4EF7\uFF1A").concat(parseFloat(item.wholesalePrice).toFixed(2), "</p>\n                </div>\n            </li>\n        </ul>");
    }).join('');
    img = data.minImgUrl ? data.minImgUrl : 'img/zwtp.png';
    var goodsHtml = " \n                        <li class=\"mui-table-view-cell\" id=\"img\"><img style=\"vertical-align: bottom;border-radius: 0.1rem;width:2rem;vertical-align:top;height:2rem;\" src=\"".concat(data.minImgUrl ? data.minImgUrl : 'img/zwtp.png', "\">&nbsp;&nbsp;<p style=\"color:rgb(35, 99, 194);font-size:12px;\">\u70B9\u51FB\u67E5\u770B\u5927\u56FE</p></img></li>\n                        <li class=\"mui-table-view-cell\">\u5957\u88C5\u540D\uFF1A").concat(data.name, "</li>\n                        <li class=\"mui-table-view-cell\">\u6807\u7B7E\u540D\uFF1A").concat(data.goodsClassLabel ? data.goodsClassLabel : '暂无', "</li>   \n                        <li class=\"mui-table-view-cell\">\u96F6\u552E\u4EF7\uFF1A").concat(parseFloat(data.price).toFixed(2), "</li>                       \n                        <li class=\"mui-table-view-cell\">\u4F1A\u5458\u4EF7\uFF1A").concat(parseFloat(data.memberPrice).toFixed(2), "</li>                       \n                        <li class=\"mui-table-view-cell\">\u6279\u53D1\u4EF7\uFF1A").concat(parseFloat(data.tradePrice).toFixed(2), "</li>                                                                                     \n                        <li class=\"mui-table-view-cell\" style=\"font-size:;font-weight:bold;\";>\u5957\u88C5\u8BE6\u60C5\uFF1A</li>                                     \n                      ");
    $('.goodsList').html(goodsHtml + goods);
  }
  //编辑
  $('.edit').on('tap', function () {
    window.location.href = "suitAdd.html?id=" + id;
  });
  //删除
  $('.del').on("tap", function () {
    var btnarr = ["取消", "确定"];
    mui.confirm("你确定删除该套装吗？", "操作提示", btnarr, function (e) {
      console.log(e);
      if (e.index == 1) {
        $.ajax({
          type: "POST",
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          url: baseRequestUrl + "/Api/Suit/Delete?goodsid=".concat(id),
          dataType: "json",
          beforeSend: function beforeSend() {
            loading();
          },
          success: function success(data) {
            $('#loading').remove();
            if (data.code == 1) {
              window.location.href = "compositeGoodsManage.html";
            } else {
              mui.toast(data.msg);
            }
          }
        });
      }
    });
  });
  //点击查看大图
  var pop = false;
  var flag = false;
  $('.mui-card').hide();
  $(".goodsList").on("tap", "#img", function () {
    $('.mui-card').show();
    $('.suitImg').attr('src', img);
    mask.show();
    pop = true;
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    if (pop) {
      pop = false;
      $('.mui-card').hide();
    } else if (flag) {
      flag = false;
    }
  });
  $('.closeImg').on('tap', function () {
    $('.mui-card').hide();
    mask.close();
    pop = false;
  });
});