$(function () {
  var mask = mui.createMask();
  var pageSize = 10;
  var pop = false;
  var flag = false;
  var notdata = false;
  var suitList = [];
  var name = '';
  var goodsClassLabel = '';

  //获取套装列表
  // getSuitList()
  function getSuitList() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Suit/GetPage",
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      async: false,
      data: JSON.stringify({
        "name": name,
        "goodsClassLabel": goodsClassLabel,
        "pageIndex": 1,
        "pageSize": pageSize
      }),
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        $('#loading').remove();
        if (data.code == 1) {
          suitList = data.data;
          notdata = suitList.length > data.totalCount;
          renderList();
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  //渲染列表
  function renderList() {
    if (suitList.length) {
      var suitListHtml = suitList.map(function (item) {
        return "<li class=\"mui-table-view-cell\" data-id=".concat(item.id, ">\n                            <div class=\"suitImg\">\n                                <img style=\"width:1.9rem;height:1.9rem;border-radius: 0.1rem;\" src=\"").concat(item.maxImgUrl ? item.maxImgUrl : 'img/zwtp.png', "\">\n                            </div>\n                            <div class=\"suitText\">\n                                <span style=\"font-size:.44rem\">").concat(item.name, "</span>\n                                <p style=\"overflow: hidden;\n                                text-overflow:ellipsis;\n                                white-space: nowrap;font-size:0.4rem;\">\u660E\u7EC6\uFF1A").concat(item.requestAddGoodsSuitDetails.map(function (elItem) {
          var all = '';
          all += elItem.goodsName;
          return all;
        }), "</p>\n                                <p style=\"font-size:0.4rem;\">\u96F6\u552E\uFF1A").concat(parseFloat(item.price).toFixed(2), "</p>\n                                <p style=\"overflow: hidden;\n                                text-overflow:ellipsis;\n                                white-space: nowrap;font-size:0.4rem;\">\u4F1A\u5458\uFF1A").concat(parseFloat(item.memberPrice).toFixed(2), " &nbsp;&nbsp;\u6279\u53D1\uFF1A").concat(parseFloat(item.tradePrice).toFixed(2), "</p>\n                            </div>\n                        </li>");
      }).join('');
      $('.mui-scroll').html('<ul class="mui-table-view kucun-list mui-table-view-chevron" style="margin-top: 1.2rem;background-color: white;"></ul>');
      $('.kucun-list').html(suitListHtml);
    } else {
      $('.mui-scroll').html('<img style="width:4rem;margin-top:calc(50% - 2rem);margin-left:calc(50% - 2rem)" src="img/zwsj.png"></img>');
    }
  }
  // 蒙版事件
  var mask = mui.createMask(function () {
    if (pop) {
      $('#pop').animate({
        "top": '23rem'
      }, 300, function () {
        pop = false;
      });
    } else if (flag) {
      $('.page2').animate({
        "top": '-11rem'
      }, 300, function () {
        flag = false;
      });
    }
  });
  // 点击筛选按钮事件
  $('#screenList').on('tap', function () {
    if (!flag) {
      $('.page2').animate({
        "top": '0'
      }, 300, function () {
        if (pop) {
          $('#pop').animate({
            "top": '23rem'
          }, 300, function () {
            pop = false;
          });
        }
        flag = true;
        mask.show();
      });
    } else {
      $('.page2').animate({
        "top": '-11rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  //返回
  $('.goBack-btn').on('tap', function () {
    window.location.href = "allMenu.html";
  });
  //新增
  $('.tjtz-btn2').on('tap', function () {
    window.location.href = "xinzengtaozhuang.html";
  });
  //详情
  $('.mui-scroll').on('tap', '.kucun-list .mui-table-view-cell', function (e) {
    console.log($(this).data('id'));
    window.location.href = "suitDetails.html?id=" + $(this).data('id');
  });
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      }
    }
  });
  // 下拉加载具体业务实现
  function pullupRefresh() {
    setTimeout(function () {
      mui('#pullrefresh').pullRefresh().endPullupToRefresh(notdata); //参数为true代表没有更多数据了。
      pageSize += 10;
      getSuitList();
    }, 500);
  }
  //获取搜索的套装名
  $(document).keyup(function (event) {
    if (event.keyCode == 13) {
      if ($('#txtsearch').val()) {
        name = $('#txtsearch').val();
      } else {
        name = '';
      }
      console.log(name);
      getSuitList();
      document.activeElement.blur(); //软键盘收起
    }
  });
  //筛选
  $('.requireBtn').on('tap', function () {
    name = $('#txtsearch').val();
    goodsClassLabel = $('#suitLabel').val();
    getSuitList();
    mui('#pullrefresh').pullRefresh().refresh(true);
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    $('.page2').animate({
      "top": '-11rem'
    }, 300, function () {
      flag = false;
    });
    mask.close();
  });
  //重置
  $('.cancelBtn').on('tap', function () {
    $('#txtsearch').val('');
    $('#suitLabel').val('');
    name = '';
    goodsClassLabel = '';
  });
});