$(function () {
  var selectImg = '<img src="img/mask1.png" style="height:100%;width:100%;background:rgba(0,0,0,0.3);box-shadow: 1px 1px 10px rgba(0,0,0,0.4);">'; //定义选中的图片
  var cropType = JSON.parse(sessionStorage.getItem("cropType")); //获取之前选中的作物
  //获取作物
  getPlant();
  function getPlant() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/CropPestImageDistinguish/GetCropType",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (!data.data || data.data.length == 0) {
            $('.zwsj-box').show();
          } else {
            $('.zwsj-box').hide();
          }
          var tpl = $('#plantListTemp').html();
          var html = juicer(tpl, data);
          $('#plantType').html(html);
          //如果已存在选择的作物，选中该作物
          if (cropType && cropType.cropEnName) {
            $("#plantType .plant").each(function () {
              if ($(this).find(".picture").attr("data_EnName") == cropType.cropEnName) {
                $(this).find(".picture").addClass('plantSelected');
                $(".plantSelected .select").html(selectImg);
                $("#next").attr("disabled", false); //已经有选择的作物后可点击下一步
                $("#next").css("background", "linear-gradient(to right, #24b940, #009b4c");
              }
            });
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  //选择作物
  $("body").on('tap', '#plantType .picture', function () {
    $(this).addClass('plantSelected');
    $(".picture").not(this).removeClass('plantSelected');
    $(".plantSelected .select").html(selectImg);
    $(".picture").not(this).find(".select").html("");
    $("#next").attr("disabled", false); //选择作物后可点击下一步
    $("#next").css("background", "linear-gradient(to right, #24b940, #009b4c");
  });
  //点击下一步
  $("#next").on('tap', function () {
    var cropEnName = $(".plantSelected").attr("data_EnName");
    var cropCnName = $(".plantSelected").attr("data_CnName");
    var cropImage = $(".plantSelected").attr("data_Image");
    var data = {
      cropEnName: cropEnName,
      cropCnName: cropCnName,
      cropImage: cropImage
    };
    sessionStorage.setItem("cropType", JSON.stringify(data)); //存储选中的作物的英文名
    if (cropEnName && cropEnName.length > 0) {
      window.location.href = "distinguish_uploadImage.html";
    }
  });
  //点击返回
  $(".goBack-btn").on('tap', function () {
    sessionStorage.removeItem("cropType");
    window.history.go(-1);
  });
});