$(function () {
  var cropType = JSON.parse(sessionStorage.getItem("cropType")); //获取之前选中的作物
  var uploadImgFlag = false; //避免二次点击识别，请求多次接口
  var delImg = false; //解决删除图片时弹出两个确认框
  var imgUrl = sessionStorage.getItem("imgUrl"); //获取上传的图片的64位编码
  if (imgUrl) {
    $('#img').css('display', 'block');
    $('#img').attr("src", imgUrl);
    $('#del').show();
    $('#noTS').hide();
    $('#hasTS').show();
    $('#imgFile').hide();
    $('#addBTN').hide();
    $("#next").attr("disabled", false); //上传图片后可点击下一步
    $("#next").css("background", "linear-gradient(to right, #24b940, #009b4c");
  } else {
    $('#img').hide();
    $('#del').hide();
    $('#noTS').show();
    $('#hasTS').hide();
  }
  if (cropType) {
    // $('.zwzlImg').html('<img src=' + cropType.cropImage + ' style="width:2.2rem;height:2.2rem;" />')
    $('.zwName').html(cropType.cropCnName);
  }
  function photoCompress(ready, file, w, objDiv) {
    /*开始读取指定的Blob对象或File对象中的内容. 当读取操作完成时,readyState属性的值会成为DONE,如果设置了onloadend事件处理程序,则调用之.同时,result属性中将包含一个data: URL格式的字符串以表示所读取文件的内容.*/
    ready.readAsDataURL(file);
    ready.onload = function () {
      var re = this.result;
      canvasDataURL(re, w, objDiv);
    };
  }
  function canvasDataURL(path, obj, callback) {
    var img = new Image();
    img.src = path;
    img.onload = function () {
      var that = this;
      // 默认按比例压缩
      var w = that.width,
        h = that.height,
        scale = w / h;
      var p;
      if (w > h) {
        p = h / 300;
      } else {
        p = w / 300;
      }
      // w = obj.width || w;
      // h = obj.height || (w / scale);
      w = w / p;
      h = h / p;
      var quality = 1; // 默认图片质量为0.7
      //生成canvas
      var canvas = document.createElement('canvas');
      var ctx = canvas.getContext('2d');
      // 创建属性节点
      var anw = document.createAttribute("width");
      anw.nodeValue = w;
      var anh = document.createAttribute("height");
      anh.nodeValue = h;
      canvas.setAttributeNode(anw);
      canvas.setAttributeNode(anh);
      ctx.drawImage(that, 0, 0, w, h);
      // 图像质量
      if (obj.quality && obj.quality <= 1 && obj.quality > 0) {
        quality = obj.quality;
      }
      // quality值越小，所绘制出的图像越模糊
      var base64 = canvas.toDataURL('image/jpeg', quality);
      // 回调函数返回base64的值
      callback(base64);
    };
  }
  function convertBase64UrlToBlob(urlData) {
    var arr = urlData.split(','),
      mime = arr[0].match(/:(.*?);/)[1],
      bstr = atob(arr[1]),
      n = bstr.length,
      u8arr = new Uint8Array(n);
    while (n--) {
      u8arr[n] = bstr.charCodeAt(n);
    }
    return new Blob([u8arr], {
      type: mime
    });
  }
  /**
   * 将以base64的图片url数据转换为File
   * @param urlData
   *            用url方式表示的base64图片数据
   */
  function convertBase64UrlToFile(urlData) {
    var bytes = window.atob(urlData.split(',')[1]); //去掉url的头，并转换为byte

    //处理异常,将ascii码小于0的转换为大于0
    var ab = new ArrayBuffer(bytes.length);
    var ia = new Uint8Array(ab);
    for (var i = 0; i < bytes.length; i++) {
      ia[i] = bytes.charCodeAt(i);
    }
    return new File([ab], "uploadImg.jpg", {
      type: 'image/jpg'
    });
  }
  //图片上传
  $('#imgFile').on('change', function () {
    var img = document.getElementById("img");
    var file = document.querySelector('input[type=file]').files[0];
    var reader = new FileReader();
    if (!/^image.+$/i.test(file.type)) return mui.toast('暂不支持此格式附件上传，请选择其他附件');
    if (file.size / 1024 > 1025) photoCompress(reader, file, {
      quality: 1
    }, function (base64Codes) {
      console.info();
      $('#img').css('display', 'block');
      $('#del').show();
      $('#noTS').hide();
      $('#hasTS').show();
      $(img).show();
      $('#imgFile').hide();
      $('#addBTN').hide();
      img.src = base64Codes; // 存储在本地的图片的base64编码
      sessionStorage.setItem("imgUrl", base64Codes);
      $("#next").attr("disabled", false); //上传图片后可点击下一步
      $("#next").css("background", "linear-gradient(to right, #24b940, #009b4c");
      if (file) reader.readAsDataURL(file);
    });else {
      reader.addEventListener("load", function () {
        $('#img').css('display', 'block');
        $('#del').show();
        $('#noTS').hide();
        $('#hasTS').show();
        $(img).show();
        $('#imgFile').hide();
        $('#addBTN').hide();
        img.src = reader.result; // 存储在本地的图片的base64编码
        sessionStorage.setItem("imgUrl", reader.result);
        $("#next").attr("disabled", false); //上传图片后可点击下一步
        $("#next").css("background", "linear-gradient(to right, #24b940, #009b4c");
      }, false);
      if (file) reader.readAsDataURL(file);
    }
  });
  // 点击图片放大
  $('#img').on('click', function () {
    $('#img2').attr('src', $('#img').attr('src'));
    $('#lookIMG').css({
      display: 'block'
    });
    $('.closeIMG').on('click', function () {
      $('#lookIMG').hide();
    });
    $('.delImg').on('click', function () {
      if (!delImg) {
        delImg = true;
        var btnArray = ['否', '是'];
        mui.confirm('确认删除？', '删除', btnArray, function (e) {
          if (e.index == 1) {
            sessionStorage.removeItem("imgUrl");
            $('#img').hide();
            $('#del').hide();
            $('#noTS').show();
            $('#hasTS').hide();
            $('#imgFile').show();
            $('#addBTN').show();
            $('#imgFile').val('');
            $("#next").attr("disabled", true); //上传图片后可点击下一步
            $("#next").css("background", "#aaa");
            $('#lookIMG').hide();
            delImg = false;
          } else {
            delImg = false;
            return false;
          }
        });
      }
    });
  });
  //点击左上角删除图片
  $('.imgDiv #del').on('click', function () {
    var btnArray = ['否', '是'];
    mui.confirm('确认删除？', '删除', btnArray, function (e) {
      if (e.index == 1) {
        sessionStorage.removeItem("imgUrl");
        $('#img').hide();
        $('#del').hide();
        $('#noTS').show();
        $('#hasTS').hide();
        $('#imgFile').show();
        $('#addBTN').show();
        $('#imgFile').val('');
        $("#next").attr("disabled", true); //上传图片后可点击下一步
        $("#next").css("background", "#aaa");
      } else {
        return false;
      }
    });
  });
  //点击下一步
  $("#next").on('tap', function () {
    if (!uploadImgFlag) {
      uploadImgFlag = true;
      var ready = new FileReader();
      var file = imgUrl ? convertBase64UrlToFile(imgUrl) : document.querySelector('input[type=file]').files[0];
      var formData = new FormData();
      if (!/^image.+$/i.test(file.type)) return mui.toast('暂不支持此格式附件上传，请选择其他附件');
      //上传图片并识别
      if (file.size / 1024 > 1025) {
        //大于1M，进行压缩上传
        photoCompress(ready, file, {
          quality: 1
        }, function (base64Codes) {
          var bl = convertBase64UrlToBlob(base64Codes);
          formData.append("file", bl, "file_" + Date.parse(new Date()) + ".jpg"); // 文件对象
          // $('#img').show()
          $.ajax({
            type: "POST",
            url: baseRequestUrl + "/Api/CropPestImageDistinguish/Distinguish?CropEnName=" + cropType.cropEnName,
            contentType: false,
            headers: {
              "Authorization": 'Bearer ' + localStorage.getItem('token')
            },
            data: formData,
            processData: false,
            sync: false,
            dataType: 'json',
            beforeSend: function beforeSend() {
              loading();
            },
            success: function success(data) {
              $('#loading').remove();
              if (data.Data) for (var i = 0; i < data.Data.length; i++) {
                if (!data.Data[i].Introduction || data.Data[i].Introduction == "") {
                  data.Data[i].Introduction = "无"; //简介为null或空变成无存储
                }

                if (!data.Data[i].Control || data.Data[i].Control == "") {
                  data.Data[i].Control = "无"; //防治
                }

                if (!data.Data[i].DamageSymptoms || data.Data[i].DamageSymptoms == "") {
                  data.Data[i].DamageSymptoms = "无"; //危害症状
                }

                if (!data.Data[i].DefaultImg || data.Data[i].DefaultImg == "") {
                  data.Data[i].DefaultImg = "img/zwtp.png"; //图片
                }
              }

              sessionStorage.setItem("distinguishResult", JSON.stringify(data));
              setTimeout(function () {
                uploadImgFlag = false;
                window.location.href = "distinguish_result.html";
              }, 100);
            },
            error: function error() {
              setTimeout(function () {
                $('#loading').remove();
              }, 50);
              mui.toast("数据提交失败，请稍后重试");
              $(".mui-popup").remove();
              uploadImgFlag = false;
            }
          });
        });
      } else {
        //小于等于1M 原图上传
        formData.append("file", file); // 文件对象
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/CropPestImageDistinguish/Distinguish?CropEnName=" + cropType.cropEnName,
          contentType: false,
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          data: formData,
          processData: false,
          sync: false,
          dataType: 'json',
          beforeSend: function beforeSend() {
            loading();
          },
          success: function success(data) {
            $('#loading').remove();
            if (data.Data) for (var i = 0; i < data.Data.length; i++) {
              if (!data.Data[i].Introduction || data.Data[i].Introduction == "") {
                data.Data[i].Introduction = "无"; //简介为null或空变成无存储
              }

              if (!data.Data[i].Control || data.Data[i].Control == "") {
                data.Data[i].Control = "无"; //防治
              }

              if (!data.Data[i].DamageSymptoms || data.Data[i].DamageSymptoms == "") {
                data.Data[i].DamageSymptoms = "无"; //危害症状
              }

              if (!data.Data[i].DefaultImg || data.Data[i].DefaultImg == "") {
                data.Data[i].DefaultImg = "img/zwtp.png"; //图片
              }
            }

            sessionStorage.setItem("distinguishResult", JSON.stringify(data));
            setTimeout(function () {
              uploadImgFlag = false;
              window.location.href = "distinguish_result.html";
            }, 100);
          },
          error: function error() {
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            mui.toast("数据提交失败，请稍后重试");
            $(".mui-popup").remove();
            uploadImgFlag = false;
          }
        });
      }
    }
  });
  //点击返回
  $(".goBack-btn").on('tap', function () {
    sessionStorage.removeItem("imgUrl");
    window.history.go(-1);
  });
});