$(function () {
  var input1 = document.getElementById("upgteimg1");
  var input2 = document.getElementById("upgteimg2");
  var input3 = document.getElementById("upgteimg3");
  var input4 = document.getElementById("upgteimg4");
  var showui1 = document.getElementById("showui1");
  var showui2 = document.getElementById("showui2");
  var showui3 = document.getElementById("showui3");
  var showui4 = document.getElementById("showui4");
  var dataArr = sessionStorage.getItem('uploadImg') ? JSON.parse(sessionStorage.getItem('uploadImg')) : []; // 储存所选图片的结果(文件名和base64数据)
  /**
  * 将以base64的图片url数据转换为File
  * @param urlData
  *            用url方式表示的base64图片数据
  */
  if (typeof FileReader === 'undefined') {
    alert("抱歉，你的浏览器不支持 FileReader");
    input1 && input1.setAttribute('disabled', 'disabled');
    input2 && input2.setAttribute('disabled', 'disabled');
    input3 && input3.setAttribute('disabled', 'disabled');
    input4 && input4.setAttribute('disabled', 'disabled');
  } else {
    input1 && input1.addEventListener('change', function () {
      readFile(input1, showui1, 1, '#upgteimg1');
    }, false);
    input2 && input2.addEventListener('change', function () {
      readFile(input2, showui2, 3, '#upgteimg2');
    }, false);
    input3 && input3.addEventListener('change', function () {
      readFile(input3, showui3, 4, '#upgteimg3');
    }, false);
    input4 && input4.addEventListener('change', function () {
      readFile(input4, showui4, 5, '#upgteimg4');
    }, false);
  }
  showui1 && showui1.addEventListener("click", function () {
    onclickimg('#showui1', '#upgteimg1');
  }, true);
  showui2 && showui2.addEventListener("click", function () {
    onclickimg("#showui2", '#upgteimg2');
  }, true);
  showui3 && showui3.addEventListener("click", function () {
    onclickimg("#showui3", '#upgteimg3');
  }, true);
  showui4 && showui4.addEventListener("click", function () {
    onclickimg("#showui4", '#upgteimg4');
  }, true);
  window.showImgList = function (dataArr) {
    if ((window.location.href.includes('xiaohui.html') || window.location.href.includes('jiehuo_jinhuo_add.html') || window.location.href.includes('storeTrainProve_addOrEdit.html')) && sessionStorage.getItem('uploadImg')) {
      for (var index = 0; index < dataArr.length; index++) {
        var result = '<div class="showdiv"><img class="center" src="img/delete.svg" /></div><img style="width:100%;height:100%;" id="img' + index + randomString(1) + randomString(2) + randomString(5) + '" class="showimg" src="' + dataArr[index].imageUrl + '" data_src="' + dataArr[index].imageUrl + '" />';
        var li = document.createElement('li');
        li.innerHTML = result;
        showui1.appendChild(li);
      }
    }
  };
  if ((window.location.href.includes('xiaohui.html') || window.location.href.includes('jiehuo_jinhuo_add.html') || window.location.href.includes('storeTrainProve_addOrEdit.html')) && sessionStorage.getItem('uploadImg')) {
    for (var index = 0; index < dataArr.length; index++) {
      var result = '<div class="showdiv"><img class="center" src="img/delete.svg" /></div><img style="width:100%;height:100%;" id="img' + index + randomString(1) + randomString(2) + randomString(5) + '" class="showimg" src="' + dataArr[index].imageUrl + '" data_src="' + dataArr[index].imageUrl + '" />';
      var li = document.createElement('li');
      li.innerHTML = result;
      showui1.appendChild(li);
    }
  }
  var fd; //FormData方式发送请求
  var currentReViewImgIndex = 0;
  function randomString(len) {
    len = len || 32;
    var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; /****默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1****/
    var maxPos = $chars.length;
    var pwd = '';
    for (i = 0; i < len; i++) {
      pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
    }
    return pwd;
  }
  function photoCompress(ready, file, w, objDiv) {
    /*开始读取指定的Blob对象或File对象中的内容. 当读取操作完成时,readyState属性的值会成为DONE,如果设置了onloadend事件处理程序,则调用之.同时,result属性中将包含一个data: URL格式的字符串以表示所读取文件的内容.*/
    ready.readAsDataURL(file);
    ready.onload = function () {
      var re = this.result;
      canvasDataURL(re, w, objDiv);
    };
  }
  function canvasDataURL(path, obj, callback) {
    var img = new Image();
    img.src = path;
    img.onload = function () {
      var that = this;
      // 默认按比例压缩
      var w = that.width,
        h = that.height,
        scale = w / h;
      var p;
      if (w > h) {
        p = h / 500;
      } else {
        p = w / 500;
      }
      // w = obj.width || w;
      // h = obj.height || (w / scale);
      w = w / p;
      h = h / p;
      var quality = 1; // 默认图片质量为0.7
      //生成canvas
      var canvas = document.createElement('canvas');
      var ctx = canvas.getContext('2d');
      // 创建属性节点
      var anw = document.createAttribute("width");
      anw.nodeValue = w;
      var anh = document.createAttribute("height");
      anh.nodeValue = h;
      canvas.setAttributeNode(anw);
      canvas.setAttributeNode(anh);
      ctx.drawImage(that, 0, 0, w, h);
      // 图像质量
      if (obj.quality && obj.quality <= 1 && obj.quality > 0) {
        quality = obj.quality;
      }
      // quality值越小，所绘制出的图像越模糊
      var base64 = canvas.toDataURL('image/jpeg', quality);
      // 回调函数返回base64的值
      callback(base64);
    };
  }
  function convertBase64UrlToBlob(urlData) {
    var arr = urlData.split(','),
      mime = arr[0].match(/:(.*?);/)[1],
      bstr = atob(arr[1]),
      n = bstr.length,
      u8arr = new Uint8Array(n);
    while (n--) {
      u8arr[n] = bstr.charCodeAt(n);
    }
    return new Blob([u8arr], {
      type: mime
    });
  }

  //图片上传
  function guid() {
    function S4() {
      return ((1 + Math.random()) * 0x10000 | 0).toString(16).substring(1);
    }
    return S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4();
  }
  function readFile(input, showui, type, divId) {
    //上传
    console.log('readfile');
    fd = new FormData();
    var iLen = input.files.length;
    for (var i = 0; i < iLen; i++) {
      if (!input['value'].match(/.jpg|.gif|.png|.jpeg|.bmp/i)) {
        //判断上传文件格式
        return alert("上传的图片格式不正确，请重新选择");
      }
      var reader = new FileReader();
      reader.index = i;
      fd.append(i, input.files[i]);
      reader.readAsDataURL(input.files[i]); //转成base64
      reader.fileName = input.files[i].name;
      reader.files = input.files[i];
      reader.onload = function (e) {
        var file = document.querySelector(divId).files[e.target.index];
        //上传图片并识别
        if (file.size / 1024 / 1024 < constantsImgSize) {
          photoCompress(reader, file, {
            quality: 1
          }, function (base64Codes) {
            var nowDate = moment().format("YYYY-MM-DD");
            window.getOSSKey(nowDate).then(function (data) {
              if (data.code == 1) {
                window.getOssDecrypt(data.dataExtend, data.data).then(function (res) {
                  if (res.code == 1) {
                    localStorage.setItem("token", res.token);
                    var text = '';
                    nowDate.split('-').forEach(function (item) {
                      //将日期格式去除--凭借成字符串20221124
                      text += item;
                    });
                    var reg1 = new RegExp(text, 'g');
                    var resData = JSON.parse(res.data.replace(reg1, ''));
                    makeWaterMark2(JSON.parse(window.localStorage.getItem('cookieUserInfo')).storeName, convertTime(), base64Codes, function (resultCode) {
                      // $('#img').show()
                      var bl = convertBase64UrlToBlob(resultCode);
                      var aafile = new File([bl], "file_" + Date.parse(new Date()) + ".png");
                      /**
                      * 生成文件名
                      * @returns
                      */
                      function timestamp() {
                        var time = new Date();
                        var y = time.getFullYear();
                        var m = time.getMonth() + 1;
                        var d = time.getDate();
                        var h = time.getHours();
                        var mm = time.getMinutes();
                        var s = time.getSeconds();
                        return "" + y + add0(m) + add0(d) + add0(h) + add0(mm) + add0(s);
                      }
                      function add0(m) {
                        return m < 10 ? '0' + m : m;
                      }
                      var storeAs = "erp/StoreInfo/" + guid() + timestamp() + file.name;
                      var OSSclient = new OSS({
                        region: resData.KKPoint,
                        accessKeyId: resData.KKId,
                        accessKeySecret: resData.KKKey,
                        bucket: resData.KKName
                      });
                      loading();
                      OSSclient.multipartUpload(storeAs, aafile).then(function (result) {
                        var imgMsg = {
                          imageUrl: result.res.requestUrls[0].replace(/\?\S+/g, ''),
                          //获取文件名
                          imageType: type //
                        };

                        dataArr.push(imgMsg);
                        if ($(showui).children().length >= 4) {
                          $(input).parent('.upimg').hide();
                        }
                        for (var j = 0; j < dataArr.length; j++) {
                          currentReViewImgIndex = j;
                        }
                        result = '<div class="showdiv"><img  class="center" src="img/delete.svg" /></div><img style="width:100%;height:100%;" id="img' + currentReViewImgIndex + randomString(1) + randomString(2) + randomString(5) + '" class="showimg" src="' + result.res.requestUrls[0] + '" data_src="' + result.res.requestUrls[0] + '" />';
                        var li = document.createElement('li');
                        li.innerHTML = result;
                        showui.appendChild(li);
                        input1.value = '';
                        sessionStorage.setItem('uploadImg', JSON.stringify(dataArr));
                        $('#loading').remove();
                      }).catch(function (err) {
                        $('#loading').remove();
                        $(".mui-popup").remove();
                      });
                    });
                  }
                });
              }
            });
          });
        } else {
          mui.toast('图片大小必须小于' + constantsImgSize + 'M');
        }
      };
    }
  }
  function onclickimg(showui, input) {
    //删除
    var dataArrlist = dataArr.length;
    var lilength = document.querySelectorAll('ul' + showui + ' li');
    for (var i = 0; i < lilength.length; i++) {
      //删除图标
      lilength[i].getElementsByTagName('img')[0].onclick = function (num) {
        return function () {
          if (dataArr.length == 1) {
            dataArr = [];
            $("ul" + showui).html("");
          } else {
            var imgSrc = $("ul" + showui + " li:eq(" + num + ") .showimg").attr('data_src');
            $("ul" + showui + " li:eq(" + num + ")").remove();
          }
          for (var k = 0; k < dataArr.length; k++) {
            if (dataArr[k].imageUrl == imgSrc) {
              dataArr.splice(k, 1);
            }
          }
          dataArr.length ? sessionStorage.setItem('uploadImg', JSON.stringify(dataArr)) : sessionStorage.removeItem('uploadImg');
          if ($(showui).children().length <= 4) {
            $(input).parent('.upimg').show();
          }
        };
      }(i);
    }
  }

  /**
   * 
   * @param {农资店} content1 
   * @param {时间戳} content2 
   * @param {base64Code} result 
   * @param {回掉函数} callback 
   */
  function makeWaterMark2(content1, content2, result, callback) {
    var img = new Image(); //创建一个img标签来放选中的图片（使用newImage()也可以）
    img.src = result; //result是FileReader对象中图片的地址信息
    img.onload = function () {
      //因为异步加载原因，当选中的图片加载完成，开始使用canvas画水印，如果没有这一步，canvas.toDataURL（）方法有可能装换不了base64图片
      var w = ""; //canvas未定义宽高，使用选中图片的宽高，方便定义水印的大小
      var h = "";
      var quality = 0.8; //默认图片质量为0.8
      var canvas = document.createElement('canvas');
      var ctx = canvas.getContext("2d");
      w = img.width;
      h = img.height;
      canvas.height = h;
      canvas.width = w;
      ctx.drawImage(img, 0, 0, w, h);
      ctx.font = "13px 微软雅黑";
      ctx.fillStyle = "rgba(255,255,255,0.55)";
      ctx.fillText(content1, 10, h - 26); //水印的内容和水印的位置
      ctx.font = "11px 微软雅黑";
      ctx.fillText(content2, 10, h - 10); //水印的内容和水印的位置
      var dataUrl = canvas.toDataURL("image/jpeg", quality); //通过方法把图片转成base64
      callback && callback(dataUrl);
    };
  }
  //转换时间
  function convertTime() {
    var time = new Date();
    var year = time.getFullYear() + '';
    var month = time.getMonth() + 1 + '';
    var day = time.getDate() + '';
    var hour = time.getHours() + '';
    var minutes = time.getMinutes() + '';
    var seconds = time.getSeconds() + '';
    return "".concat(year, "-").concat(month.length === 1 ? '0' + month : month, "-").concat(day.length === 1 ? '0' + day : day, " ").concat(hour.length === 1 ? '0' + hour : hour, ":").concat(minutes.length === 1 ? '0' + minutes : minutes, ":").concat(seconds.length === 1 ? '0' + seconds : seconds);
  }
});