function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/*
 * @Author: hsl
 * @Descripttion: 分销商库存表
 * @Date: 2022-04-14 09:50:02
 * @LastEditTime: 2022-04-18 13:57:23
 */
$(function () {
  //修改select的!important样式
  $(".mySelect").css("cssText", "border:1px solid #c7cac7 !important");
  //分类和标签全局变量
  var SPType = [];
  var goodDatas = [];
  var pageIndex = 1; //count 表示页数
  var goodsType = null;
  var goodsCategoryCode = "";
  var earlyWarningState = getUrlParam("earlyWarningState") || undefined;
  var queryGoodsName = getUrlParam("goodsName");
  var dbcbGoodsName = sessionStorage.getItem("dbcbGoodsName");
  var isChaxun = false; //防止连续点击两次而请求两次接口
  var isTYYJ = false;
  var disPopPicker = new mui.PopPicker({
    layer: 1
  });
  var disId = getUrlParam("disId") || undefined;
  if (disId) {
    earlyWarningState = 1;
    $('.earlyWarningState button').eq(2).addClass('activeBtn').siblings().removeClass('activeBtn');
  }
  initPage();
  function initPage() {
    $.ajax({
      type: "POST",
      async: true,
      url: baseRequestUrl + '/Api/GoodsStockSupplier/GetIsLookStoreList',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1 && data.data.length) {
          disPopPicker.setData(data.data.map(function (item) {
            return {
              value: item.value,
              text: item.label
            };
          }));
          if (!disId) disId = data.data[0].value;
          disPopPicker.pickers[0].setSelectedValue(disId, 200);
          $('#branches').text(data.data[0].label);
          //下拉加载
          mui.init({
            swipeBack: true,
            //启用右滑关闭功能
            pullRefresh: {
              container: '#pullrefresh',
              subpages: [{
                url: window.location.href,
                //下拉刷新内容页面地址
                id: '#pullrefresh',
                //内容页面标志
                styles: {
                  top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
                  //其它参数定义
                }
              }],

              up: {
                contentrefresh: '正在加载...',
                callback: pullupRefresh,
                auto: true
              }
            }
          });
        } else {
          mui.toast('暂无下属分销商！');
        }
      }
    });
  }

  // 加载查询商品列表
  function loadGoodsLst() {
    var storeId = JSON.parse(localStorage.getItem(CookieName)).storeId;
    var goodsName = $("#goodsName").val();
    if (goodsCategoryCode == "") {
      goodsCategoryCode = null;
    }
    if (goodsType == "") goodsType = undefined;
    //获取库存列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/GoodsStockSupplier/GetGoodsList",
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify({
        storeId: disId,
        "mainStoreId": storeId,
        "goodsName": queryGoodsName ? dbcbGoodsName : goodsName,
        "goodsType": $('.orderType .activeBtn').val(),
        "goodsCategoryCode": $('.mySelect').find("option:selected").attr("id"),
        "earlyWarningState": earlyWarningState,
        "pageIndex": pageIndex,
        "pageSize": 99
      }),
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        isChaxun = false;
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 99 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1 && data.data.length) {
          data.data = data.data.reduce(function (init, item) {
            init.push(item);
            if (item.children && item.children.length) {
              var _iterator = _createForOfIteratorHelper(item.children),
                _step;
              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  var _i = _step.value;
                  init.push(_i);
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }
            }
            return init;
          }, []);
          data.data = data.data.map(function (item) {
            item.morePackages = data.data.filter(function (i) {
              return i.baseGoodsId === item.baseGoodsId;
            }).map(function (a) {
              return {
                specifications: a.specifications,
                id: a.goodsId,
                packageLevel: a.packageLevel
              };
            }).sort(function (a, b) {
              return a.packageLevel - b.packageLevel;
            });
            if (item.morePackages.length < 2) item.morePackages = [];
            item.show = !item.morePackages.length ? true : item.morePackages.find(function (b) {
              return item.packageLevel > b.packageLevel;
            }) ? false : true;
            return item;
          });
          var tpl = $("#kucunListTemp").html();
          var html = juicer(tpl, data);
          if (html.trim() != "") {
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              goodDatas = data.data;
              $("#kucunList").html(html);
            } else {
              for (var i = 0; i < data.data.length; i++) {
                goodDatas.push(data.data[i]);
              }
              $("#kucunList").append(html);
            }
            pageIndex++;
          }
        } else {
          if (pageIndex == 1) {
            $("#kucunList").html("");
            $(".zwsj-box").show();
            $('#loading').remove();
          }
        }
      }
    });
  }

  //选择分销商
  $('#btn_branches').on('tap', function () {
    disPopPicker.show(function (item) {
      disId = item[0].value;
      $('#branches').text(item[0].text);
      disPopPicker.pickers[0].setSelectedValue(item[0].value, 200);
    });
  });

  //多包装商品选择包装
  var packagePicker = new mui.PopPicker({
    layer: 1
  });
  $('#kucunList').on('tap', '.package-btn', function (e) {
    var _this = this;
    e.stopPropagation();
    var item = goodDatas.find(function (i) {
      return i.goodsId === $(_this).attr('data-id');
    });
    packagePicker.setData(item.morePackages.map(function (a) {
      return {
        text: a.specifications,
        value: a.id,
        packageLevel: a.packageLevel
      };
    }));
    packagePicker.pickers[0].setSelectedValue(item.goodsId, 200);
    packagePicker.show(function (item) {
      if (item[0].value === $(_this).attr('data-id')) return;
      goodDatas.forEach(function (it) {
        if (it.goodsId === item[0].value || it.goodsId === $(_this).attr('data-id')) it.show = !it.show;
      });
      var tpl = $("#kucunListTemp").html();
      var html = juicer(tpl, {
        data: goodDatas
      });
      $("#kucunList").html(html);
    });
  });
  //获取商品分类
  getSPType();
  function getSPType() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/GoodsBase/GoodsType",
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      success: function success(data) {
        SPType = data.data.goodsType;
        selectRender();
      }
    });
  }

  //详细类型select
  function selectRender(type) {
    $(".mySelect").html("<option value disabled selected>-暂无详细类型-</option>");
    $('#loading').remove();
    if (type == "") $(".mySelect").html("<option value disabled selected>-暂无详细类型-</option>");
    if (type && SPType.length && type != "") {
      var arr = SPType.filter(function (item) {
        return item.parentId == type;
      });
      var arrHtml = arr.map(function (item) {
        return "<option value=\"".concat(item.label, "\" id=\"").concat(item.value, "\">").concat(item.label, "</option>");
      }).join();
      $(".mySelect").html("<option value disabled selected>-请选择详细类型-</option>" + arrHtml);
    }
  }

  // 扫码触发事件
  $(".icon-saoma").on("tap", function () {
    if (useLocal) JiaoHu.scan();
  });

  //下拉刷新
  function pullfreshF5() {
    goodsName = $("#goodsName").val();
    setTimeout(function () {
      pageIndex = 1;
      loadGoodsLst();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  function pullupRefresh() {
    loadGoodsLst();
  }

  //单个分销配货
  $("body").on('tap', '.online-btn', function () {
    var _this2 = this;
    var transGoods = goodDatas.filter(function (item) {
      return item.goodsId === $(_this2).attr('data-id');
    }).map(function (item) {
      return {
        goodsName: item.goodsName,
        specifications: item.specifications,
        poornum: item.number - item.goodsQuantity
      };
    });
    if (transGoods.length) {
      sessionStorage.setItem('transGoods', JSON.stringify({
        warnGoods: transGoods,
        disId: disId
      }));
      window.location.href = "onlineSale.html";
    } else mui.toast("当前页无库存不足商品，无需进行分销配货");
  });
  //统一分销配货
  $("body").on('tap', '#onlineSale', function () {
    mui('#popover').popover('hide');
    var transGoods = goodDatas.filter(function (item) {
      return item.goodsQuantity < item.number;
    }).map(function (item) {
      return {
        goodsName: item.goodsName,
        specifications: item.specifications,
        poornum: item.number - item.goodsQuantity
      };
    });
    if (transGoods.length) {
      sessionStorage.setItem('transGoods', JSON.stringify({
        warnGoods: transGoods,
        disId: disId
      }));
      window.location.href = "onlineSale.html";
    } else mui.toast("当前页无库存不足商品，无需进行分销配货");
  });

  //统一预警设置按钮
  $("body").on('tap', '#kucunList li .orderList,#tyyj,.warn-btn', function () {
    mui('#popover').popover('hide');
    var id = $(this).attr('data-id'),
      relationId = $(this).attr('data-relationId'),
      goodsName = $(this).attr('data-goodsName'),
      specifications = $(this).attr('data-specifications');
    var mask = mui.createMask();
    var btnArray = ['取消', '保存'];
    var html = '<div class="tcc">';
    html += '<p><label style="color:black">预警库存：</label><input style="color:black;font-size:.4rem" type="number" id="zxkc" placeholder="请输入预警库存" oninput="if(value.length>5)value=value.slice(0,5)" /></p>';
    html += '</div>';
    mask.show();
    mui.confirm(html, '预警设置', btnArray, function (e) {
      if (e.index == 1) {
        if (!isTYYJ) {
          isTYYJ = true;
          var zxkc = $("#zxkc").val();
          var reg = /^([1-9]\d*|[0]{1,1})$/;
          var yz = reg.test(zxkc);
          var zxkc1 = zxkc[0];
          var yz2 = false;
          if (zxkc == "") {
            mask.show();
            mui.alert('请输入最小库存', '', function () {
              mask.close();
            });
            return false;
          }
          //判断首位不能为0
          if (zxkc.length > 1) {
            if (zxkc1 != 0) {
              yz2 = true;
            }
          } else {
            yz2 = true;
          }
          if (yz == false || yz2 == false) {
            mask.show();
            mui.alert('请输入整数数量', '', function () {
              mask.close();
            });
            return false;
          }
          $.ajax({
            type: "POST",
            url: baseRequestUrl + (id ? '/Api/GoodsStockSupplier/Add' : "/Api/GoodsStockSupplier/AddAll"),
            contentType: 'application/json; charset=utf-8',
            headers: {
              "Authorization": 'Bearer ' + localStorage.getItem('token')
            },
            data: JSON.stringify(id ? {
              "mainStoreId": localStorage.getItem('storeId'),
              "branchStoreId": disId,
              "number": zxkc,
              goodsId: id,
              id: relationId || undefined,
              goodsName: goodsName,
              specifications: specifications
            } : {
              "mainStoreId": localStorage.getItem('storeId'),
              "branchStoreId": disId,
              "number": zxkc
            }),
            dataType: "json",
            beforeSend: function beforeSend() {
              loading();
              mask.show();
            },
            success: function (_success) {
              function success(_x) {
                return _success.apply(this, arguments);
              }
              success.toString = function () {
                return _success.toString();
              };
              return success;
            }(function (data) {
              localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
              setTimeout(function () {
                $('#loading').remove();
                isTYYJ = false;
              }, 50);
              if (data.code == 1) {
                mui.toast("设置成功");
                $(".mui-popup").remove();
                mask.close();
                pullfreshF5();
                success();
              } else {
                mui.toast(data.msg);
              }
            }),
            error: function error() {
              setTimeout(function () {
                $('#loading').remove();
                isTYYJ = false;
              }, 50);
              mui.toast("数据提交失败，请稍后重试");
              $(".mui-popup").remove();
            }
          });
        }
      } else {
        mask.show();
        mask.close();
        $(".mui-popup").remove();
        return false;
      }
    });
  });

  // 二维码查询
  $("#icon-chaxun").on("click", function () {
    if (!isChaxun) {
      isChaxun = true;
      pageIndex = 1;
      loadGoodsLst();
      mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }
  });
  // 筛选栏选择商品类型
  $('.earlyWarningState button').on('tap', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
    earlyWarningState = $(this).val() || undefined;
  });

  // 筛选栏选择商品类型
  $('.orderType button').on('tap', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
    var goodsType = $('.orderType .activeBtn').val();
    selectRender(goodsType);
  });
  var flag = false;
  // 点击筛选按钮事件
  $('#lb-list').on('tap', function () {
    if (!flag) {
      $('.page2').animate({
        "top": '0'
      }, 300, function () {
        if (pop) {
          $('#pop').animate({
            "top": '23rem'
          }, 300, function () {
            pop = false;
          });
        }
        flag = true;
        mask.show();
      });
    } else {
      $('.page2').animate({
        "top": '-11rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  var pop = false;
  // 蒙版事件
  var mask = mui.createMask(function () {
    if (pop) {
      $('#pop').animate({
        "top": '23rem'
      }, 300, function () {
        pop = false;
      });
    } else if (flag) {
      $('.page2').animate({
        "top": '-11rem'
      }, 300, function () {
        flag = false;
      });
    }
  });
  // 点击筛选界面确定
  $('#requireBtn').on('tap', function () {
    if (!isChaxun) {
      isChaxun = true;
      $('.page2').animate({
        "top": '-11rem'
      }, 300, function () {
        flag = false;
      });
      pageIndex = 1;
      mask.close();
      loadGoodsLst();
      mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }
  });
  // 点击筛选界面清空
  $('#cancelBtn').on('tap', function () {
    $("#goodsName").val('');
    $('.orderType button').eq(0).addClass('activeBtn').siblings().removeClass('activeBtn');
    $('.earlyWarningState button').eq(0).addClass('activeBtn').siblings().removeClass('activeBtn');
    earlyWarningState = undefined;
    $(".from")[0].reset();
    selectRender();
  });

  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageIndex = 1;
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    loadGoodsLst();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    // mui('#pullrefresh').pullRefresh().refresh(true);
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    sessionStorage.removeItem("dbcbGoodsName");
    window.history.go(-1);
  });
});
//二维码扫码回调
window.getcode = function (s, _s1) {
  var s1 = _s1;
  s1 = s1.match(/https?:\/\//i) && s1.match(/^(.+)(https?:\/\/.+)$/i) ? RegExp.$2 : s1;
  $("#goodsName").val(s1);
  $("#icon-chaxun").click();
};