/*
 * @Descripttion: 分销商管理
 * @Date: 2021-06-15 16:27:27
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-11-02 11:36:16
 */
$(function () {
  //调试使用
  if (window.vDebug) new VConsole();
  var mask = mui.createMask();
  /*上拉加载具体业务实现*/
  var jinhuodanjuListTemp = $("#jinhuodanjuListTemp");
  var userInfo = JSON.parse(localStorage.getItem('cookieUserInfo'));
  var pageIndex = 1; //count 表示页数
  var timeout = 3000; //查询支付间隔
  var count = 0; //查询支付次数
  var timer; //定时器ID
  var sourceId; //支付商品ID
  var payMoney; //支付金额
  var chainId; //绑定关系ID
  var branches = []; //分店
  //加载单据数据
  function loadList(_ref) {
    var contactName = _ref.contactName,
      contactPhone = _ref.contactPhone,
      branchStoreName = _ref.branchStoreName;
    var postdata = {
      pageIndex: pageIndex,
      pageSize: 15,
      branchStoreName: branchStoreName,
      contactName: contactName,
      isChainStore: false,
      contactPhone: contactPhone
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/BranchStore/GetBranchStoreList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(postdata),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (data.data && data.data.length > 0) {
            var tpl = jinhuodanjuListTemp.html();
            var html = juicer(tpl, data);
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              $("#jhdjList").html(html);
              branches = data.data;
            } else {
              $("#jhdjList").append(html);
              branches = branches.concat(data.data);
            }
            pageIndex++;
          }
          if (data.data == null || data.data.length == 0) {
            if (pageIndex == 1) {
              $("#jhdjList").html("");
              $(".zwsj-box").show();
              $('#loading').remove();
            } else {
              mui.toast("未查询到更多数据");
            }
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  // 上下拉刷新加载公共代码
  function pullPublic() {
    //供应商
    var contactPhone = $('#contact-phone').val(); //下单人电话
    var contactName = $('#user-text').val(); //联系人
    var branchStoreName = $('#branch-name').val(); //分销商名称
    loadList({
      contactName: contactName,
      contactPhone: contactPhone,
      branchStoreName: branchStoreName
    });
  }
  //下拉刷新
  function pullfreshF5() {
    pageIndex = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
  }
  //上滑刷新
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }
  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').css('display', 'block');
      $('.page2').animate({
        "top": '0'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-6rem'
      }, 300, function () {
        $('.page2').css('display', 'none');
        mask.close();
        flag = false;
      });
    }
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#requireBtn').on('tap', function () {
    pageIndex = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-6rem'
    }, 300, function () {
      flag = false;
      $('.page2').css('display', 'none');
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancelBtn').on('tap', function () {
    $('#contact-phone').val(''); //下单人电话
    $('#branch-name').val(''); //分销商名称
    $('#user-text').val('');
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageIndex = 1;
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    pullPublic();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = 'index.html';
  });
  //删除按钮
  $('body').on('tap', '#delete-btn', function (e) {
    e.stopPropagation();
    var id = $(this).attr('data_id');
    mui.confirm('是否删除分销商？再次绑定可能需缴费！', '提示', ['否', '是'], function (ev) {
      if (ev.index === 1) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/BranchStore/DeleteBranchStore?branchStoreId=" + id,
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          dataType: "json",
          beforeSend: function beforeSend() {
            loading();
          },
          success: function (_success) {
            function success(_x) {
              return _success.apply(this, arguments);
            }
            success.toString = function () {
              return _success.toString();
            };
            return success;
          }(function (data) {
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            if (data.code == 1) {
              mui.toast('删除成功');
              success();
              pullfreshF5();
            } else mui.toast(data.msg);
          })
        });
      }
    });
  });

  //权限设置
  $('body').on('tap', '#permission-btn', function (e) {
    var _this2 = this;
    e.stopPropagation();
    var branchDetail = branches.find(function (item) {
      return item.id === $(_this2).attr('data_chainId');
    });
    var html = "  \n            <div class=\"permission-block\" ><label>\u662F\u5426\u5F00\u542F\u914D\u9001\u6D41\u7A0B\uFF1A</label>\n            <div><div class=\"mui-switch ".concat(branchDetail.isDistributionProcess ? 'mui-active' : '', "\" id=\"isDistributionProcess\">\n                <div class=\"mui-switch-handle\"></div>\n            </div></div>\n        </div>\n        ");
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle("".concat(branchDetail.branchStoreName, "\u6743\u9650\u8BBE\u7F6E"));
    //弹出框取消
    $('.comfirm-layer').on('tap', '#cancel-btn', function () {
      $(".dialog-mask ").remove();
      $('.comfirm-layer').remove();
    });
    //弹出框确定
    $('.comfirm-layer').on('tap', '#require-btn', function () {
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Member/SetAll",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          id: branchDetail.id,
          storeId: localStorage.getItem('storeId'),
          bindingStoreId: branchDetail.branchStoreId,
          IsDistributionProcess: $('#isDistributionProcess').hasClass('mui-active')
        }),
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function (_success2) {
          function success(_x2) {
            return _success2.apply(this, arguments);
          }
          success.toString = function () {
            return _success2.toString();
          };
          return success;
        }(function (data) {
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          $('#loading').remove();
          if (data.code == 1) {
            mui.toast('设置成功');
            success();
            setTimeout(function () {
              $(".dialog-mask ").remove();
              $('.comfirm-layer').remove();
              pullfreshF5();
            }, 1500);
          } else mui.toast(data.msg);
        }),
        error: function error() {
          $('#loading').remove();
          mui.toast('服务器异常，请稍候再试');
        }
      });
    });
    //开关切换
    $('.comfirm-layer').on('tap', '.mui-switch', function () {
      $(this).toggleClass('mui-active');
    });
  });

  //点击新增
  $('#add-branch').on('tap', function () {
    var freeBind = false;
    var branchStoreId = '';
    var html = '<div class="tcc" style="padding:0.25rem">';
    html += '<p style="margin-bottom:0"><label>分销商名称：</label><input type="text" id="branch-name2" placeholder="请输入分销商名称" style="background:#fff;border-color: rgba(0,155,76,.5);" ></p>';
    html += '<span id="name-warn" style="color:red;display:none;margin-left:3rem;">店名未找到</span>';
    html += '<p style="margin-bottom:0"><label>店主手机：</label><input type="text" id="branch-phone" placeholder="请输入店主手机号码" style="background:#fff;border-color: rgba(0,155,76,.5);" ></p>';
    html += '<span id="phone-warn" style="color:red;display:none;margin-left:3rem;">手机号码未找到</span>';
    html += '<p style="margin-bottom:0"><label>联系人：</label><input id="branch-contactMan" type="text" disabled="disabled" class="text-disabled" style="background:#fff;border-color: rgba(0,155,76,.5);" ></p>';
    html += '<p><label>短信验证码：</label><input id="msg-code" type="text" maxlength="4" style="background:#fff;border-color: rgba(0,155,76,.5);" ><button id="get-code" style="background:rgb(0,155,76);color:#fff;text-align:center;">获取验证码</button></p>';
    html += '<span id="bind-warn" style="color:red;display:none;font-size:.38rem;"></span>';
    html += '<div id="branch-loading" style="display:none;position:fixed;top:50%;left:50%;margin:-25px 0 0 -25px;z-index:999999;width:50px;height:50px;"><img src="img/loading.png" class="loading" style="width:50px;height:50px;"/></div>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle("绑定连锁分销商");
    //弹出框确定  
    $('.comfirm-layer').on('tap', '#require-btn', function () {
      if (!$('#branch-name2').val() || !$('#branch-phone').val()) {
        $('#phone-warn').show();
        $('#name-warn').show();
        $('#branch-contactMan').parent().css('margin-top', '.1rem');
        $('#branch-phone').parent().css('margin-top', '.1rem');
        return;
      } else if ($('#phone-warn').css('display') !== 'none') return;else if (!$('#msg-code').val()) return $('#msg-code').css('border-color', 'red');
      $('#branch-loading').show();
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/BranchStore/AddBranchStore",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          branchStoreId: branchStoreId,
          branchStoreName: $('#branch-name2').val(),
          contactName: $('#branch-contactMan').val(),
          contactPhone: $('#branch-phone').val(),
          verificationCode: $('#msg-code').val(),
          isPayBind: false,
          isChainStore: false
        }),
        dataType: "json",
        success: function (_success3) {
          function success(_x3) {
            return _success3.apply(this, arguments);
          }
          success.toString = function () {
            return _success3.toString();
          };
          return success;
        }(function (data) {
          $('#branch-loading').hide();
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          if (data.code == 1) {
            if (freeBind) {
              $(".dialog-mask ").remove();
              $('.comfirm-layer').remove();
              mui.toast('绑定成功');
              success();
            } else if (data.data) {
              chainId = data.dataExtend.id;
              addOrder();
            }
          } else mui.toast(data.msg);
        })
      });
    });
    //验证码输入
    $("body").on('input propertychange', "#msg-code", function () {
      if ($(this).val() && $(this).val().length === 4) $(this).css('border-color', 'rgba(0,155,76,.5)');
    });
    //弹出框取消
    $('.comfirm-layer').on('tap', '#cancel-btn', function () {
      $(".dialog-mask ").remove();
      $('.comfirm-layer').remove();
    });
    //输入分销商名称
    $("body").on('input propertychange', "#branch-name2", decrementRequest(function () {
      if (!$('#branch-name2').val()) return;
      $('#branch-loading').show();
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Store/GetStore",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          key: $('#branch-name2').val()
        }),
        dataType: "json",
        success: function success(data) {
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          setTimeout(function () {
            $('#branch-loading').hide();
          }, 50);
          if (data.code == 1 && data.data) {
            if (data.data.length) {
              $('#branch-name2').val(data.data[0].name);
              $('#branch-phone').val(data.data[0].storeManPhone);
              $('#branch-contactMan').val(data.data[0].legalPersonName);
              $('#name-warn').hide();
              $('#phone-warn').hide();
              $('#branch-contactMan').parent().css('margin-top', '.3125rem');
              $('#branch-phone').parent().css('margin-top', '.3125rem');
              window.getPhoneCode(data.data[0].storeManPhone);
              branchStoreId = data.data[0].id;
              getBill(data.data[0].id);
            } else {
              $('#name-warn').show();
              $('#branch-contactMan').parent().css('margin-top', '.1rem');
              $('#branch-phone').parent().css('margin-top', '.1rem');
            }
          } else mui.toast(data.msg);
        }
      });
    }, 1000));
    //输入手机号码
    $("body").on('input propertychange', "#branch-phone", decrementRequest(function () {
      if (!$('#branch-phone').val()) return;
      $('#branch-loading').show();
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Store/GetStore",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          key: $('#branch-phone').val()
        }),
        dataType: "json",
        success: function success(data) {
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          setTimeout(function () {
            $('#branch-loading').hide();
          }, 50);
          if (data.code == 1 && data.data) {
            if (data.data.length) {
              $('#branch-name2').val(data.data[0].name);
              $('#branch-phone').val(data.data[0].storeManPhone);
              $('#branch-contactMan').val(data.data[0].legalPersonName);
              $('#name-warn').hide();
              $('#phone-warn').hide();
              $('#branch-contactMan').parent().css('margin-top', '.3125rem');
              $('#branch-phone').parent().css('margin-top', '.3125rem');
              window.getPhoneCode(data.data[0].storeManPhone);
              branchStoreId = data.data[0].id;
              getBill(data.data[0].id);
            } else {
              $('#phone-warn').show();
              $('#branch-contactMan').parent().css('margin-top', '.1rem');
              $('#branch-phone').parent().css('margin-top', '.1rem');
            }
          } else mui.toast(data.msg);
        }
      });
    }, 1000));
    //获取短信验证码
    $('body').on('tap', '#get-code', function () {
      if (!$('#branch-phone').val() || $('#phone-warn').css('display') !== 'none') {
        $('#branch-contactMan').parent().css('margin-top', '.1rem');
        return $('#phone-warn').show();
      }
      $('#branch-loading').show();
      _yzmSend();
    });
    //检测绑定费用
    function getBill(branchStoreId) {
      $('#branch-loading').show();
      var mainStoreId = localStorage.getItem('storeId');
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/BranchStore/CheckBindNeedPay?branchStoreId=" + branchStoreId + '&mainStoreId=' + mainStoreId + '&isChainStore=false',
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        success: function success(data) {
          $('#branch-loading').hide();
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          if (data.code == 1 && data.data) {
            freeBind = data.dataExtend;
            sourceId = data.data.id;
            payMoney = data.data.memberPrice;
            $('#bind-warn').show();
            $('#bind-warn').text('*' + data.msg);
          } else mui.toast(data.msg);
        }
      });
    }
  });
  //验证码 倒计时
  function resetCode() {
    var second = 60;
    var timer = null;
    $('#get-code').html("60秒后点击");
    $('#get-code').addClass("disable");
    $('#get-code').attr("disabled", "true");
    timer = setInterval(function () {
      second -= 1;
      if (second > 0) {
        $('#get-code').html(second + "秒后点击");
        $('#get-code').addClass("disable");
        $('#get-code').attr("disabled", "true");
      } else {
        clearInterval(timer);
        $('#get-code').html("获取验证码");
        $('#get-code').removeClass("disable");
        $('#get-code').removeAttr("disabled");
      }
    }, 1000);
  }
  //发送验证码
  function _yzmSend() {
    var requestData = {
      phoneCode: window.phoneCode,
      phone: $("#branch-phone").val(),
      sendType: 14,
      soureType: erpSourceType
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/SendPhoneMsg",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      success: function success(data) {
        if (data.code == 1) {
          resetCode(); //验证码倒计时
          $('#branch-loading').hide();
        } else mui.toast(data.msg);
      },
      error: function error() {
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  ;
  //防抖请求
  function decrementRequest(cb, delay) {
    var clear = null;
    return function () {
      if (clear) {
        clearTimeout(clear);
        clear = setTimeout(cb, delay);
      } else clear = setTimeout(cb, delay);
    };
  }

  //点击续费
  $('body').on('tap', '#continue-btn,#pay-btn', function (e) {
    e.stopPropagation();
    var mainStoreId = localStorage.getItem('storeId');
    var branchStoreId = $(this).attr('data_id');
    chainId = $(this).attr('data_chainId');
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/BranchStore/CheckBindNeedPay?branchStoreId=" + branchStoreId + '&mainStoreId=' + mainStoreId + '&isChainStore=false',
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1 && data.data) {
          sourceId = data.data.id;
          payMoney = data.data.memberPrice;
          addOrder();
        } else mui.toast(data.msg);
      }
    });
  });
  var operationPicker = new mui.PopPicker({
    layer: 1
  });
  //弹出底部菜单
  $('body').on('tap', '.wrapper-li', function () {
    var _this = $(this);
    var bindState = $(this).attr('data_state');
    if (bindState == 0) {
      operationPicker.setData([{
        value: 1,
        text: '缴费'
      }, {
        value: 3,
        text: '删除'
      }]);
    } else if (bindState == 1 || bindState == 2) {
      operationPicker.setData([{
        value: 2,
        text: '续费'
      }, {
        value: 3,
        text: '删除'
      }]);
    }
    operationPicker.show(function (item) {
      if (item[0].value === 1) _this.find('#pay-btn').trigger('tap');else if (item[0].value === 2) _this.find('#continue-btn').trigger('tap');else _this.find('#delete-btn').trigger('tap');
    });
  });
  // 添加订单
  function addOrder() {
    clearTimeout(timer);
    var requestData = {
      sourceType: 1,
      sourceId: sourceId,
      payMoney: payMoney,
      goodsMoney: payMoney,
      payType: JiaoHu.getPinpai() === 'SUNMI' || JiaoHu.getDeviceInfo().includes('newland') ? 'wp' : 'wa',
      sourceObjectId: userInfo.storeId,
      sourceObjectName: userInfo.storeName,
      sourceObjectPhone: userInfo.storeManPhone,
      sourceCreateId: userInfo.userId,
      createPhone: userInfo.telPhone,
      sourceObjectType: 1,
      sourceUrl: window.location.href,
      app: {
        appName: window.isProjectGx ? '广西农药进销存系统' : '优农帮erp',
        wapnName: window.isProjectGx ? '广西农药进销存系统' : '优农帮erp',
        wapUrl: window.isProjectGx ? 'http://gxerp.download.yoonop.com/html/login.html' : 'http://erpdownload.yoonop.com/html/login.html',
        erpDeviceSN: erpDeviceSN,
        erpDeviceNo: erpDeviceNo,
        appId: window.isProjectGx ? 'wxf10591574aabf213' : ''
      }
    };
    $.ajax({
      type: 'POST',
      url: baseRequestUrl + '/Api/PayOrders/Add',
      data: JSON.stringify(requestData),
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        Authorization: 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function success(data) {
        $('#loading').remove();
        mask.close();
        if (data.code === 1) {
          if (JiaoHu.getPinpai() === 'SUNMI' || JiaoHu.getDeviceInfo().includes('newland')) {
            var html = '<p><img src="img/wchat.png">&nbsp微信扫码：￥' + requestData.payMoney + '元</p>';
            $('.code .pay').html(html);
            $('.code .wait').text('等待用户支付，等待时间2分钟！');
            $('#qrcode').text('');
            $('#qrcode').qrcode({
              render: 'canvas',
              //table方式
              width: 200,
              //宽度
              height: 200,
              //高度
              text: data.data //任意内容
            });

            $('.code-wrapper').show();
            count = 0;
            timeout = 3000;
            intervalTime(data.dataExtend);
          } else {
            console.log('开始进入支付:' + data.data);
            JiaoHu.WxPay(data.data);
          }
          bindChain(data.dataExtend);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        mask.close();
      }
    });
  }
  function intervalTime(id) {
    clearTimeout(timer);
    if (count < 10) {
      timer = setTimeout(function () {
        getInfoById(id);
      }, timeout);
    } else {
      count = 0;
      var btnArray = ['取消', '确认'];
      mui.confirm('由于您长时间未付款，二维码已失效，是否刷新二维码？', '提示', btnArray, function (e) {
        if (e.index == 1) addOrder();else {
          clearTimeout(timer);
          $('.code-wrapper').hide('');
        }
      });
    }
  }
  // 获取支付信息
  function getInfoById(id) {
    clearTimeout(timer);
    count++;
    $.ajax({
      type: 'POST',
      url: baseRequestUrl + '/Api/PayOrders/InfoById?id=' + id,
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        Authorization: 'Bearer ' + localStorage.getItem('token')
      },
      success: function (_success4) {
        function success(_x4) {
          return _success4.apply(this, arguments);
        }
        success.toString = function () {
          return _success4.toString();
        };
        return success;
      }(function (data) {
        if (data.code === 1) {
          if (data.dataExtend == '已付款') {
            mui.toast('付款成功!', {
              duration: 'long'
            });
            success();
            $('.code-wrapper').hide();
            pullfreshF5();
          } else intervalTime(id);
        } else mui.toast(data.msg);
      }),
      error: function error() {
        mask.close();
      }
    });
  }
  //绑定支付关系
  function bindChain(id) {
    $.ajax({
      type: 'POST',
      url: baseRequestUrl + '/Api/BranchStore/SetBindPayNo?id=' + chainId + '&payNo=' + id,
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        Authorization: 'Bearer ' + localStorage.getItem('token')
      },
      success: function success(data) {
        if (data.code === 1) {} else mui.toast(data.msg);
      },
      error: function error() {
        mask.close();
      }
    });
  }
});