function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch;
var m = moment;
createApp({
  components: {
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty
  },
  setup: function setup() {
    var data = reactive({
      screenVisible: false,
      //筛选开关
      dateList: [{
        label: '今日',
        startTime: m().startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '本周',
        startTime: m().weekday(1).startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().weekday(7).endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '本月',
        startTime: m().startOf('month').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().endOf('month').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '本年',
        startTime: m().startOf('year').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().endOf('year').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '昨日',
        startTime: m().day(m().day() - 1).startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().day(m().day() - 1).endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '上周',
        startTime: m().week(m().week() - 1).weekday(1).startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().week(m().week() - 1).weekday(1).endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '上月',
        startTime: m().month(m().month() - 1).startOf('month').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().month(m().month() - 1).endOf('month').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '去年',
        startTime: m().year(m().year() - 1).startOf('year').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().year(m().year() - 1).endOf('year').format('YYYY-MM-DD HH:mm:ss')
      }],
      customerTime: {
        start: '开始时间',
        end: '结束时间'
      },
      //自定义时间
      curSelecct: {},
      //当前选中的时间段
      queryParams: {
        storeId: localStorage.getItem('storeId'),
        userName: '',
        startDate: '',
        endDate: ''
      },
      loading: true,
      list: []
    });
    onMounted(function () {
      var dateList = data.dateList;
      //设置默认选中时间
      data.curSelecct = dateList[1];
      getList();
      data.loading = true;
      setTimeout(function () {
        mui.init({
          pullRefresh: {
            container: '#refreshContainer',
            subpages: [{
              url: window.location.href,
              //下拉刷新内容页面地址
              id: '#refreshContainer' //内容页面标志
              // styles:{
              //     top:0,//内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
              //     //其它参数定义
              // }
            }],

            down: {
              style: 'circle',
              auto: false,
              //可选,默认false.首次加载自动下拉刷新一次
              callback: function callback() {
                setTimeout(function () {
                  getList(function () {
                    mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
                    mui('#refreshContainer').pullRefresh().refresh(true);
                  });
                }, 1000);
              } //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
            }
          }
        });

        //跳转销售详情
        // $('.list_item').on('tap',(e)=>{
        //     const id = $(e)[0].currentTarget.dataset.item
        //     window.location = `employeeSaleDetail.html?id=${id}`
        // })

        data.loading = false;
      }, 1000);
    });
    watchEffect(function () {
      if (data.screenVisible == true) {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '9rem'
        });
      } else {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '3rem'
        });
      }
    });

    //跳转销售详情
    var toDetail = function toDetail(item) {
      window.location = "employeeSaleDetail.html?id=".concat(item.salesmanId);
    };

    //筛选开关
    var clickScreen = function clickScreen() {
      data.screenVisible = !data.screenVisible;
    };

    //搜索框完成事件
    var searchInput = function searchInput() {
      getList();
    };

    //点击时间段
    var clickTimeBtn = function clickTimeBtn(item) {
      data.curSelecct = item;
      data.customerTime = {
        start: '开始时间',
        end: '结束时间'
      };
      data.screenVisible = false;
      getList();
    };

    //打开时间选择器
    var openPick = function openPick(type) {
      var _data$customerTime = data.customerTime,
        start = _data$customerTime.start,
        end = _data$customerTime.end;
      if (type == 'end' && start == '开始时间') {
        mui.toast('请先选择开始时间');
        return;
      }
      var t = start.split('-');
      var picker = new mui.DtPicker({
        type: 'date',
        //已选择结束时间重新选择开始时间重置
        beginDate: type == 'start' ? '' : new Date(t[0], Number(t[1]) - 1, t[2])
      }).show(function (res) {
        data.customerTime[type] = res.value;
        //选择开始时间且已选择结束时间则重置结束时间
        if (type == 'start' && end != '结束时间') {
          data.customerTime.end = '结束时间';
        }
        if (data.customerTime.start != '开始时间' && data.customerTime.end != '结束时间') {
          data.curSelecct = {
            label: "".concat(data.customerTime.start, "~").concat(data.customerTime.end),
            startTime: data.customerTime.start,
            endTime: data.customerTime.end
          };
          data.screenVisible = false;
          getList();
        }
      });
    };

    //获取列表
    var getList = function getList(cb) {
      var queryParams = data.queryParams;

      // data.loading = true
      $http({
        url: '/Api/Clerk/GetSalemanSaleMoney',
        data: _objectSpread(_objectSpread({}, data.queryParams), {}, {
          startDate: data.curSelecct.startTime,
          endDate: data.curSelecct.endTime
        })
      }).then(function (res) {
        data.loading = false;
        if (res.code == 1) {
          if (cb) cb();
          data.list = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //返回按钮
    var goBack = function goBack() {
      window.history.go(-1);
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      clickScreen: clickScreen,
      openPick: openPick,
      clickTimeBtn: clickTimeBtn,
      goBack: goBack,
      searchInput: searchInput,
      toDetail: toDetail
    });
  }
}).mount('#app');