$(function () {
  //调试使用
  if (window.vDebug) {
    var vConsole = new VConsole();
    //vConsole.show();
  }
  // 验证码计时
  createCode();
  function resetCode() {
    var second = 59;
    var timer = null;
    timer = setInterval(function () {
      second -= 1;
      if (second > 0) {
        $('#yzm-btn').html(second + "s后点击");
        $('#yzm-btn').addClass("disable");
        $('#yzm-btn').attr("disabled", "true");
      } else {
        clearInterval(timer);
        $('#yzm-btn').html("发送验证");
        $('#yzm-btn').removeClass("disable");
        $('#yzm-btn').removeAttr("disabled");
      }
    }, 1000);
  }
  $('#yzm-btn').on('tap', function () {
    yzmSend();
  });
  var code; //在全局定义验证码  
  function createCode() {
    code = "";
    var codeLength = 4; //验证码的长度  
    var checkCode = document.getElementById("code");
    var random = new Array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9); //随机数  
    for (var i = 0; i < codeLength; i++) {
      //循环操作  
      var index = Math.floor(Math.random() * 10); //取得随机数的索引（0~35）  
      code += random[index]; //根据索引取得随机数加到code上  
    }

    checkCode.value = code; //把code值赋给验证码  
  }

  $('#code').on('tap', function () {
    createCode();
  });
  //校验验证码  
  // function validate() {
  //     var inputCode = document.getElementById("input").value.toUpperCase(); //取得输入的验证码并转化为大写        
  //     if (inputCode.length <= 0) { //若输入的验证码长度为0  
  //         mui.toast("请输入验证码！"); //则弹出请输入验证码  
  //     } else if (inputCode != code) { //若输入的验证码与产生的验证码不一致时  
  //         mui.toast("验证码输入错误！@_@"); //则弹出验证码输入错误  
  //         createCode(); //刷新验证码  
  //         document.getElementById("input").value = ""; //清空文本框  
  //     } else { //输入正确时  
  //     }
  // }
  //验证码
  var mask = mui.createMask();
  function yzmSend() {
    if (!window.phoneCode) {
      window.getPhoneCode($("#phone").val(), function () {
        _yzmSend();
      });
    } else {
      _yzmSend();
    }
  }
  function _yzmSend() {
    var requestData = {
      phoneCode: window.phoneCode,
      phone: $("#phone").val(),
      sendType: 2,
      soureType: erpSourceType
    };
    if (requestData.phone == "") {
      mui.toast("请填写电话号码");
      return;
    }
    ;
    //console.log("requestData==", requestData.phoneCode)

    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/SendPhoneMsg",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          resetCode();
          mui.toast("验证码已发送，请注意查收");
          success();
          $('.phoneNum').css('display', 'none');
          $('#nextStep').css('display', 'none');
          $('.pass-form-item-submit').css('display', 'none');
          $('.goBack').css('display', 'block');
          $('.passwordBox').css('display', 'block');
          $('#wjmm-btn').css('display', 'block');
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  ;
  $("#phone").on("change", function (e) {
    //console.log("phone blur==", e.target.value)
    window.getPhoneCode(e.target.value);
  });
  //在手机号码输入到11位时判断是否重复
  $("body").on("input propertychange", "#phone", function () {
    if ($("#phone").val().length == 11) {
      validUserAndPhone();
    }
  });
  //点击下一步时的验证
  $('#nextStep').on('tap', function () {
    var phone = $("#phone").val();
    var reg = /^1\d{10}$/;
    var inputCode = document.getElementById("input").value.toUpperCase(); //取得输入的验证码并转化为大写
    if (phone == "") {
      // mask.show();
      mui.toast('请输入你的电话号码', '', function () {
        mask.close();
      });
      return false;
    }
    if (!reg.test(phone)) {
      // mask.show();
      mui.toast('您输入的电话号码不正确', '', function () {
        mask.close();
        $(".phone").val("");
      });
      return false;
    }
    if (inputCode.length <= 0) {
      //若输入的验证码长度为0  
      mui.toast("请输入图片验证码！"); //则弹出请输入验证码  
      return;
    }
    if (inputCode != code) {
      //若输入的验证码与产生的验证码不一致时  
      mui.toast("图片验证码输入错误");
      createCode(); //刷新验证码  
      document.getElementById("input").value = ""; //清空文本框  
      return;
    }
    yzmSend();
  });
  //验证手机号码及登录账号是否已被注册
  $("#user").on("blur", validUserAndPhone);
  function validUserAndPhone() {
    var phone = $("#phone").val() == "" ? null : $("#phone").val();
    var requestData = {
      "phone": phone
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/UserVerification",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        if (data.data == true) {
          if (phone) {
            $('#yzm-btn').removeClass("disable");
            $('#yzm-btn').removeAttr("disabled");
          }
        } else {
          $('#yzm-btn').addClass("disable");
          $('#yzm-btn').attr("disabled", "true");
          mui.toast('该手机号未注册，无法修改密码！');
        }
      },
      error: function error() {
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //忘记密码
  $("#wjmm-btn").on("click", function () {
    var $this = $(this);
    $this.addClass("disable");
    $this.attr("disabled", "true");
    var user = $("#phone").val();
    var yzm = $("#yzm").val();
    var password = $("#password").val();
    var password2 = $("#password2").val();
    // var pwdReg = /^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z\S\s]{6,16}$/;

    if (yzm == "") {
      mask.show();
      mui.toast('请输入你的验证码', '', function () {
        mask.close();
      });
      return false;
    }
    if (password == "") {
      mask.show();
      mui.toast('请输入你的密码', '', function () {
        mask.close();
      });
      return false;
    }
    if (password.length < 6 || password.length > 16) {
      mui.toast('密码长度为6到16位', '', function () {
        mask.close();
      });
      return false;
    }
    // if ((password && !pwdReg.test(password))) {
    //     mui.toast('密码至少使用两种字符组合！', '', function () {
    //         mask.close();
    //     });
    //     return false;
    // }
    var requestData = {
      "loginName": user,
      "newPassword": password,
      "confirmPassword": password,
      "verificationCode": yzm
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/ForgetPwd",
      data: JSON.stringify(requestData),
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success2) {
        function success(_x2) {
          return _success2.apply(this, arguments);
        }
        success.toString = function () {
          return _success2.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          mui.toast("密码修改成功");
          setTimeout(function () {
            window.location.href = "login.html";
          }, 1000);
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
  $("#imgSrc").on('tap', function () {
    var mm = $('#password').attr('type');
    var obj = $("#imgSrc");
    if (obj.attr("src") == "img/eyes.svg") {
      obj.attr("src", "img/eyesClose.svg");
      $('#password').attr('type', "password");
    } else {
      obj.attr("src", "img/eyes.svg");
      $('#password').attr('type', "text");
    }
  });
  var winHeight = $(window).height(); //获取当前页面高度
  $(window).resize(function () {
    var thisHeight = $(this).height();
    if (winHeight - thisHeight > 50) {
      //当软键盘弹出，在这里面操作
      $(".logo-mid").hide();
    } else {
      //当软键盘收起，在此处操作
      $(".logo-mid").show();
    }
  });
});

// $('input').focus(function () {
//     $(".logo-mid").hide()
// })
// $('input').blur(function () {
//     $(".logo-mid").show()
// })