$(function () {
  mui.init({
    swipeBack: false,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: searchStore //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  var people = JSON.parse(sessionStorage.getItem('bindStore'));
  if (people && people != null) {
    $('#searchStore').val(people.phone);
  }
  // 获取可绑定的店
  searchStore();
  function searchStore() {
    var searchThing = $('#searchStore').val();
    var reg = /^\s*$/g;
    if (searchThing == "" || searchThing.length == 0 || reg.test(searchThing)) {
      mui.toast('查询条件不能为空!');
      return;
    } else {
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Store/Search?keyword=" + searchThing,
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function success(data) {
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          if (data.code == 1) {
            if (data.data.length > 0) {
              $('.zwsj-box').hide();
              var tpl = $('#storeListTemp').html();
              var html = juicer(tpl, data);
              $('#storeList').html(html);
            } else {
              $('.zwsj-box').show();
            }
          } else {
            mui.toast(data.msg);
          }
          mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
        },
        error: function error() {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
        }
      });
    }
  }
  // 点击绑定
  $('#storeList').on('tap', '.list-info', function () {
    var id = $(this).attr('data_id');
    var name = $(this).attr('data_name');
    var contactInformation = $(this).attr('contactInformation');
    var legalPersonName = $(this).attr('legalPersonName');
    var address = $(this).attr('address');
    var provinceCode = $(this).attr('provinceCode');
    var provinceName = $(this).attr('provinceName');
    var cityCode = $(this).attr('cityCode');
    var cityName = $(this).attr('cityName');
    var townCode = $(this).attr('townCode');
    var townName = $(this).attr('townName');
    var countyCode = $(this).attr('countyCode');
    var countyName = $(this).attr('countyName');
    var regionId = $(this).attr('regionId');
    var enterpriseCreditCode = $(this).attr('enterpriseCreditCode');
    var businessLicense = $(this).attr('businessLicense');
    if (getUrlParam('type') == 'gys') {
      if (name != people.name) {
        var btnbutton = ['否', '是'];
        mui.confirm("当前供应商信息与原先不符，是否确认覆盖?（注意：若选择覆盖，原先的进货单据供应商信息依旧不会改变）", "是否确认覆盖", btnbutton, function (e) {
          if (e.index == 1) {
            var requestData = {
              "id": people.id,
              "type": people.type,
              "override": true,
              "storeId": id,
              "supplierName": name,
              "phone": contactInformation,
              "contactName": legalPersonName,
              "address": address,
              "provinceCode": provinceCode,
              "provinceName": provinceName,
              "cityCode": cityCode,
              "cityName": cityName,
              "townCode": townCode,
              "townName": townName,
              "countyCode": countyCode,
              "countyName": countyName,
              "regionId": regionId,
              "enterpriseCreditCode": enterpriseCreditCode != "null" ? enterpriseCreditCode : null,
              "businessLicense": businessLicense != "null" ? businessLicense : null
            };
            bindStore(requestData);
          } else {
            var requestData = {
              "id": people.id,
              "type": people.type,
              "override": false,
              "storeId": id
              // "supplierName": name,
              // "phone": contactInformation,
              // "contactName": legalPersonName,
              // "address": address,
              // "provinceCode": provinceCode,
              // "provinceName": provinceName,
              // "cityCode": cityCode,
              // "cityName": cityName,
              // "townCode": townCode,
              // "townName": townName,
              // "countyCode": countyCode,
              // "countyName": countyName,
              // "regionId": regionId,
              // "enterpriseCreditCode": enterpriseCreditCode != "null" ? enterpriseCreditCode : null,
              // "businessLicense": businessLicense != "null" ? businessLicense : null
            };

            bindStore(requestData);
          }
        });
      } else {
        var requestData = {
          "id": people.id,
          "type": people.type,
          "override": false,
          "storeId": id
          // "supplierName": name,
          // "phone": contactInformation,
          // "contactName": legalPersonName,
          // "address": address,
          // "provinceCode": provinceCode,
          // "provinceName": provinceName,
          // "cityCode": cityCode,
          // "cityName": cityName,
          // "townCode": townCode,
          // "townName": townName,
          // "countyCode": countyCode,
          // "countyName": countyName,
          // "regionId": regionId,
          // "enterpriseCreditCode": enterpriseCreditCode != "null" ? enterpriseCreditCode : null,
          // "businessLicense": businessLicense != "null" ? businessLicense : null
        };

        bindStore(requestData);
      }
    } else {
      var requestData = {
        id: people.id,
        storeId: id,
        type: people.type
      };
      bindStore(requestData);
    }
  });
  function bindStore(requestData) {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Member/BindStore",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (getUrlParam('type') == 'hy') {
            window.location.href = 'ziliao_huiyuanguanli.html';
          } else if (getUrlParam('type') == 'gys') {
            window.location.href = 'ziliao_gongyingshangguanli.html';
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 返回
  $('.goBack-btn').on('tap', function () {
    history.go(-1);
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    searchStore();
    document.activeElement.blur(); //软键盘收起
  });
});