$(function () {
  var mask = mui.createMask();
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  function GetQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)"); //寻找&+url参数名=参数值+&.&可以不存在
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return null;
  }
  var count = 0; //count 表示页数
  // 上拉加载具体业务实现
  var DuihuanjiluListTemp = $("#DuihuanjiluListTemp"); //获取前端需要加载的模板
  var year = new Date().getFullYear();
  var month = new Date().getMonth() + 1;
  var day = new Date().getDate();
  $(".timer").html(year + "-" + month + "-" + day);

  // 上拉刷新加载公共代码
  function pullPublic() {
    var table = document.body.querySelector('.mui-table-view');
    var cells = document.body.querySelectorAll('.mui-table-view-cell');
    var startTime = $(".start-time").text();
    var endTime = $(".end-time").text();
    var id = GetQueryString("id");
    var requestData = {
      memberId: id,
      start: startTime,
      end: endTime,
      pageIndex: count,
      pageSize: 6
    };
    //查询会员兑换记录
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/Member/SearchScoreExchange",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 6 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          $("#pullrefresh").show(); //数据列表显示
          $(".zwsj-box").hide(); //暂无数据图表隐藏
          if (data.data != null) {
            if (data.data.length > 0) {
              var tpl = DuihuanjiluListTemp.html();
              var html = juicer(tpl, data);
              $(table).html(html);
              mui('#pullrefresh').pullRefresh().disablePullupToRefresh();
              mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
              mui('#pullrefresh').pullRefresh().enablePullupToRefresh();
            } else {
              if (count == 1) {
                // $("#pullrefresh").hide();//数据列表显示
                $(".zwsj-box").show(); //暂无数据图表隐藏
                $('#loading').remove();
              }
            }
          } else {
            if (count == 1) {
              // $("#pullrefresh").hide();//数据列表隐藏
              $(".zwsj-box").show(); //暂无数据图表显示
              $('#loading').remove();
            }
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }

  // 上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      count++;
      pullPublic();
    }, 1500);
  }

  // 下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      count = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  if (mui.os.plus) {
    mui.plusReady(function () {
      setTimeout(function () {
        mui('#pullrefresh').pullRefresh().pullupLoading();
      }, 1000);
    });
  } else {
    mui.ready(function () {
      mui('#pullrefresh').pullRefresh().pullupLoading();
    });
  }
  ;
  (function ($) {
    $.init();
    var result = $('.timer')[0];
    var btns = $('.btn');
    var optionsJson = '';
    var options = 'JSON.parse(optionsJson)';
    var id = '';
    var obj = '';
    var picker = null;
    btns.each(function (i, btn) {
      btn.addEventListener('tap', function () {
        if (picker) {
          picker.dispose();
        }
        optionsJson = this.getAttribute('data-options') || '{}';
        options = JSON.parse(optionsJson);
        id = this.getAttribute('id');
        obj = this.getElementsByClassName("timer")[0];
        picker = new $.DtPicker(options);
        picker.show(function (rs) {
          obj.innerHTML = rs.text;
          picker.dispose();
        });
      }, false);
    });
  })(mui);
  //查询按钮
  $(".kc-title").on('tap', '#hy-dhjl-btn', function (event) {
    var startTime = $(".start-time").text();
    var endTime = $(".end-time").text();
    var id = GetQueryString("id");
    count = 1;
    var requestData = {
      memberId: id,
      start: startTime,
      end: endTime,
      pageIndex: count,
      pageSize: 6
    };
    //查询会员兑换记录
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/Member/SearchScoreExchange",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $("#pullrefresh").show(); //数据列表显示
          $(".zwsj-box").hide(); //暂无数据图表隐藏
          var table = document.body.querySelector('.mui-table-view');
          table.innerHTML = "";
          if (data.data != null) {
            if (data.data.length > 0) {
              var tpl = DuihuanjiluListTemp.html();
              var html = juicer(tpl, data);
              if (count == 1) {
                $(table).html(html);
                mui('#pullrefresh').pullRefresh().disablePullupToRefresh();
                mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
                mui('#pullrefresh').pullRefresh().enablePullupToRefresh();
              } else {
                $(table).append(html);
              }
            }
          }
          if (data.data == null || data.data.length == 0) {
            if (count == 1) {
              // $("#pullrefresh").hide();
              $(".zwsj-box").show();
              $('#loading').remove();
            } else {
              mui.toast("未查询到更多数据");
            }
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
  $(".goBack-btn").bind("click", function () {
    if (useLocal) {
      JiaoHu.closeNewWebview();
    } else {
      window.history.go(-1);
    }
  });
});