$(function () {
  sessionStorage.removeItem('cropName');
  sessionStorage.removeItem('pestName');
  var pageIndex = 1; //页码
  var pageSize = 10; //每页条数
  var cropListTemp = $("#cropListTemp"); //作物列表
  var loadOrSearch = true;
  queryPlantClass();
  // 获取作物分类
  function queryPlantClass() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetPlantClassifyByNode",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      async: false,
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        if (data.code == 1) {
          if (data.data != null && data.data.length > 0) {
            data.data.forEach(function (item) {
              if (!item.id) $("#cropClass").append("<li class='activeBtn' code=" + item.code + ">" + item.nameCn + '(' + item.plantCount + ')' + " </li>");else $("#cropClass").append("<li code=" + item.code + ">" + item.nameCn + '(' + item.plantCount + ')' + " </li>");
            });
          }
        }
      },
      error: function error(err) {}
    });
  }
  // 选择分类
  $("#cropClass").on('tap', 'li', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
    $('.page2').animate({
      "top": '-9rem'
    }, 300, function () {
      mask.close();
      flag = false;
    });
    pageIndex = 1;
    loadCrop();
    loadOrSearch = true;
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
  });
  var flag = false;
  // 点击筛选按钮事件
  $('#lb-list').on('tap', function () {
    if (!flag) {
      $('.page2').animate({
        "top": '3.9rem'
      }, 300, function () {
        flag = true;
        mask.show();
      });
    } else {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  //创建蒙版遮罩
  var mask = mui.createMask(function () {
    if (flag) {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        flag = false;
      });
    }
  });
  //加载作物列表
  function loadCrop() {
    var classificCode = $("#cropClass .activeBtn").attr('code');
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      classificCode: classificCode
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetPlantByLivingMatter",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * pageSize >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#allGoods').text(data.totalCount);
          if (!data.data || data.data.length == 0) {
            $('.zwsj-box').show();
          } else {
            $('.zwsj-box').hide();
          }
          var tpl = $('#cropListTemp').html();
          var html = juicer(tpl, data);
          if (pageIndex == 1) {
            $('#cropList').html(html);
          } else {
            $('#cropList').append(html);
          }
          pageIndex++;
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      if (loadOrSearch) loadCrop();else searchCrop();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      if (loadOrSearch) loadCrop();else searchCrop();
    }, 1500);
  }
  // 查询
  function searchCrop() {
    var cropName = $('#cropName').val();
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      search: cropName
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetPlantPest",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * pageSize >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#allGoods').text(data.totalCount);
          if (!data.data || data.data.length == 0) {
            $('.zwsj-box').show();
          } else {
            $('.zwsj-box').hide();
          }
          var tpl = $('#cropListTemp').html();
          var html = juicer(tpl, data);
          if (pageIndex == 1) {
            $('#cropList').html(html);
          } else {
            $('#cropList').append(html);
          }
          pageIndex++;
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  //查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    loadOrSearch = false;
    pageIndex = 1;
    var cropName = $('#cropName').val();
    if (!cropName && cropName.length < 1) {
      loadCrop();
      loadOrSearch = true;
    } else {
      searchCrop();
      loadOrSearch = false;
    }
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });

  // 点击作物跳转选择病虫草害
  $('#cropList').on('tap', 'li', function () {
    var cropName = $(this).attr('data_data');
    sessionStorage.setItem("cropName", JSON.stringify(cropName));
    location.href = 'intelligenceDiagnosis_pest.html';
  });

  // 返回按钮
  $('.goBack-btn').on('tap', function () {
    sessionStorage.removeItem('cropName');
    window.history.go(-1);
  });
  $('#uploadBtn').on('tap', function () {
    location.href = 'intelligenceDiagnosis_uploadImage.html';
  });
});