$(function () {
  var pageIndex = 1;
  var pageSize = 100;
  var flag1 = false;
  var flag2 = false;
  var flag3 = false;
  var cropName = JSON.parse(sessionStorage.getItem('cropName'));
  // 获取病害
  getIllness();
  function getIllness() {
    var pestType = $('#tabs .activeTab').attr('pestType');
    var search = $('#pestName').val();
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      cropName: cropName,
      pestType: pestType,
      search: search
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetPestByPlant",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1 && data.code) {
          $('#tabs span').eq(0).text('热门病害(' + data.data.pestCount.totalDiseaseCount + ')');
          $('#tabs span').eq(1).text('热门虫害(' + data.data.pestCount.totalPestCount + ')');
          $('#tabs span').eq(2).text('热门草害(' + data.data.pestCount.totalWeedCount + ')');
          if (!data.data.listPestImg || data.data.listPestImg.length == 0) {
            $('.page1 .zwsj-box').show();
          } else {
            $('.page1 .zwsj-box').hide();
          }
          var tpl = $('#illnessListTemp').html();
          var html = juicer(tpl, data);
          $('#illnessList').html(html);
          flag1 = true;
          mui('#pullrefresh1').pullRefresh().scrollTo(0, 0, 0);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 获取虫害
  function getInsect() {
    var pestType = $('#tabs .activeTab').attr('pestType');
    var search = $('#pestName').val();
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      cropName: cropName,
      pestType: pestType,
      search: search
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetPestByPlant",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#tabs span').eq(0).text('热门病害(' + data.data.pestCount.totalDiseaseCount + ')');
          $('#tabs span').eq(1).text('热门虫害(' + data.data.pestCount.totalPestCount + ')');
          $('#tabs span').eq(2).text('热门草害(' + data.data.pestCount.totalWeedCount + ')');
          if (!data.data.listPestImg || data.data.listPestImg.length == 0) {
            $('.page22 .zwsj-box').show();
          } else {
            $('.page22 .zwsj-box').hide();
          }
          var tpl = $('#illnessListTemp').html();
          var html = juicer(tpl, data);
          $('#insectList').html(html);
          flag2 = true;
          mui('#pullrefresh2').pullRefresh().scrollTo(0, 0, 0);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 获取草害
  function getGrass() {
    var pestType = $('#tabs .activeTab').attr('pestType');
    var search = $('#pestName').val();
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      cropName: cropName,
      pestType: pestType,
      search: search
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetPestByPlant",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#tabs span').eq(0).text('热门病害(' + data.data.pestCount.totalDiseaseCount + ')');
          $('#tabs span').eq(1).text('热门虫害(' + data.data.pestCount.totalPestCount + ')');
          $('#tabs span').eq(2).text('热门草害(' + data.data.pestCount.totalWeedCount + ')');
          if (!data.data.listPestImg || data.data.listPestImg.length == 0) {
            $('.page3 .zwsj-box').show();
          } else {
            $('.page3 .zwsj-box').hide();
          }
          var tpl = $('#illnessListTemp').html();
          var html = juicer(tpl, data);
          $('#grassList').html(html);
          flag3 = true;
          mui('#pullrefresh3').pullRefresh().scrollTo(0, 0, 0);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 选择病虫草害分类
  $('#tabs span').on('tap', function () {
    $(this).addClass('activeTab').siblings().removeClass('activeTab');
    var pestType = $(this).attr('pestType');
    if (pestType == '病害') {
      $('.page1').show();
      $('.page22').hide();
      $('.page3').hide();
      if (!flag1) {
        getIllness();
      }
    } else if (pestType == '虫害') {
      $('.page1').hide();
      $('.page22').show();
      $('.page3').hide();
      if (!flag2) getInsect();
    } else if (pestType == '草害') {
      $('.page1').hide();
      $('.page22').hide();
      $('.page3').show();
      if (!flag3) getGrass();
    }
  });
  // 查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    flag1 = false;
    flag2 = false;
    flag3 = false;
    var pestType = $('#tabs .activeTab').attr('pestType');
    if (pestType == '病害') {
      getIllness();
    }
    if (pestType == '虫害') {
      getInsect();
    }
    if (pestType == '草害') {
      getGrass();
    }
    document.activeElement.blur(); //软键盘收起
  });

  // 返回按钮
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
  });
  // 点击病害跳转诊单详情
  $('#illnessList').on('tap', 'li', function () {
    var pestName = $(this).attr('pestDistinct');
    sessionStorage.setItem("pestName", JSON.stringify(pestName));
    location.href = "intelligenceDiagnosis_pest_detail.html";
  });
  // 点击虫害跳转诊单详情
  $('#insectList').on('tap', 'li', function () {
    var pestName = $(this).attr('pestDistinct');
    sessionStorage.setItem("pestName", JSON.stringify(pestName));
    location.href = "intelligenceDiagnosis_pest_detail.html";
  });
  // 点击草害跳转诊单详情
  $('#grassList').on('tap', 'li', function () {
    var pestName = $(this).attr('pestDistinct');
    sessionStorage.setItem("pestName", JSON.stringify(pestName));
    location.href = "intelligenceDiagnosis_pest_detail.html";
  });
});