$(function () {
  var cropName = JSON.parse(sessionStorage.getItem('cropName')); //作物名
  var pestName = JSON.parse(sessionStorage.getItem("pestName")); //病害名
  var pestDetail = null;
  // 获取诊单详情
  getDetail();
  function getDetail() {
    var requestData = {
      cropName: cropName,
      pestName: pestName
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetSolutionDetail",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1 && data.data) {
          $('.crop').text(data.data.crop ? data.data.crop : '空');
          $('.pest').text(data.data.pest ? data.data.pest : '空');
          $('.introduce').text(data.data.introduction ? data.data.introduction : '空');
          $('.symptom').text(data.data.damageSymptoms ? data.data.damageSymptoms : '空');
          $('.law').text(data.data.occurrenceRegularity ? data.data.occurrenceRegularity : '空');
          $('.prevent').text(data.data.control ? data.data.control : '空');
          pestDetail = data.data;
          var imageUrl = data.data.imgList.length > 0 ? data.data.imgList[data.data.imgList.length - 1] : 'img/zwtp.png';
          var imageUrlList = data.data.imgList.length > 0 ? data.data.imgList : ['img/zwtp.png'];
          var html = '<div class="mui-slider-group mui-slider-loop"><div class="mui-slider-item mui-slider-item-duplicate"><a href="#"><img src=' + imageUrl + '></a></div>';
          for (var i = 0; i < imageUrlList; i++) {
            if (i == 0) html += '<div class="mui-slider-item mui-active"><a href="#"><img src=' + imageUrlList[i] + '></a></div>';else html += '<div class="mui-slider-item"><a href="#"><img src=' + imageUrlList[i] + '></a></div>';
          }
          html += '<div class="mui-slider-item mui-slider-item-duplicate"><a href="#"><img src=' + imageUrlList[0] + '></a></div></div>';
          html += '<div class="mui-slider-indicator">';
          for (var j = 0; j < imageUrlList; j++) {
            if (j == 0) html += '<div class="mui-indicator mui-active"></div>';else html += '<div class="mui-indicator"></div>';
          }
          html += '</div>';
          $('#slider').html(html);
          mui("#slider").slider({
            interval: 0
          });
          // getMyImg()
        } else {
          mui.toast('暂无数据');
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 获取配方推荐用药
  getDrug();
  function getDrug() {
    var requestData = {
      cropName: cropName,
      pestName: pestName
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/GetSolution",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var text = '';
          if (data.data && data.data.length != 0) {
            for (var i = 0; i < data.data.length; i++) {
              text += i + 1 + "、" + data.data[i].registGoods.registerName + '；' + "<br/>";
            }
          } else {
            text += '无';
          }
          $('.recommend').html(text);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // //上传图片
  // var imgUrl = null;
  // var imgData = null;
  // // $('#img').hide()
  // //图片上传
  // $('#imgFile').on('change', function () {
  //     var img = document.getElementById("img");
  //     var file = document.querySelector('input[type=file]').files[0];
  //     var reader = new FileReader();
  //     var formData = new FormData();
  //     formData.append('avatar', file);
  //     reader.addEventListener("load", function () {
  //         $('#img').show()
  //         $.ajax({
  //             type: "POST",
  //             url: baseRequestUrl + "/Api/Diagnosis/UploadPestImage",
  //             contentType: false,
  //             headers: {
  //                 "Authorization": 'Bearer ' + localStorage.getItem('token'),
  //                 'data':
  //                     encodeURI(
  //                         JSON.stringify(
  //                             {
  //                                 "PestId": pestDetail.id,
  //                                 "PestName": pestName,
  //                                 "PlantName": cropName,
  //                             }
  //                         )
  //                     )
  //             },
  //             dataType: "json",
  //             data: formData,
  //             processData: false,
  //             sync: false,
  //             beforeSend: function () {
  //                 loading();
  //             },
  //             success: function (data) {
  //                 $('#loading').remove();
  //                 if (data.code == 1) {
  //                     // $(img).show()
  //                     // $('#imgFile').hide()
  //                     // $('#addBTN').hide()
  //                     // imgUrl = data.Data.url
  //                     // img.src = reader.result;  // 存储在本地的图片的base64编码  
  //                     // getMyImg()
  //                 } else {
  //                     // if (goodsInfo.maxImgUrlStr) {
  //                     //     $('#img').attr('src', goodsInfo.maxImgUrlStr)
  //                     // } else {
  //                     //     $('#img').css({ display: 'none' })
  //                     // }
  //                     mui.toast(data.msg)
  //                 }
  //             },
  //             error: function () {
  //                 setTimeout(function () {
  //                     $('#loading').remove();
  //                 }, 50)
  //                 mui.toast("数据提交失败，请稍后重试");
  //                 $(".mui-popup").remove();
  //             }
  //         });
  //     }, false);
  //     if (file) {
  //         reader.readAsDataURL(file);
  //     }
  // })
  // 点击图片放大
  // $('#img').on('click', function () {
  //     $('#img2').attr('src', $('#img').attr('src'))
  //     $('#lookIMG').css({ display: 'block' })
  //     $('.closeIMG').on('click', function () {
  //         $('#lookIMG').hide()
  //     })
  //     $('.delImg').on('click', function () {
  //         $('#lookIMG').hide()
  //         $('#img').hide()
  //         $('#imgFile').show()
  //         $('#addBTN').show()
  //         imgUrl = null
  //         $('#imgFile').val('')
  //     })

  // })
  // // 获取本店图片
  // function getMyImg() {
  //     var requestData = {
  //         "storeId": localStorage.getItem('storeId'),
  //         "pestId": pestDetail.id
  //     }
  //     $.ajax({
  //         type: "POST",
  //         url: baseRequestUrl + "/Api/Diagnosis/GetPestImageByStore",
  //         contentType: 'application/json; charset=utf-8',
  //         headers: { "Authorization": 'Bearer ' + localStorage.getItem('token') },
  //         data: JSON.stringify(requestData),
  //         dataType: "json",
  //         beforeSend: function () {
  //             loading();
  //         },
  //         success: function (data) {
  //             if (data.code == 1) {
  //                 4
  //                 var html = '';
  //                 if (data.data.length >= 1) {
  //                     for (var i = 0; i < data.data.length; i++) {
  //                         html += '<div class="mui-slider-item"><a href="#"><img style="height: 120px;width: 100px;" src=' + data.data[i].imageUrl + '></a></div>';
  //                     }
  //                     // // html += '<div class="mui-slider-item mui-slider-item-duplicate"><a href="#"><img style="height: 120px;width: 100px;" src=' + data.data[0].imageUrl + '></a></div></div>';
  //                     // html += '<div class="mui-slider-indicator">';
  //                     // for (var j = 0; j < data.data.length; j++) {
  //                     //     if (j == 0)
  //                     //         html += '<div class="mui-indicator mui-active"></div>';
  //                     //     else
  //                     //         html += '<div class="mui-indicator"></div>';
  //                     // }
  //                     // html += '</div>';
  //                 }

  //                 $('#myImg').html(html);
  //                 mui("#slider").slider({ interval: 0 });
  //                 $('#loading').remove();
  //             } else {
  //                 mui.toast(data.msg);
  //             }
  //         }, error: function (err) {
  //             setTimeout(function () {
  //                 $('#loading').remove();
  //             }, 50)
  //         }
  //     });
  // }
  // 获取本店配方
  getList();
  function getList() {
    var pageIndex = 1;
    var pageSize = 3;
    var searchWhereAnd = [cropName, pestName];
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      searchWhereAnd: searchWhereAnd
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Formula/MyFormulaList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var html = '';
          if (data.data && data.data.length != 0) {
            for (var i = 0; i < data.data.length; i++) {
              var data_list = JSON.stringify(data.data[i]);
              html += '<div type="wdpf" class="care haveCare" data_id=' + data.data[i].formula.id + '><p style="text-align:center;"><img src=' + data.data[i].formula.imgUrl + ' /></p><p style="overflow: hidden;white-space: nowrap;text-overflow: ellipsis;text-align:center;">' + data.data[i].formula.formulaName + '</p></div>';
            }
            sessionStorage.setItem('storeDoc', JSON.stringify(data.data));
          } else {
            html += '<div class="care"><p style="text-align:center;"><img src="img/zwtp.png" /></p><p style="overflow: hidden;white-space: nowrap;text-overflow: ellipsis;text-align:center;">暂无配方</p></div>';
          }
          $('#myStore').html(html);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 获取企业配方
  getManufacturerRecommendFormulaList();
  function getManufacturerRecommendFormulaList() {
    var pageIndex = 1;
    var pageSize = 3;
    var searchWhereAnd = [cropName, pestName];
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      searchWhereAnd: searchWhereAnd
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Manufacturer/GetManufacturerRecommendFormulaList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var html = '';
          if (data.data && data.data.length != 0) {
            for (var i = 0; i < data.data.length; i++) {
              var data_list = JSON.stringify(data.data[i]);
              html += '<div type="qypf" class="care haveCare" data_id=' + data.data[i].formula.id + '><p style="text-align:center;"><img src=' + data.data[i].formula.imgUrl + ' /></p><p style="overflow: hidden;white-space: nowrap;text-overflow: ellipsis;text-align:center;">' + data.data[i].formula.formulaName + '</p></div>';
            }
            sessionStorage.setItem('storeDoc', JSON.stringify(data.data));
          } else {
            html += '<div class="care"><p style="text-align:center;"><img src="img/zwtp.png" /></p><p style="overflow: hidden;white-space: nowrap;text-overflow: ellipsis;text-align:center;">暂无配方</p></div>';
          }
          $('#manufacturerStore').html(html);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 获取共享配方
  getCommonList();
  function getCommonList() {
    var pageIndex = 1;
    var pageSize = 3;
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      cropName: cropName,
      pestName: pestName
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Formula/CommonRecommend",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var html = '';
          if (data.data && data.data.length != 0) {
            for (var i = 0; i < data.data.length; i++) {
              html += '<div class="care haveCare" type="gxpf" data_id="' + data.data[i].formula.id + '" data_commonFormulaId="' + data.data[i].formula.id + '" class="care" > <p style="text-align:center;"><img src=' + data.data[i].formula.imgUrl + ' /></p> <p style="overflow: hidden;white-space: nowrap;text-overflow: ellipsis;text-align:center;">' + data.data[i].formula.formulaName + '</p></div > ';
            }
          } else {
            html += '<div id="" class="care"><p style="text-align:center;"><img src="img/zwtp.png" /></p><p style="overflow: hidden;white-space: nowrap;text-overflow: ellipsis;text-align:center;">暂无配方</p></div>';
          }
          sessionStorage.setItem('commonDoc', JSON.stringify(data.data));
          $('#commonStore').html(html);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 进入公共库配方详情
  $('#commonStore').on('tap', '.haveCare', function () {
    var type = $(this).attr("type");
    if (type == 'gxpf') {
      var id = $(this).attr('data_commonFormulaId');
      location.href = 'recipeDetail.html?id=' + id + '&type=' + type;
    } else {
      var id = $(this).attr('data_id');
      location.href = 'recipeDetail.html?id=' + id + '&type=' + type;
    }
  });
  //点击更多
  $("body").on("tap", ".moreFormula", function () {
    var type = $(this).attr("id");
    var searchWhereAnd = [cropName, pestName];
    sessionStorage.setItem("searchWhereAnd", JSON.stringify(searchWhereAnd));
    location.href = 'recipe.html?intelligentType=' + type;
  });
  // 返回按钮
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
  });
});