$(function () {
  var address = null;
  var cropName = JSON.parse(sessionStorage.getItem('cropName'));
  var pestName = JSON.parse(sessionStorage.getItem('pestName'));
  var landStorage = JSON.parse(sessionStorage.getItem('landStorage'));
  if (cropName) {
    $('#cropName input').val(cropName);
  }
  if (pestName) {
    $('#pestName input').val(pestName);
  }
  if (landStorage) {
    $('#ground span').text(landStorage.name);
  }
  // 插入日期选择
  function timers() {
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var day = myDate.getDate();
    if (month < 10) {
      month = "0" + month;
    }
    if (day < 10) {
      day = "0" + day;
    }
    var stime = year + "-" + month;
    var html = '<label>时间</label><p style="border: 1px solid #e3e3e3;width: 52%;text-align: right;height: 0.9rem;line-height: 0.9rem;margin-top: 0.15rem;margin-left: 0.15625rem;margin-right: 0.15625rem;" class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></p>';
    $('.timer').html(html);
  }
  timers();
  // 筛选栏日期选择
  var optionsJson = '';
  var options = 'JSON.parse(optionsJson)';
  var id = 'this.getAttribute()';
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  var result = $('.timer')[0];
  var btns = $('.timer .btn');
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      // var day = new Date().getDate();
      var option = {
        "type": "month",
        "endYear": year,
        "endMonth": month
        // "endDay": day, //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });

  //省市区选择
  var city_picker = null;
  $("#city_text00").on("tap", function () {
    city_picker = new mui.PopPicker({
      layer: 4
    });
    city_picker.setData(init_city_picker);
    city_picker.pickers[0].setSelectedIndex(6);
    city_picker.pickers[1].setSelectedIndex(7);
    city_picker.pickers[2].setSelectedIndex(4);
    setTimeout(function () {
      city_picker.show(function (items) {
        var ppvalue = items[0].value;
        if (ppvalue == undefined) ppvalue = "";
        var ccvalue = items[2].value;
        if (ccvalue == undefined) ccvalue = "";
        var civalue = items[1].value;
        if (civalue == undefined) civalue = "";
        var ttvalue = items[3].value;
        if (ttvalue == undefined) ttvalue = "";
        var pptext = items[0].text;
        if (pptext == undefined) pptext = "";
        var cctext = items[2].text;
        if (cctext == undefined) cctext = "";
        var citext = items[1].text;
        if (citext == undefined) citext = "";
        var tttext = items[3].text;
        if (tttext == undefined) tttext = "";
        $("#city_text").html(pptext + " " + citext + " " + cctext + " " + tttext);
        address = ppvalue + "/" + civalue + "/" + ccvalue + "/" + ttvalue;
      });
    }, 200);
  });

  //选择天气
  $('.weather').on('tap', 'button', function () {
    $(this).addClass('active').siblings().removeClass('active');
  });

  //跳转页面选择作物名
  $('#cropName').on('tap', 'i', function () {
    location.href = "xiaoshou_lingshou_xzcrop.html?pop=" + "crop";
  });

  // 跳转页面选择病虫草害
  $('#pestName').on('tap', 'i', function () {
    location.href = "xiaoshou_lingshou_xzcrop.html?pop=" + "pest";
  });

  //选择土壤
  $('#ground').on('tap', function () {
    window.location.href = 'intelligenceDiagnosis_uploadImage_chooseLand.html';
  });
  // 保存按钮点击事件
  $('.foots').on('tap', 'a', function () {
    var requestData = {
      plantName: $('#cropName input').val(),
      pestName: $('#pestName input').val(),
      takePicMonth: $('.timer strong').text(),
      takePicAddress: address,
      takePicWaether: $('.weather .active').val(),
      temperature: $('#temperature input').val(),
      humiDity: $('#humiDity input').val(),
      ground: landStorage ? landStorage.id : null,
      imageUrl: imgUrl
    };
    if (!requestData.imageUrl) {
      mui.toast('请上传图片');
      return;
    }
    if (!requestData.plantName) {
      mui.toast('请选择或填写作物名');
      return;
    }
    if (!requestData.pestName) {
      mui.toast('请选择或填写病虫草害名');
      return;
    }
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/AddPestImageData",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          sessionStorage.removeItem('cropName');
          sessionStorage.removeItem('pestName');
          sessionStorage.removeItem('landStorage');
          history.go(-1);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  });
  $('#img').hide();
  var imgUrl = null;
  //图片上传
  $('#imgFile').on('change', function () {
    var img = document.getElementById("img");
    var file = document.querySelector('input[type=file]').files[0];
    if (!/^image.+$/i.test(file.type)) return mui.toast('暂不支持此格式附件上传，请选择其他附件');
    if (file.size / 1024 / 1024 < constantsImgSizeForbtk) {
      var reader = new FileReader();
      var formData = new FormData();
      formData.append('avatar', file);
      reader.addEventListener("load", function () {
        $('#img').show();
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/Diagnosis/UploadPestImage",
          contentType: false,
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          data: formData,
          processData: false,
          sync: false,
          dataType: 'json',
          beforeSend: function beforeSend() {
            loading();
          },
          success: function success(data) {
            $('#loading').remove();
            if (data.Code == 1) {
              $(img).show();
              $('#imgFile').hide();
              $('#addBTN').hide();
              imgUrl = data.Data;
              img.src = reader.result; // 存储在本地的图片的base64编码  
            } else {
              $('#img').css({
                display: 'none'
              });
              mui.toast(data.Msg);
            }
          },
          error: function error() {
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            mui.toast("数据提交失败，请稍后重试");
            $(".mui-popup").remove();
          }
        });
      }, false);
      if (file) {
        reader.readAsDataURL(file);
      }
    } else {
      mui.toast('图片大小必须小于' + constantsImgSizeForbtk + 'M');
      return;
    }
  });
  // 点击图片放大
  $('#img').on('click', function () {
    $('#img2').attr('src', $('#img').attr('src'));
    $('#lookIMG').css({
      display: 'block'
    });
    $('.closeIMG').on('click', function () {
      $('#lookIMG').hide();
    });
    $('.delImg').on('click', function () {
      $('#lookIMG').hide();
      $('#img').hide();
      $('#imgFile').show();
      $('#addBTN').show();
      imgUrl = null;
      $('#imgFile').val('');
    });
  });

  //返回
  $('.goBack-btn').on('tap', function () {
    sessionStorage.removeItem('cropName');
    sessionStorage.removeItem('pestName');
    sessionStorage.removeItem('landStorage');
    history.go(-1);
  });
});