$(function () {
  mui.init();
  getLandList();
  function getLandList() {
    var requestData = {
      name: $('#orderName').val()
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Diagnosis/SearchGround",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(true); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var tpl = $('#myCollectListTemp').html();
          var html = juicer(tpl, data);
          $('#orderList').html(html);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }

  //查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    getLandList();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });

  //选择作物返回零售页面
  $('#orderList').on('tap', 'li', function () {
    var name = $(this).attr('data_name');
    var id = $(this).attr('data_id');
    var request = {
      name: name,
      id: id
    };
    sessionStorage.setItem('landStorage', JSON.stringify(request));
    window.history.go(-1);
  });
  // 点击返回按钮
  $('.tops').on('tap', '.goBack-btn', function () {
    window.history.go(-1);
  });
});