$(function () {
  //// 设置自动刷新编辑 为false
  mui.init();
  mui('#pullrefresh').scroll({
    deceleration: 0.0005 //flick 减速系数，系数越大，滚动速度越慢，滚动距离越小，默认值0.0006
  });

  mui.previewImage();
  var mask = mui.createMask();
  var goodsId = getUrlParam("jinhuoId");
  loadGoodsInfo(); // 初始化商品包装信息
  function loadGoodsInfo() {
    mask.show();
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWOrderPurchase/GetDetail?id=" + goodsId,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      async: false,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var info = data.data;
          info.orderPurchaseGoods.forEach(function (i) {
            i.allPrice = ToMoney(i.actualFee * i.quantity);
            i.actualFee = ToMoney(i.actualFee);
            i.defaultFee = ToMoney(i.defaultFee);
            i.spec = ToQuit(i.spec);
            i.quantity = ToQuit(i.quantity);
          });
          info.actualTotalFee = ToMoney(info.actualTotalFee);
          info.totalQuantity = ToQuit(info.totalQuantity);
          info.defaultTotalFee = ToMoney(info.defaultTotalFee);
          var html = juicer($("#goodDetailsTemplate").html(), info);
          $("#goodDetailsWrapper").html(html);
          if (info.imgList && info.imgList.find(function (item) {
            return item.attachmentType == 2;
          })) {
            $('#signWrapper').show();
            $('#signImg').attr('src', info.imgList.find(function (item) {
              return item.attachmentType == 2;
            }).imageUrl);
          }
          if (info.imgList && info.imgList.find(function (item) {
            return item.attachmentType == 1;
          })) {
            $('#fileWrapper').show();
            info.imgList.filter(function (item) {
              return item.attachmentType == 1;
            }).map(function (i) {
              return i.imageUrl;
            }).forEach(function (item, index) {
              var result = '';
              if (/\.(jpg|jepg|png|bmp|gif)$/.test(item)) result += '<img class="showdivTop" src="img/preview.svg" /><img data-preview-src=""  id="img' + index + '" class="showimg" src="' + item + '" data_src="' + item + '"/>';else if (/\.(mp4|avi|rmvb|WMV|MPEG|flv|3gp|rm|mpg)$/i.test(item)) result += '<img class="showdivTop" src="img/play.svg" /><video class="showimg" src="' + item + '" data_src="' + item + '" controller>您的浏览器暂不支持播放视频</video>';else result += '<img class="showdivTop" src="img/download.svg" /><img id="img' + index + '" class="showimg file" src="img/file.png" data_src="' + item + '"/>';
              var li = document.createElement('li');
              li.innerHTML = result;
              document.getElementById("showui1").appendChild(li);
            });
          }
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("加载信息失败");
        $(".mui-popup").remove();
      }
    });
  }
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = "jiehuo_dj.html";
  });
  //播放视频
  $('body').on('tap', 'video.showimg', function () {
    var src = $(this).attr('data_src');
    mui.alert("<video src=".concat(src, " height='40%' style='width:100%' controls></video>"), '视频播放');
  });
  //下载文件
  $('body').on('tap', 'img.file', function () {
    var src = $(this).attr('data_src');
    if (useLocal) JiaoHu.openBrowser(src);
  });
  //删除列表
  var can = false;
  var questFlag = false;
  var guid = window.getGuid();
  $("body").on('tap', '#sc-btn', function () {
    if (can) return;
    can = true;
    var btnArray = ['否', '是'];
    mui.confirm('确认删除？', '删除', btnArray, function (e) {
      can = false;
      if (e.index == 1) {
        if (questFlag) return;
        questFlag = true;
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/SWOrderPurchase/Delete",
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          dataType: "json",
          data: JSON.stringify({
            ids: [goodsId],
            id: guid
          }),
          beforeSend: function beforeSend() {
            loading();
            mask.show();
          },
          success: function (_success) {
            function success(_x) {
              return _success.apply(this, arguments);
            }
            success.toString = function () {
              return _success.toString();
            };
            return success;
          }(function (data) {
            questFlag = false;
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
            mask.close();
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            if (data.code == 1) {
              count = 1;
              setTimeout(function () {
                window.history.go(-1);
              }, 1000);
              mui.toast('删除成功');
              success();
            } else {
              mui.toast(data.msg); //将错误信息弹出显示
            }
          }),

          error: function error() {
            questFlag = false;
            mask.close();
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            mui.toast("数据提交失败，请稍后重试");
          }
        });
      } else return false;
    });
  });
});