$(function () {
  //调试使用
  if (window.vDebug) new VConsole();
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    var keyword = $('#orderSearch').val();
    if (!keyword) {
      return false;
    }
    //销售单据列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWOrderPurchase/GetByOrderNo?orderNo=" + keyword,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (data.data) {
            window.location.href = 'jiehuo_wyjh_bj.html?id=' + keyword;
          } else {
            mui.toast(data.msg);
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
    document.activeElement.blur(); //软键盘收起
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = 'index.html';
  });
  //扫描二维码
  $("#btnsaomiao").on("click", function () {
    if (useLocal) {
      JiaoHu.scan();
    }
  });
  getReceiveType();
  //回收点类型
  function getReceiveType() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWDepartment/GetByUserId",
      contentType: 'application/json; charset=utf-8',
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1 && data.data) window.receiveType = data.data.subTag;else mui.toast(data.msg);
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
});
//回收点类型 1初级回收点 2集中点
window.receiveType = 1;
// 扫码回调函数
window.getcode = function (s, _s1) {
  var s1 = _s1;
  s1 = s1.match(/https?:\/\//i) && s1.match(/^(.+)(https?:\/\/.+)$/i) ? RegExp.$2 : s1;
  //console.log("scanCallback==", s1)
  console.log("getcode==", s, s1);
  if (JiaoHu) {
    var orderNumber = s1.slice(0, 2);
    var departmentType = s1.includes(',') ? s1.split(',')[1] : '';
    var departmentId = s1.includes(',') ? s1.split(',')[0].slice(3) : '';
    if (window.receiveType == 2 && departmentType == 1) return window.location.href = 'centralReceive.html?id=' + departmentId;else if (!/^HS$/i.test(orderNumber)) return mui.toast('请扫对应的业务二维码');
    $("#orderSearch").val(s1);
    var saoma = s1;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWOrderPurchase/GetByOrderNo?orderNo=" + saoma,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (data.data) {
            window.location.href = 'jiehuo_wyjh_bj.html?id=' + saoma;
          } else {
            mui.toast(data.msg);
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
};