$(function () {
  //// 设置自动刷新编辑 为false
  mui.init();
  mui('#pullrefresh').scroll({
    deceleration: 0.0005 //flick 减速系数，系数越大，滚动速度越慢，滚动距离越小，默认值0.0006
  });

  var mask = mui.createMask();
  var id = getUrlParam("id");
  var goodsInfo;
  loadGoodsInfo(); // 初始化商品包装信息
  function loadGoodsInfo() {
    mask.show();
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWOrderPurchase/GetByOrderNo?orderNo=" + id,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      async: false,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var info = jQuery.extend(true, {}, data.data);
          info.items.forEach(function (i) {
            i.allPrice = ToMoney(i.defaultFee * i.quantity);
            i.defaultFee = ToMoney(i.defaultFee);
            i.spec = ToQuit(i.spec);
          });
          info.actualTotalFee = ToMoney(info.actualTotalFee);
          info.totalQuantity = ToQuit(info.totalQuantity);
          info.defaultTotalFee = ToMoney(info.defaultTotalFee);
          var html = juicer($("#goodDetailsTemplate").html(), info);
          $("#goodDetailsWrapper").html(html);
          goodsInfo = data.data;
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("加载信息失败");
        $(".mui-popup").remove();
      }
    });
  }
  //新增保存
  $("body").on('tap', '#bc-btn', function () {
    var mask = mui.createMask();
    var quantity = [];
    var actualFee = [];
    //下拉数据选择
    $(".add_box").each(function () {
      quantity.push($(this).find("#hssl").val());
      actualFee.push($(this).find("#hsje").val());
    });
    goodsInfo.orderPurchaseGoods = goodsInfo.items;
    //数据组装
    // for (i = 0; i < actualFee.length; i++) {
    //     goodsInfo.orderPurchaseGoods[i].quantity = quantity[i]
    //     goodsInfo.orderPurchaseGoods[i].actualFee = actualFee[i]
    // }
    //信息校验
    var ret = /^(([1-9][0-9]*)|(([0]\.\d{1,2}|[1-9][0-9]*\.\d{1,2})))$/;
    var numReg = /^(\d|\.)*$/;
    if (goodsInfo.orderPurchaseGoods.length > 0) {
      for (j = 0; j < goodsInfo.orderPurchaseGoods.length; j++) {
        if (goodsInfo.orderPurchaseGoods[j].quantity == '' || !numReg.test(goodsInfo.orderPurchaseGoods[j].quantity)) {
          mask.show();
          mui.alert('请输入正确的回收' + +goodsInfo.orderPurchaseGoods[j].chargingtypename, '', function () {
            mask.close();
          });
          $($(".add_box").find("#hssl")[j]).addClass('cuowu-input-new');
          return false;
        } else {
          $($(".add_box").find("#hssl")[j]).removeClass('cuowu-input-new');
        }
        if (goodsInfo.orderPurchaseGoods[j].actualFee == '' || !ret.test(goodsInfo.orderPurchaseGoods[j].actualFee)) {
          mask.show();
          mui.alert('请输入正确的实际单价(元)，最多保留两位小数', '', function () {
            mask.close();
          });
          $($(".add_box").find("#hsje")[j]).addClass('cuowu-input-new');
          return false;
        } else {
          $($(".add_box").find("#hsje")[j]).removeClass('cuowu-input-new');
        }
      }
    }
    goodsInfo.actualTotalFee = $('#sjzj').attr('actualTotalFee');
    sendData(goodsInfo);
  });
  //实付金额变动
  $("body").on("input propertychange", "#hsje", function (e) {
    $('#sjzj').html(parseFloat($('#hsje').val()) * parseFloat($('#hssl').val()));
  });
  var num = 1;
  function sendData(goodsInfo) {
    if (num > 1) {
      return false;
    }
    num++;
    goodsInfo.orderType = 2;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWOrderPurchase/Add",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(goodsInfo),
      dataType: "json",
      sync: false,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          setTimeout(function () {
            mask.close();
            window.location.href = "jiehuo_wyjh.html";
          }, 1000);
          mui.toast('操作成功');
          success();
        } else {
          num = 1;
          mui.toast(data.msg);
          mask.close();
        }
      }),
      error: function error() {
        num = 1;
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = "jiehuo_wyjh.html";
  });
});