$(function () {
  var myScore = parseFloat(localStorage.getItem('myScore'));
  $('#jg').val(myScore);
  if (myScore) {
    $('#jg').val(myScore);
  } else {
    $('#jg').val(1);
  }
  $('#jfsz-btn').on('tap', function () {
    var jfval = $('#jg').val();
    var requestData = {
      "isScore": true,
      "scoreScale": jfval
    };
    var reg = /^[1-9]\d*$/;
    if (!reg.test(jfval) || jfval <= 0 || !jfval) {
      mui.toast('积分需设置为大于0的整数');
      return false;
    }
    var mask = mui.createMask();
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/PutScore",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          setTimeout(function () {
            mask.close();
            window.history.go(-1);
          }, 1000);
          mui.toast('积分设置成功！');
          success();
        } else {
          mask.close();
          mui.toast(data.msg);
        }
        localStorage.setItem('myScore', requestData.scoreScale);
      }),
      error: function error() {
        setTimeout(function () {
          mask.close();
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
  });

  //禁止小数点输入 
  $('#jg').on('input propertychange keyup', function () {
    var jfval = $("#jg").val();
    if (!/^\d+$/.test(jfval)) {
      jfval.split('.');
    }
  });
});