$(function () {
  var pageIndex = 1;
  var pageSize = 10;
  //返回
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
  });
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: false
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  // var canF5 = true;
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      getSecretMessage();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  function pullupRefresh() {
    pageIndex++;
    setTimeout(function () {
      getSecretMessage();
    }, 1500);
  }

  //禁用药
  getSecretMessage();
  //私信
  function getSecretMessage() {
    var req = {
      "search": $('#txtGoodsName').val(),
      "isLimit": "true",
      "pageIndex": pageIndex,
      "pageSize": pageSize
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Message/GetLimit",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(req),
      dataType: "json",
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          if (data.data.length > 0) {
            if (pageIndex == 1) {
              loadGoodsData = data.data;
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
            } else {
              $(".zwsj-box").hide();
              for (var i = 0; i < data.data.length; i++) {
                loadGoodsData.push(data.data[i]);
              }
            }
            var a = {
              data: []
            };
            a.data = loadGoodsData;
            $(".zwsj-box").hide();
            var html = juicer($("#gongyingshangzhangkuanListTemp").html(), a);
            $("#gyszkList").html(html);
          } else {
            $(".zwsj-box").show();
            $("#pullrefresh").hide();
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        mui.toast("用户消息获取失败，请稍后重试");
      }
    });
  }
  //查询
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageIndex = 1;
    getSecretMessage();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
  });
});