$(function () {
  var allData = [];
  var oneData = {};
  $(".start-time").text(new Date().AddDays(-30).Format("yyyy-MM-dd"));
  $(".end-time").text(new Date().Format("yyyy-MM-dd"));
  var mask = mui.createMask();
  var pageIndex = 1; //count 表示页数
  var startTime = "";
  var endTime = "";
  var goodsId = getUrlParam("id");
  var requestUrl = "/Api/GoodsInventory/WholeStockList"; //货品盘点记录
  if (goodsId) {
    requestUrl = "/Api/GoodsInventory/OneList";
    $("header h3").text("商品盘点记录");
  } else {
    $("header h3").text("批量商品盘点记录");
  }
  var kucunpandianListTemp = $("#kucunpandianListTemp");
  var isQuery = false;
  // 上下拉动公共代码
  function pullPublic() {
    var table = document.body.querySelector('.mui-table-view');
    var cells = document.body.querySelectorAll('.mui-table-view-cell');
    var requestData = {
      "goodsId": goodsId,
      "storeId": JSON.parse(localStorage.getItem(CookieName)).storeId,
      "startTime": $(".start-time").text(),
      "endTime": $(".end-time").text(),
      "pageIndex": pageIndex,
      "pageSize": 6
    };
    //货品盘点记录
    $.ajax({
      type: "POST",
      url: baseRequestUrl + requestUrl,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        isQuery = false;
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 6 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          allData = data.data;
          var tpl = kucunpandianListTemp.html();
          var html = juicer(tpl, data);
          if (html.trim() != "") {
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              $(table).html(html);
            } else {
              $(table).append(html);
            }
            pageIndex++;
          } else {
            if (pageIndex == 1) {
              $(table).html("");
              $(".zwsj-box").show();
              // $("#pullrefresh").hide();
              $('#loading').remove();
            }
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }
  var result = $('.timer')[0];
  var btns = $('.btn');
  var optionsJson = '';
  var options = 'JSON.parse(optionsJson)';
  var id = '';
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      options = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(options);
      picker.show(function (rs) {
        if ($this.hasClass('endTimeBox')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTimeBox')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });
  $(".kc-title").on('tap', '#hy-dhjl-btn', function (event) {
    if (!isQuery) {
      isQuery = true;
      var startTime = $(".start-time").text();
      var endTime = $(".end-time").text();
      pageIndex = 1;
      pullupRefresh();
    }
  });
  //跳转到详情页面
  $("body").on("tap", '#one_GYS', function () {
    //退货单据详情
    var index = $(this).attr('data_index');
    oneData = allData[index];
    sessionStorage.setItem("pandianjiluOneData", JSON.stringify(oneData));
    window.location.href = "huopinkucun_shangpinpandianjilu_xq.html";
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});