$(function () {
  //是否总店
  var isMainStore = checkMenuPermission("/branchManage").canJump;
  var selectData = JSON.parse(localStorage.getItem("hpkcSelectData"));

  //分店且是零差率商品不显示盘点按钮
  if (!isMainStore && selectData && selectData.isZeroPriceGoods) {
    $('#kcpd-btn').hide();
  }
  var isPD1 = false;
  var isPD2 = false;
  var isPD3 = false;
  var isYJ = false;
  var branchStoreId = getUrlParam('branchStoreId');
  if (branchStoreId) $('#openPopover').hide();
  if (!selectData.multipleUnit) {
    $('#dbcb-btn').hide();
  }
  initData(); // 初始化信息
  function initData() {
    if (selectData.maxImgUrl != null) {
      $("#shangpinImg").attr("src", selectData.maxImgUrl);
    }
    $("#sbm").text(selectData.goodsName);
    $("#spfl").text(selectData.goodsTypeName);
    $("#splx").text(selectData.goodsCategoryName || '--');
    $("#ggbz").text(selectData.specifications);
    $("#goodsClassLabel").text(selectData.goodsClassLabel || '--');
    $("#cb").text(toThousands(selectData.costPrice) + ' 元');
    $("#dqkc").text(selectData.goodsQuantity + ' ' + selectData.packageUnit);
    $("#kcje").text(toThousands(selectData.goodsPrice) + ' 元'); //库存金额
    $("#zxkc").text(selectData.minNumber);
    $("#pdcs").text(selectData.goodsInventoryQuantity);
    $("#djzh").text(selectData.registerNumber ? selectData.registerNumber : '--');
    localStorage.setItem("hpkcSelectData", JSON.stringify(selectData));
  }
  //库存盘点
  $(".btn2").on('tap', '#kcpd-btn', function () {
    if (!isPD1) {
      isPD1 = true;
      var $this = $(this);
      var mask = mui.createMask();
      var btnArray = ['取消', '保存'];
      mask.show();
      $.ajax({
        type: "POST",
        async: true,
        url: baseRequestUrl + "/Api/GoodsStock/GetGoodsStockByWareHouse",
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          goodsId: selectData.goodsId
        }),
        dataType: "json",
        contentType: 'application/json; charset=utf-8',
        beforeSend: function beforeSend() {
          loading();
        },
        success: function (_success) {
          function success(_x) {
            return _success.apply(this, arguments);
          }
          success.toString = function () {
            return _success.toString();
          };
          return success;
        }(function (data) {
          isPD1 = false;
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          if (data.code == 1) {
            var CKList = data.data;
            var tmp = '';
            for (var i = 0; i < CKList.length; i++) {
              if (i == 0) {
                tmp += "<option selected data_quantity = " + CKList[i].goodsQuantity + " value=" + CKList[i].wareHouseId + ">" + CKList[i].wareHouseName + '　库存： ' + CKList[i].goodsQuantity + selectData.packageUnit + "</option>";
              } else {
                tmp += "<option data_quantity = " + CKList[i].goodsQuantity + " value=" + CKList[i].wareHouseId + ">" + CKList[i].wareHouseName + '  库存：' + CKList[i].goodsQuantity + selectData.packageUnit + "</option>";
              }
            }
            var html = '<div class="tcc">';
            html += '<p><label>库存数量：</label><select style="border: 0.02rem rgba(0,0,0,.2) solid !important;padding-left: 0.1rem;height: 1.0rem ;width:60%" id="nowSelectHouse" >"' + tmp + '"</select></p>';
            html += '<p><label>盘点数量</label><input type="number" style="background:#fff!important " id="pdsl" placeholder="请输入盘点数量" maxlength="15"><span>*</span></p>';
            html += '</div>';
            mask.show();
            mui.confirm(html, '库存盘点', btnArray, function (e) {
              if (e.index == 1) {
                if (!isPD2) {
                  isPD2 = true;
                  var quantity = $("#nowSelectHouse").find("option:selected").attr("data_quantity");
                  var pdsl = $("#pdsl").val();
                  if (pdsl == "" || pdsl < 0) {
                    mask.show();
                    mui.alert('请输入正确的盘点数量', '', function () {
                      mask.close();
                    });
                    return false;
                  }
                  var requestData = {
                    "goodsId": selectData.goodsId,
                    "inventoryQuantity": pdsl,
                    "stockQuantity": quantity,
                    "warehouseId": $('#nowSelectHouse').val()
                  };
                  var reg = /^\d+\.\d+$/;
                  var yz = reg.test(pdsl);
                  var arrLen = $("#pdsl").val().split(".");
                  if (arrLen.length == 2) {
                    if (arrLen[1].length > 3) {
                      mask.show();
                      mui.alert('请输入至小数点后3位！', '', function () {
                        mask.close();
                      });
                      return false;
                    }
                  }
                  //新增单个盘点库存
                  $.ajax({
                    type: "POST",
                    contentType: 'application/json; charset=utf-8',
                    headers: {
                      "Authorization": 'Bearer ' + localStorage.getItem('token')
                    },
                    url: baseRequestUrl + "/Api/GoodsInventory/OneAdd",
                    data: JSON.stringify(requestData),
                    dataType: "json",
                    beforeSend: function beforeSend() {
                      mask.show();
                    },
                    success: function (_success2) {
                      function success(_x2) {
                        return _success2.apply(this, arguments);
                      }
                      success.toString = function () {
                        return _success2.toString();
                      };
                      return success;
                    }(function (data) {
                      localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F 
                      isPD2 = false;
                      if (data.code == 1) {
                        selectData.goodsInventoryQuantity = selectData.goodsInventoryQuantity + 1;
                        initData();
                        mask.close();
                        var btnArray = ['否', '是'];
                        if (data.data.inventoryResult != "正常") {
                          mui.confirm('<p>确认调整！</p>', '系统提示', btnArray, function (e) {
                            if (e.index == 1) {
                              if (!isPD3) {
                                isPD3 = true;
                                //调整库存
                                $.ajax({
                                  type: "POST",
                                  contentType: 'application/json; charset=utf-8',
                                  url: baseRequestUrl + "/Api/GoodsInventory/OneAddGoodsInventoryAdjust?id=" + data.data.id,
                                  headers: {
                                    "Authorization": 'Bearer ' + localStorage.getItem('token')
                                  },
                                  dataType: "json",
                                  success: function (_success3) {
                                    function success(_x3) {
                                      return _success3.apply(this, arguments);
                                    }
                                    success.toString = function () {
                                      return _success3.toString();
                                    };
                                    return success;
                                  }(function (addData) {
                                    localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
                                    isPD3 = false;
                                    if (addData.code == 1) {
                                      selectData.goodsQuantity = pdsl - quantity + selectData.goodsQuantity;
                                      selectData.goodsPrice = selectData.costPrice * selectData.goodsQuantity;
                                      mui.toast("调整成功");
                                      success();
                                      initData();
                                    } else {
                                      mui.toast(addData.msg);
                                    }
                                  })
                                });
                              }
                            }
                            mask.close();
                            $(".mui-popup").remove();
                          });
                        }
                      } else {
                        mask.close();
                        mui.toast(data.msg);
                      }
                    }),
                    error: function error() {
                      isPD2 = false;
                      mask.close();
                      mui.toast("数据提交失败，请稍后重试");
                      $(".mui-popup").remove();
                    }
                  });
                }
              } else {
                mask.show();
                mask.close();
                $(".mui-popup").remove();
                return false;
              }
            });
          } else {
            mui.toast(data.msg);
          }
        })
      });
    }
  });
  //预警设置
  $("body").on('tap', '#yjsz-btn', function () {
    $("#popover").hide();
    $(".mui-backdrop").hide();
    var $this = $(this);
    var mask = mui.createMask();
    var btnArray = ['取消', '保存'];
    var html = '<div class="tcc">';
    // html += '<p><label>商品分类：</label><input type="text" disabled="disabled" class="disabled" value="' + selectData.goodsTypeName + '"></p>';
    // html += '<p><label>商标名：</label><input type="text" disabled="disabled" class="disabled" value="' + selectData.goodsName + '"></p>';
    // html += '<p><label>登记证号：</label><input type="text" disabled="disabled" class="disabled" value="' + selectData.registerNumber + '"></p>';
    // html += '<p><label>包装/规格：</label><input type="text" disabled="disabled" class="disabled" value="' + selectData.specPackage + '"></p>';
    html += '<p><label>最小库存：</label><input style= "background: #fff!important;" type="number" id="inputZxkc" value="' + selectData.minNumber + '"><span>*</span></p>';
    html += '</div>';
    mask.show();
    //包含小数的正则
    // var re=new RegExp(/^(([1-9]+[0-9]*.{1}[0-9]+)|([0].{1}[1-9]+[0-9]*)|([1-9][0-9]*)|([0][.][0-9]+[1-9]*))$/); 
    mui.confirm(html, '库存预警', btnArray, function (e) {
      if (e.index == 1) {
        if (!isYJ) {
          isYJ = true;
          var zxkc = $("#inputZxkc").val();
          var reg = /^([1-9]\d*|[0]{1,1})$/;
          var yz = reg.test(zxkc);
          var zxkc1 = zxkc[0];
          var yz2 = false;
          //判断首位不能为0
          if (zxkc.length > 1) {
            if (zxkc1 != 0) {
              yz2 = true;
            }
          } else {
            yz2 = true;
          }
          if (yz == false || yz2 == false) {
            mask.show();
            mui.alert('请输入整数数量', '', function () {
              mask.close();
            });
            return false;
          }
          if (zxkc == "") {
            mask.show();
            mui.alert('请输入最小库存', '', function () {
              mask.close();
            });
            return false;
          }
          $.ajax({
            type: "POST",
            contentType: 'application/json; charset=utf-8',
            url: baseRequestUrl + "/Api/Goods/EditGoodsMinNumber?id=" + selectData.goodsId + "&minNumber=" + zxkc,
            headers: {
              "Authorization": 'Bearer ' + localStorage.getItem('token')
            },
            dataType: "json",
            beforeSend: function beforeSend() {
              loading();
            },
            success: function (_success4) {
              function success(_x4) {
                return _success4.apply(this, arguments);
              }
              success.toString = function () {
                return _success4.toString();
              };
              return success;
            }(function (data) {
              localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
              setTimeout(function () {
                $('#loading').remove();
              }, 50);
              isYJ = false;
              if (data.code == 1) {
                selectData.minNumber = zxkc;
                initData();
                setTimeout(function () {
                  $(".mui-popup").remove();
                  mask.close();
                }, 1000);
                mui.toast('设置成功');
                success();
                // mui.alert('<p>恭喜你设置成功！</p>', '', function () {
                //     mask.close();
                //     $(".mui-popup").remove();
                // })
              } else {
                mui.toast(data.msg);
              }
            }),
            error: function error() {
              setTimeout(function () {
                $('#loading').remove();
              }, 50);
              isYJ = false;
              mui.toast("数据提交失败，请稍后重试");
              $(".mui-popup").remove();
            }
          });
        }
      } else {
        $(".mui-popup").remove();
        mask.close();
        return false;
      }
    });
  });
  //查询当前商品所有仓库的的总库存
  function loadGoodsLst() {
    $.ajax({
      type: "POST",
      async: true,
      url: baseRequestUrl + "/api/GoodsStock/StoreList",
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify({
        "wareHouseId": "",
        "storeId": selectData.storeId,
        "goodsName": selectData.goodsName,
        "goodsType": selectData.goodsType,
        "goodsCategoryCode": selectData.goodsCategoryCode,
        "earlyWarningState": 0,
        "pageIndex": 1,
        "pageSize": 10
      }),
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var kuncunNumber = 0;
          for (var i = 0; i < data.data.length; i++) {
            kuncunNumber = kuncunNumber + data.data[i].goodsQuantity;
          }
          if (kuncunNumber == 0) {
            mui.toast("该商品没有库存，不能进行拆包打包！");
          } else {
            window.location = "huopinkucun_dabaochaibao.html?id=" + selectData.goodsId;
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    sessionStorage.removeItem("wareHouseInfo");
    window.history.go(-1);
  });
  //跳转商品盘点记录
  $("#pdjl-btn").on('tap', function () {
    window.location = "huopinkucun_shangpinpandianjilu.html?id=" + selectData.goodsId;
  });
  //跳转商品打包拆包
  $("#dbcb-btn").on('tap', function () {
    loadGoodsLst();
  });
  //获取店的连锁权限
  getPermissions();
  function getPermissions() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Member/GetAll",
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      data: JSON.stringify({
        branchStoreId: localStorage.getItem('storeId')
      }),
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      success: function success(data) {
        $('#loading').remove();
        if (data.code == 1) {
          if (data.data.isGoodsState) {
            $('.hidden-price').show();
          }
        } else mui.toast(data.msg);
      }
    });
  }
});