/*
 * @Descripttion: 商品临期提醒
 * @Date: 2021-07-29 17:47:16
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2022-03-24 14:24:56
 */
$(function () {
  var menuALLList = localStorage.getItem('menuAllList') ? JSON.parse(localStorage.getItem('menuAllList')) : [];
  var menuShow = ['R_ERP_1007001', 'R_ERP_1007002', 'R_ERP_1007003', 'R_ERP_1007004'];
  var higher = menuALLList.filter(function (item) {
    return item.id == 'R_ERP_1007';
  })[0].children;
  for (var i = 0; i < menuShow.length; i++) {
    for (var j = 0; j < higher.length; j++) {
      if (menuShow[i] == higher[j].id) {
        $("#".concat(menuShow[i])).css('display', 'block');
        break;
      }
    }
  }
  var goodsTempDay = 15; //商品临期提醒天数
  var goodDatas = [];
  var pageIndex = 1; //count 表示页数
  var goodsType = null;
  var goodsCategoryCode = "";
  var initId = '';
  var search;
  var CKList = []; //仓库list
  var queryGoodsName = getUrlParam("goodsName");
  var dbcbGoodsName = sessionStorage.getItem("dbcbGoodsName");
  var isChaxun = false; //防止连续点击两次而请求两次接口
  var isTYYJ = false;
  var ckPopPicker = [{
    text: '全部'
  }]; //仓库储存数据
  var branchesPicker = [{
    text: '无',
    value: ''
  }];
  var branch_picker = null;
  var branchStoreId = '';
  initPage();
  function initPage() {
    if (localStorage.getItem('hasChain')) {
      $.ajax({
        type: 'post',
        url: baseRequestUrl + '/Api/BranchStore/GetBranchStoreSelect',
        //请求数据的地址
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        //返回数据形式为json
        success: function success(res) {
          if (res.code == 1 && res.data) {
            branchesPicker = branchesPicker.length > 1 ? branchesPicker : branchesPicker.concat(res.data.map(function (item) {
              return {
                text: item.branchStoreName,
                value: item.branchStoreId
              };
            }));
          }
        },
        error: function error(err) {
          mui.toast(err);
        }
      });
    } else $('#wrapper_branches').hide();
    getCKList();
  }
  //获得仓库list 根据仓库加载商品
  function getCKList(branchId) {
    $.ajax({
      type: "POST",
      async: true,
      url: baseRequestUrl + (!branchId ? "/Api/WareHouse/GetAll" : "/Api/WareHouse/GetAll?brachStoreId=" + branchId),
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          CKList = data.data;
          localStorage.setItem('CKList', JSON.stringify(CKList));
          getTempDay(function () {
            return (
              //下拉加载
              mui.init({
                swipeBack: true,
                //启用右滑关闭功能
                pullRefresh: {
                  container: '#pullrefresh',
                  subpages: [{
                    url: window.location.href,
                    //下拉刷新内容页面地址
                    id: '#pullrefresh',
                    //内容页面标志
                    styles: {
                      top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
                      //其它参数定义
                    }
                  }],

                  up: {
                    contentrefresh: '正在加载...',
                    callback: pullupRefresh,
                    auto: true
                  },
                  down: {
                    style: 'circle',
                    //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
                    auto: false,
                    //可选,默认false.首次加载自动上拉刷新一次
                    callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
                  }
                }
              })
            );
          });

          loadingCK();
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  function loadingCK() {
    ckPopPicker = ckPopPicker.slice(0, 1);
    for (var i = 0; i < CKList.length; i++) {
      if (CKList[i].isDefault && CKList[i].warehouseName != "默认") ckPopPicker.push({
        text: CKList[i].warehouseName + '【默认】',
        value: CKList[i].id
      });else ckPopPicker.push({
        text: CKList[i].warehouseName,
        value: CKList[i].id
      });
    }
  }
  //获取默认预警天数
  function getTempDay(cb) {
    $.ajax({
      type: "POST",
      async: true,
      url: baseRequestUrl + '/Api/Store/GetGoosTempDay',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        if (data.code == 1) {
          $('#tempDay-input').val(data.data);
          goodsTempDay = data.data;
          cb && cb();
        } else mui.toast(data.msg);
      }
    });
  }
  //选择分店
  $("#btn_branches").on("tap", function () {
    branch_picker = new mui.PopPicker({
      layer: 1
    });
    branch_picker.setData(branchesPicker);
    setTimeout(function () {
      branch_picker.show(function (items) {
        $("#branches").text((items[0] || {}).text);
        branchStoreId = (items[0] || {}).value;
        $.ajax({
          type: "POST",
          async: true,
          url: baseRequestUrl + "/Api/WareHouse/GetAll?brachStoreId=" + branchStoreId,
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          dataType: "json",
          contentType: 'application/json; charset=utf-8',
          beforeSend: function beforeSend() {
            loading();
          },
          success: function success(data) {
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            if (data.code == 1) {
              CKList = data.data;
              localStorage.setItem('CKList', JSON.stringify(CKList));
              loadingCK();
            } else {
              mui.toast(data.msg);
            }
          }
        });
      });
    }, 200);
  });
  //临期天数输入改变
  $('#tempDay-input').on('input propertychange', function (e) {
    goodsTempDay = e.target.value ? e.target.value * 1 : 0;
  });
  // 加载查询商品列表
  function loadGoodsLst(id) {
    var storeId = JSON.parse(localStorage.getItem(CookieName)).storeId;
    var goodsName = $("#goodsName").val();
    if (goodsCategoryCode == "") {
      goodsCategoryCode = null;
    }
    if (goodsType == "") {
      goodsType = null;
    }
    //获取库存列表
    $.ajax({
      type: "POST",
      async: true,
      url: baseRequestUrl + "/Api/GoodsStock/GetStoreGoodsStockTempApp",
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify({
        "wareHouseId": id,
        "storeId": storeId,
        "goodsName": queryGoodsName ? dbcbGoodsName : goodsName,
        "goodsType": $('.orderType .activeBtn').val(),
        "goodsCategoryCode": goodsCategoryCode,
        "goodsTempDay": goodsTempDay,
        "pageIndex": pageIndex,
        "pageSize": 10,
        brachStoreId: branchStoreId
      }),
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (search) {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
        }
        search = false;
        isChaxun = false;
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          branchStoreId ? $('#kcpd').hide() : $('#kcpd').show();
          var tpl = $("#kucunListTemp").html();
          var html = juicer(tpl, data);
          if (html.trim() != "") {
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              goodDatas = data.data;
              $("#kucunList").html(html);
            } else {
              for (var i = 0; i < data.data.length; i++) {
                goodDatas.push(data.data[i]);
              }
              $("#kucunList").append(html);
            }
            pageIndex++;
          }
          if (data.data == null || data.data.length == 0) {
            if (pageIndex == 1) {
              $("#kucunList").html("");
              $(".zwsj-box").show();
              $('#loading').remove();
            }
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }

  // 加载商品种类
  GetGoodCategory(function () {
    $("#goodCategoryWrapper").find("li>a").each(function () {
      var dataId = $(this).attr("data_categoryid");
      var dataId = $(this).attr("data_categoryid");
      //需要放出种子农药时替换
      if (dataId == "1" || dataId == "3" || dataId == "4" || dataId == "") {
        //if (dataId == "1" || dataId == "") {
        $(this).parent().show();
      } else {
        $(this).parent().hide();
      }
    });
  });
  // 扫码触发事件
  $(".icon-saoma").on("tap", function () {
    if (useLocal) {
      JiaoHu.scan();
    }
  });

  //下拉刷新
  function pullfreshF5() {
    goodsName = $("#goodsName").val();
    setTimeout(function () {
      pageIndex = 1;
      loadGoodsLst($('#hidCk').val());
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  // loadGoodsLst()
  /*上拉加载具体业务实现*/
  function pullupRefresh() {
    loadGoodsLst($('#hidCk').val());
  }
  //点击库存列表跳转
  $("#kucunList").on('tap', 'li .orderList', function () {
    var transformData = getSelectGoods($(this).parent().attr("data-id"));
    sessionStorage.setItem("tempGoodsDetailList", JSON.stringify(transformData));
    window.location.href = "tempGoodsDetailList.html";
  });
  //点击库存列表跳转
  $("#kucunList").on('tap', 'li .cx-btn', function () {
    var transformData = getSelectGoods($(this).attr("data-id"));
    sessionStorage.setItem("tempGoodsDetailList", JSON.stringify(transformData));
    window.location.href = "tempGoodsDetailList.html";
  });

  // 商品大类型选择
  $("#goodCategoryWrapper").on("tap", "a", function () {
    $("#lb-list label").text($(this).text());
    goodsType = $(this).attr("data_categoryId");
    goodsCategoryCode = "";
    pageIndex = 1;
    $(".page2").hide();
    $(".page").show();
    // loadGoodsLst($('#hidCk').val());
    loadGoodsLst($('#hidCk').val());
  });

  // 商品小类型选择
  $("#goodCategoryWrapper").on("tap", "p", function () {
    goodsCategoryCode = $(this).attr("data_goodsTypeId");
    goodsType = $(this).attr("data_type");
    pageIndex = 1;
    var text = $(this).text();
    $("#lb-list label").text(text);
    $(".page2").hide();
    $(".page").show();
    loadGoodsLst($('#hidCk').val());
  });

  //统一预警设置按钮
  $("#tyyj").on('tap', function () {
    var mask = mui.createMask();
    var btnArray = ['取消', '保存'];
    var html = '<div class="tcc">';
    html += '<p style="color:black"><label>预警天数：</label><input value="' + goodsTempDay + '" type="number" id="zxkc" placeholder="请输入需要提前预警的天数" /></p>';
    html += '</div>';
    mask.show();
    mui.confirm(html, '预警天数设置', btnArray, function (e) {
      if (e.index == 1) {
        if (!isTYYJ) {
          isTYYJ = true;
          var zxkc = $("#zxkc").val();
          var reg = /^([1-9]\d*|[0]{1,1})$/;
          var yz = reg.test(zxkc);
          var zxkc1 = zxkc[0];
          var yz2 = false;
          if (zxkc == "") {
            mask.show();
            mui.alert('请输入需要提前预警的天数', '', function () {
              mask.close();
            });
            return false;
          }
          //判断首位不能为0
          if (zxkc.length > 1) {
            if (zxkc1 != 0) {
              yz2 = true;
            }
          } else {
            yz2 = true;
          }
          if (yz == false || yz2 == false) {
            mask.show();
            mui.alert('请输入整数数量', '', function () {
              mask.close();
            });
            return false;
          }
          $.ajax({
            type: "POST",
            url: baseRequestUrl + "/Api/Store/SetGoosTempDay",
            contentType: 'application/json; charset=utf-8',
            headers: {
              "Authorization": 'Bearer ' + localStorage.getItem('token')
            },
            dataType: "json",
            beforeSend: function beforeSend() {
              loading();
              mask.show();
            },
            data: JSON.stringify({
              tempDay: zxkc * 1
            }),
            success: function (_success) {
              function success(_x) {
                return _success.apply(this, arguments);
              }
              success.toString = function () {
                return _success.toString();
              };
              return success;
            }(function (data) {
              localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
              setTimeout(function () {
                $('#loading').remove();
                isTYYJ = false;
              }, 50);
              if (data.code == 1) {
                mui.toast("设置成功");
                setTimeout(function () {
                  $(".mui-popup").remove();
                  mask.close();
                  window.location.reload();
                }, 1000);
                success();
              } else {
                mui.toast(data.msg);
              }
            }),
            error: function error() {
              setTimeout(function () {
                $('#loading').remove();
                isTYYJ = false;
              }, 50);
              mui.toast("数据提交失败，请稍后重试");
              $(".mui-popup").remove();
            }
          });
        }
      } else {
        mask.show();
        mask.close();
        $(".mui-popup").remove();
        return false;
      }
    });
  });

  // 二维码查询
  $("#icon-chaxun").on("click", function () {
    if (!isChaxun) {
      isChaxun = true;
      pageIndex = 1;
      search = true;
      loadGoodsLst($('#hidCk').val());
      mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }
  });
  // 选中的商品
  function getSelectGoods(id) {
    for (var i = 0; i < goodDatas.length; i++) {
      if (goodDatas[i].goodsId == id) {
        return goodDatas[i];
      }
    }
  }
  //点击选择仓库
  $("body").on('tap', '.search_box_cangku .ck_list', function () {
    city_picker2 = new mui.PopPicker({
      layer: 1
    });
    city_picker2.setData(ckPopPicker);
    setTimeout(function () {
      city_picker2.show(function (items) {
        $("#ck_text").html((items[0] || {}).text);
        $("#hidCk").val((items[0] || {}).value);
      });
    }, 200);
  });

  // 筛选栏选择商品类型
  $('.orderType button').on('tap', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
  });
  var flag = false;
  // 点击筛选按钮事件
  $('#lb-list').on('tap', function () {
    if (!flag) {
      $('.page2').animate({
        "top": '0'
      }, 300, function () {
        if (pop) {
          $('#pop').animate({
            "top": '23rem'
          }, 300, function () {
            pop = false;
          });
        }
        flag = true;
        mask.show();
      });
    } else {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  var pop = false;
  // 蒙版事件
  var mask = mui.createMask(function () {
    if (pop) {
      $('#pop').animate({
        "top": '23rem'
      }, 300, function () {
        pop = false;
      });
    } else if (flag) {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        flag = false;
      });
    }
  });
  // 点击筛选界面确定
  $('#requireBtn').on('tap', function () {
    if (!isChaxun) {
      isChaxun = true;
      $('.page2').animate({
        "top": '-6rem'
      }, 300, function () {
        flag = false;
      });
      pageIndex = 1;
      mask.close();
      loadGoodsLst($('#hidCk').val());
      mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }
  });
  // 点击筛选界面清空
  $('#cancelBtn').on('tap', function () {
    $("#goodsName").val('');
    $('.orderType button').eq(0).addClass('activeBtn').siblings().removeClass('activeBtn');
    // $('.search_box_cangku button').eq(0).addClass('activeBtn').siblings().removeClass('activeBtn');
    $('.search_box_cangku #ck_text').html('全部');
    $('#hidCk').val('');
    $('#branches').text('');
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageIndex = 1;
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    loadGoodsLst($('#hidCk').val());
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    // mui('#pullrefresh').pullRefresh().refresh(true);
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});
//二维码扫码回调
window.getcode = function (s, _s1) {
  var s1 = _s1;
  s1 = s1.match(/https?:\/\//i) && s1.match(/^(.+)(https?:\/\/.+)$/i) ? RegExp.$2 : s1;
  console.log("getcode==", s, s1);
  $("#goodsName").val(s1);
  $("#icon-chaxun").click();
};