/*
 * @Descripttion: 商品临期提醒详情列表
 * @Date: 2021-07-29 17:47:16
 * @LastEditors: hsl
 * @LastEditTime: 2021-07-30 11:29:38
 */
$(function () {
  var tempGoodsDetailList = JSON.parse(sessionStorage.getItem('tempGoodsDetailList'));
  var pageIndex = 1; //count 表示页数
  loadGoodsLst();
  // 加载查询商品列表
  function loadGoodsLst() {
    var goodsArr = {
      data: tempGoodsDetailList.tempDayGoodsList.slice((pageIndex - 1) * 10, pageIndex * 10)
    };
    goodsArr.data.forEach(function (i) {
      i.packageUnit = tempGoodsDetailList.packageUnit;
      var endDateArr = i.expirationEndDate.split(' ')[0].split('-');
      var nowDate = '' + new Date().getFullYear() + (new Date().getMonth() + 1 < 10 ? '0' + (new Date().getMonth() + 1) : new Date().getMonth() + 1) + (new Date().getDate() < 10 ? '0' + new Date().getDate() : new Date().getDate());
      if (endDateArr.join('') * 1 > nowDate * 1) i.expired = false;else i.expired = true;
    });
    var tpl = $("#kucunListTemp").html();
    var html = juicer(tpl, goodsArr);
    if (html.trim() != "") {
      if (pageIndex == 1) {
        $(".zwsj-box").hide();
        $("#pullrefresh").show();
        $("#kucunList").html(html);
      } else {
        $("#kucunList").append(html);
      }
      pageIndex++;
    }
  }
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: false
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      loadGoodsLst();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  function pullupRefresh() {
    setTimeout(function () {
      loadGoodsLst();
      mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= tempGoodsDetailList.tempDayGoodsList.length); //参数为true代表没有更多数据了。
    }, 1500);
  }
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    sessionStorage.removeItem('tempGoodsDetailList');
    window.history.go(-1);
  });
});