$(function () {
  var testData = JSON.parse(sessionStorage.getItem("wareHouseInfo"));
  var goodsId = getUrlParam('id');
  //获取仓库
  var cangkuListTemp = $('#cangkuListTemp').html();
  getWarHouse();
  function getWarHouse() {
    var requestData = {
      "goodsId": goodsId
      // "wareHouseId": warHouseInfo.warHouseId,
    };

    $.ajax({
      type: "POST",
      contentType: 'application/json; charset=utf-8',
      url: baseRequestUrl + "/Api/GoodsStock/GetGoodsStockByWareHouse",
      data: JSON.stringify(requestData),
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var tpl = cangkuListTemp;
          var html = juicer(tpl, data);
          $('#allList').html(html);
          if (data.data || data.data.length != 0) {
            $('#allGoods').text(data.data.length);
          }
          if (!data.data || data.data.length < 1) {
            $('.zwsj-box').show();
          } else {
            $('.zwsj-box').hide();
          }
          chooseCK();
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //进入时选中之前选中的仓库
  function chooseCK() {
    if (testData) {
      for (var i = 0; i < $('#allList li').length; i++) {
        var id = $('#allList li').eq(i).attr('data_id');
        if (testData.warHouseId == id) {
          $('#allList li').eq(i).find('input[name="checkbox1"]').attr('checked', 'checked');
        }
      }
    }
  }

  //选择仓库返回打包拆包页面
  $('#allList').on('tap', 'li', function () {
    var data_id = $(this).attr("data_id");
    var data_name = $(this).attr("data_name");
    var data = {
      warHouseId: data_id,
      warHouseName: data_name
    };
    sessionStorage.setItem("wareHouseInfo", JSON.stringify(data));
    window.history.go(-1);
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});