$(function () {
  //获取商品
  var testData = JSON.parse(sessionStorage.getItem("wareHouseInfo")); //仓库信息
  var selectData = JSON.parse(localStorage.getItem("hpkcSelectData")); //商品信息
  var goodsChangeType = sessionStorage.getItem("goodsChangeType"); //打包或是拆包
  var testGoodsData = JSON.parse(sessionStorage.getItem("goodsInfo")); //转到商品信息
  var goodsListTemp = $('#goodsListTemp').html(); //模板
  //获取商品
  getGoods();
  function getGoods() {
    //选中的仓库的id
    var requestData = {
      "baseGoodsId": selectData.baseGoodsId,
      "goodsId": selectData.goodsId,
      "wareHouseId": testData.warHouseId,
      "packageLevel": selectData.packageLevel,
      "goodsChangeType": goodsChangeType
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/StoreBatch/GetConvertGoods",
      data: JSON.stringify(requestData),
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        if (data.code == 1) {
          $('#loading').remove();
          var tpl = goodsListTemp;
          var html = juicer(tpl, data);
          $('#allList').html(html);
          if (data.data || data.data.length != 0) {
            $('#allGoods').text(data.data.length);
          }
          if (!data.data || data.data.length < 1) {
            $('.zwsj-box').show();
          } else {
            $('.zwsj-box').hide();
          }
          chooseSP();
        } else {
          $('#loading').remove();
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //进入时选中之前选中的商品
  function chooseSP() {
    if (testGoodsData) for (var i = 0; i < $('#allList li').length; i++) {
      var id = $('#allList li').eq(i).attr('data_goodsid');
      if (testGoodsData.goodsId == id) {
        $('#allList li').eq(i).find('input[name="checkbox1"]').attr('checked', 'checked');
      }
    }
  }
  //选择商品返回打包拆包页面
  $('#allList').on('tap', 'li', function () {
    var data_goodsid = $(this).attr("data_goodsid");
    var data_name = $(this).attr("data_name");
    var data_specPackage = $(this).attr("data_specPackage");
    var data_specifications = $(this).attr("data_specifications");
    var data_count = $(this).attr("data_count");
    var data_unit = $(this).attr("data_baseUnit");
    var data = {
      goodsId: data_goodsid,
      goodsName: data_name,
      specPackage: data_specPackage,
      baseGoodsCount: data_count,
      baseUnit: data_unit,
      specifications: data_specifications
    };
    if (!$(this).find('input[name="checkbox1"]').prop('checked') == true)
      //判断是否勾选
      sessionStorage.setItem("goodsInfo", JSON.stringify(data));else sessionStorage.removeItem("goodsInfo");
    window.history.go(-1);
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});