$(function () {
  //下拉加载
  var count = 1; //count 表示页数
  var dataList = null;
  var isChaxun = false; //防止连续点击两次而请求两次接口
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: false
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  reload();
  getgoodsTypeList();
  // 上下拉刷新加载公共代码
  function reload() {
    var requetData = {
      containerTypeName: $('#goodsName').val(),
      goodsType: parseFloat($('.orderType .activeBtn').val()),
      minSepc: parseFloat($('.btn .minSpec').val()),
      maxSepc: parseFloat($('.btn1 .maxSpec').val()),
      pageIndex: count,
      pageSize: 10
    };
    //销售单据列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWStock/GetStockPageList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requetData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        isChaxun = false;
        if (data.code == 1) {
          dataList = data;
          $("#pullrefresh").show();
          $(".zwsj-box").hide();
          mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
          pullPublic();
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        isChaxun = false;
        mui.toast("数据请求失败，请稍后重试");
      }
    });
  }
  function pullPublic() {
    var xiaohuodanjuListTemp = $("#kucunListTemp"); //获取前端需要加载的模板
    var table = document.body.querySelector('.mui-table-view');
    if (dataList != null) {
      if (dataList.data.length > 0) {
        var tpl = xiaohuodanjuListTemp.html();
        var html = juicer(tpl, dataList);
        if (count == 1) {
          $(table).html(html);
        } else {
          $(table).append(html);
        }
      } else {
        $(table).html("");
        $(".zwsj-box").show();
        $('#loading').remove();
        if (count != 1) {
          mui.toast("未查询到更多数据");
        }
      }
    }
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      count = 1;
      reload();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      count++;
      reload();
    }, 1500);
  }
  // 筛选栏选择商品类型
  $('body').on('tap', '.orderType button', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
  });
  var flag = false;
  // 点击筛选按钮事件
  $('#lb-list').on('tap', function () {
    if (!flag) {
      $('.page2').animate({
        "top": '-1.4rem'
      }, 300, function () {
        if (pop) {
          $('#pop').animate({
            "top": '23rem'
          }, 300, function () {
            pop = false;
          });
        }
        flag = true;
        mask.show();
      });
    } else {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  var pop = false;
  // 蒙版事件
  var mask = mui.createMask(function () {
    if (pop) {
      $('#pop').animate({
        "top": '23rem'
      }, 300, function () {
        pop = false;
      });
    } else if (flag) {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        flag = false;
      });
    }
  });
  // 点击筛选界面确定
  $('#requireBtn').on('tap', function () {
    if (isChaxun) {
      return;
    }
    isChaxun = true;
    pageIndex = 1;
    // loadGoodsLst($('#hidCk').val());
    reload();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-6rem'
    }, 300, function () {
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancelBtn').on('tap', function () {
    $("#goodsName").val('');
    $('.orderType button').eq(0).addClass('activeBtn').siblings().removeClass('activeBtn');
    $('.btn .minSpec').val('');
    $('.btn1 .maxSpec').val('');
    $('#hidCk').val('');
  });

  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    if (isChaxun) {
      return;
    }
    isChaxun = true;
    count = 1;
    mystoreMemberName = $("#goodsName").val(); //供应商
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    reload();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });

  //库存  详情
  $('#kucunList').on('tap', '#kupList', function () {
    var id = $(this).attr("data-id"); //id
    location.href = "kucun_hsd_list.html?id=" + id;
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = 'index.html';
  });
});