$(function () {
  var mask = mui.createMask();
  var pickerSpec = new mui.PopPicker({
    layer: 1,
    buttons: ['取消', '确定']
  });
  var pickerUnit = new mui.PopPicker({
    layer: 1,
    buttons: ['取消', '确定']
  });
  var passTest = true; //校验
  init();
  //初始化
  function init() {
    $('.warn').hide();
    $('#notingLazyStr').text(window.notingLazyStr);
    loading();
    mask.show();
    pickerSpec.setData([{
      value: "克",
      text: "克"
    }, {
      value: "千克",
      text: "千克"
    }, {
      value: "毫升",
      text: "毫升"
    }, {
      value: "升",
      text: "升"
    }]);
    pickerSpec.pickers[0].setSelectedIndex(0);
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/GetPurchaseConfig",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      //返回数据形式为json
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        $('#loading').remove();
        mask.close();
        if (data.code === 1 && data.data) {
          if (!$('#state').hasClass("mui-active") === data.data.state) mui('#state').switch().toggle();
          if (!$('#isLazybones').hasClass("mui-active") === data.data.isLazybones) mui('#isLazybones').switch().toggle();
          if (!$('#state').hasClass("mui-active")) $('#content-box').hide();
          if (!$('#isLazybones').hasClass("mui-active")) $('#middle-box').hide();
          $('#specMetering').val(data.data.specMetering || 10);
          $('#specUnit').text(data.data.specUnit || '克');
          $('#packageUnit').text(data.data.packageUnit || '个');
          $('#costPrice').val(data.data.costPrice || 0.01);
          $('#retailPrice').val(data.data.retailPrice || 0.01);
          $('#memberPrice').val(data.data.memberPrice || 0.01);
          $('#tradePrice').val(data.data.tradePrice || 0.01);
        }
      },
      error: function error(err) {
        mui.toast(data.msg);
      }
    });
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Goods/MinPackUnit",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      //返回数据形式为json
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        $('#loading').remove();
        mask.close();
        if (data.code === 1 && data.data) {
          pickerUnit.setData(data.data.map(function (item) {
            return {
              value: item.value,
              text: item.label
            };
          }));
          pickerUnit.pickers[0].setSelectedIndex(20);
        }
      },
      error: function error(err) {
        mui.toast(data.msg);
      }
    });
  }
  $('#state').on('tap', function () {
    if (!$(this).hasClass("mui-active")) $('#content-box').hide();else $('#content-box').show();
  });
  $('#isLazybones').on('tap', function () {
    if (!$(this).hasClass("mui-active")) $('#middle-box').hide();else $('#middle-box').show();
  });
  $('.goBack-btn').on('tap', function () {
    window.history.back();
  });
  //规格校验
  $('#specMetering').keyup(function (e) {
    if (!e.currentTarget.value) {
      $('.warn-specMetering').text('请输入规格');
      $('.warn-specMetering').show();
      passTest = false;
      return;
    } else if (e.currentTarget.value < 0) {
      $('.warn-specMetering').text('规格不能小于0');
      $('.warn-specMetering').show();
      passTest = false;
      return;
    } else if (e.currentTarget.value > 100) {
      $('.warn-specMetering').text('规格不能大于100');
      $('.warn-specMetering').show();
      passTest = false;
      return;
    } else {
      $('.warn-specMetering').hide();
      passTest = true;
    }
  });
  //价格校验
  function checkPrice(selector, value, desc) {
    if (!value) {
      $(selector).text('请输入' + desc);
      $(selector).show();
      passTest = false;
      return;
    } else if (value <= 0) {
      $(selector).text(desc + '不能小于等于0');
      $(selector).show();
      passTest = false;
      return;
    } else {
      $(selector).hide();
      passTest = true;
    }
  }
  // $('#specUnit').on('tap',function(){
  //     pickerSpec.show(function(getSelectedItems){
  //         $('#specUnit').text(getSelectedItems[0].value)
  //     })
  // })
  // $('#packageUnit').on('tap',function(){
  //     pickerUnit.show(function(getSelectedItems){
  //         $('#packageUnit').text(getSelectedItems[0].value)
  //     })
  // })
  $('#costPrice').keyup(function (e) {
    checkPrice('.warn-costPrice', e.currentTarget.value, '进货价');
  });
  $('#retailPrice').keyup(function (e) {
    checkPrice('.warn-retailPrice', e.currentTarget.value, '零售价');
  });
  $('#memberPrice').keyup(function (e) {
    checkPrice('.warn-memberPrice', e.currentTarget.value, '会员价');
  });
  $('#tradePrice').keyup(function (e) {
    checkPrice('.warn-tradePrice', e.currentTarget.value, '批发价');
  });
  //点击保存
  $('#submitBtn').on('tap', function () {
    $('input').each(function () {
      if (!$(this).val()) {
        passTest = false;
        $('.warn-' + $(this).attr('id')).text('此项为必填项');
        $('.warn-' + $(this).attr('id')).show();
      }
    });
    if (!passTest) {
      mui.toast('输入项格式错误，请检查');
      return;
    }
    var data = {
      specMetering: $('#specMetering').val() * 1,
      specUnit: $('#specUnit').text(),
      packageUnit: $('#packageUnit').text(),
      costPrice: $('#costPrice').val() * 1,
      retailPrice: $('#retailPrice').val() * 1,
      memberPrice: $('#memberPrice').val() * 1,
      tradePrice: $('#tradePrice').val() * 1,
      state: $('#state').hasClass("mui-active"),
      isLazybones: $('#isLazybones').hasClass("mui-active")
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/AddPurchaseConfig",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        mask.show();
        loading();
      },
      data: JSON.stringify(data),
      dataType: "json",
      //返回数据形式为json
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
          mask.close();
        }, 100);
        if (data.code === 1 && data.data) {
          mui.confirm('已完成设置，是否跳转进货？', '提示', ['否', '是'], function (e) {
            if (e.index) window.location.href = "jinhuo_wyjh_xzhp.html";
          });
        }
      },
      error: function error(err) {
        mui.toast(data.msg);
      }
    });
  });
});