/*
 * @Author: hsl
 * @Descripttion: 经营分析-统计图
 * @Date: 2022-02-14 15:00:48
 * @LastEditTime: 2022-03-24 14:25:03
 */

$(function () {
  var branchStoreId = getUrlParam('branchStoreId');
  //连锁店
  var branchesPicker = [{
    text: '无',
    value: ''
  }];
  var branch_picker = null;
  initBranch();
  setTimeout(function () {
    pullPublic();
  }, 0);
  //选择分店
  $("#btn_branches").on("tap", function () {
    branch_picker = new mui.PopPicker({
      layer: 1
    });
    branch_picker.setData(branchesPicker);
    setTimeout(function () {
      branch_picker.show(function (items) {
        $("#branches").text((items[0] || {}).text);
        branchStoreId = (items[0] || {}).value;
      });
    }, 200);
  });
  function initBranch() {
    if (localStorage.getItem('hasChain')) {
      $('.filter-btn').show();
      $.ajax({
        type: 'post',
        url: baseRequestUrl + '/Api/BranchStore/GetBranchStoreSelect',
        //请求数据的地址
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        //返回数据形式为json
        success: function success(res) {
          if (res.code == 1 && res.data) {
            branchesPicker = branchesPicker.length > 1 ? branchesPicker : branchesPicker.concat(res.data.map(function (item) {
              return {
                text: item.branchStoreName,
                value: item.branchStoreId
              };
            }));
            if (sessionStorage.getItem('branchStoreId')) {
              branchStoreId = sessionStorage.getItem('branchStoreId');
              $("#branches").text(branchesPicker.find(function (ii) {
                return ii.value === sessionStorage.getItem('branchStoreId');
              }).text);
            }
          }
        },
        error: function error(err) {
          mui.toast(err);
        }
      });
    }
  }
  // 上下拉刷新加载公共代码
  function pullPublic() {
    var storeId = branchStoreId || localStorage.getItem('storeId');
    //销售单据列表
    $.ajax({
      type: "GET",
      url: "".concat(pythonRequestUrl, "/analysis?storeid=").concat(storeId, "&startdate=").concat($(".start-time").text(), "&enddate=").concat($(".end-time").text(), "&count=", 9999, "&version=").concat(localStorage.getItem('yoonopVersion')),
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        data = JSON.parse(data);
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#require-btn').removeClass('huise');
          if (data.data.label_data) {
            $('.total-sales').text(data.data.total.total_sales);
            $('.total-cost').text(data.data.total.total_cost);
            $('.total-profit').text(data.data.total.total_profit);
            $('.total-money').text(data.data.total.total_pay);
            $("#pullrefresh").show();
            $(".zwsj-box").hide();
            getBar1Option(data.data.profit_data);
            getPie1Option(data.data.label_total);
          } else {
            $(".zwsj-box").show();
            $("#pullrefresh").hide();
          }
        } else mui.toast(data.msg);
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }

  //获取柱状图配置
  function getBar1Option(data) {
    var myChart = echarts.init(document.getElementById('barChart1'));
    var option = {
      color: ['#24b940'],
      title: {
        text: '商品总利润TOP10',
        left: 'center',
        top: 'top'
      },
      tooltip: {
        trigger: 'axis',
        axisPointer: {
          type: 'line',
          label: {
            backgroundColor: '#6a7985'
          }
        },
        formatter: data ? "{b}: {c} \u5143" : '0 元'
      },
      grid: {
        left: '33%',
        top: 50,
        bottom: 20,
        right: '8%'
      },
      xAxis: [{
        type: 'value',
        name: "\u5143"
      }],
      yAxis: [{
        type: 'category',
        data: data ? data.slice(0, 10).map(function (i) {
          return i.register_name ? "".concat(i.goods_name, "\uFF08").concat(i.register_name, "\uFF09") : i.goods_name;
        }).reverse() : ['商品'],
        name: '商品',
        nameGap: 2,
        axisTick: {
          alignWithLabel: true
        },
        axisLabel: {
          formatter: function formatter(value) {
            return value.length > 8 ? value.slice(0, 8) + '\n' + value.slice(8) : value;
          },
          fontSize: 13
        }
      }],
      series: [{
        type: 'bar',
        data: data ? data.slice(0, 10).map(function (i) {
          return {
            name: i.goods_name,
            value: i.profit
          };
        }).reverse() : [{
          name: '商品',
          value: 0
        }],
        showBackground: true,
        label: {
          normal: {
            position: 'right',
            show: true,
            formatter: function formatter(params) {
              return "".concat(params.value, " \u5143");
            }
          }
        },
        barWidth: '50%'
      }]
    };
    myChart.setOption(option);
  }
  //获取饼图配置
  function getPie1Option(data) {
    var myChart = echarts.init(document.getElementById('pieChart1'));
    var option = {
      title: {
        text: '商品类型占比',
        left: 'center',
        top: 'top'
      },
      tooltip: {
        trigger: 'item',
        formatter: function formatter(params) {
          return params.name ? "<div><p>".concat(params.percent, "%(").concat(params.value, "\u79CD)</p>").concat(params.name.split(',').map(function (i) {
            return "<p>-&nbsp;".concat(i, "</p>");
          }).join(''), "</div>") : '100%';
        }
      },
      series: [{
        type: 'pie',
        radius: ['10%', '70%'],
        center: ['50%', '50%'],
        data: data ? data.map(function (i) {
          return {
            name: i.label,
            value: i.total
          };
        }) : [{
          name: '',
          value: 0
        }],
        label: {
          formatter: function formatter(params) {
            return params.name ? "".concat(params.percent, "%\n").concat(params.name.split(',').join('\n')) : '100%';
          },
          fontSize: 13
        },
        itemStyle: {
          emphasis: {
            shadowBlur: 10,
            shadowOffsetX: 0,
            shadowColor: 'rgba(0, 0, 0, 0.5)'
          },
          borderRadius: [2, 10],
          shadowBlur: 2,
          shadowOffsetX: 0,
          shadowColor: 'rgba(0, 0, 0, 0.5)'
        }
      }]
    };
    myChart.setOption(option);
  }

  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').show();
      $('.page2').animate({
        "top": '3.6rem'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-8rem'
      }, 300, function () {
        $('.page2').hide();
        mask.close();
        flag = false;
        $('.page2').css('display', 'none');
      });
    }
  });
  // 筛选栏插入日期选择
  var stime = null;
  var etime = null;
  function timers() {
    stime = new Date().Format("yyyy-MM-01");
    etime = new Date().Format("yyyy-MM-dd");
    var html = '<div class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></div>&nbsp;—';
    html += '&nbsp;<div class="btn endTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></div>';
    $('.timeList').html(html);
  }
  timers();
  // 筛选栏日期选择
  var id = 'this.getAttribute()';
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  var btns = $('.btn');
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        pullPublic();
        picker.dispose();
      });
    }, false);
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#require-btn,#icon-chaxun').on('tap', function () {
    if ($('#require-btn').hasClass('huise')) {
      return false;
    }
    pullPublic();
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancel-btn').on('tap', function () {
    $(".start-time").text(new Date().Format("yyyy-MM-01"));
    $(".end-time").text(new Date().Format("yyyy-MM-dd"));
    $('#branches').text('无');
    branchStoreId = '';
  });

  // 点击下方导航栏跳转
  $(".bottom-nav").on("tap", "a", function () {
    window.location.href = $(this).attr("targetHref");
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.back();
    sessionStorage.removeItem('branchStoreId');
  });
});