/*
 * @Author: hsl
 * @Descripttion: 经营分析-统计列表
 * @Date: 2022-02-14 11:08:07
 * @LastEditTime: 2022-03-24 14:25:16
 */
$(function () {
  var branchStoreId = getUrlParam('branchStoreId');
  //连锁店
  var branchesPicker = [{
    text: '无',
    value: ''
  }];
  var branch_picker = null;
  initBranch();
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //选择分店
  $("#btn_branches").on("tap", function () {
    branch_picker = new mui.PopPicker({
      layer: 1
    });
    branch_picker.setData(branchesPicker);
    setTimeout(function () {
      branch_picker.show(function (items) {
        $("#branches").text((items[0] || {}).text);
        branchStoreId = (items[0] || {}).value;
      });
    }, 200);
  });
  function initBranch() {
    if (localStorage.getItem('hasChain')) {
      $.ajax({
        type: 'post',
        url: baseRequestUrl + '/Api/BranchStore/GetBranchStoreSelect',
        //请求数据的地址
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        //返回数据形式为json
        success: function success(res) {
          if (res.code == 1 && res.data) {
            branchesPicker = branchesPicker.length > 1 ? branchesPicker : branchesPicker.concat(res.data.map(function (item) {
              return {
                text: item.branchStoreName,
                value: item.branchStoreId
              };
            }));
            if (sessionStorage.getItem('branchStoreId')) {
              branchStoreId = sessionStorage.getItem('branchStoreId');
              $("#branches").text(branchesPicker.find(function (ii) {
                return ii.value === sessionStorage.getItem('branchStoreId');
              }).text);
            }
          }
        },
        error: function error(err) {
          mui.toast(err);
        }
      });
    } else $('#wrapper_branches').hide();
  }
  // 上下拉刷新加载公共代码
  function pullPublic() {
    var table = document.body.querySelector('.mui-table-view');
    var storeId = branchStoreId || localStorage.getItem('storeId');
    //销售单据列表
    $.ajax({
      type: "GET",
      url: "".concat(pythonRequestUrl, "/analysis?storeid=").concat(storeId, "&startdate=").concat($(".start-time").text(), "&enddate=").concat($(".end-time").text(), "&count=", 9999, "&version=").concat(localStorage.getItem('yoonopVersion')),
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        data = JSON.parse(data);
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(true); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#require-btn').removeClass('huise');
          $("#pullrefresh").show();
          $(".zwsj-box").hide();
          if (data.data.label_data) {
            $('.total-sales').text(data.data.total.total_sales);
            $('.total-cost').text(data.data.total.total_cost);
            $('.total-profit').text(data.data.total.total_profit);
            $('.total-money').text(data.data.total.total_pay);
            var tpl = $("#xiaohuodanjuListTemp").html();
            data.data.label_data = data.data.label_data.filter(function (item) {
              return item.goods_name.includes($('#orderSearchText').val());
            });
            var html = juicer(tpl, data.data);
            $(table).html(html);
          } else {
            $(table).html("");
            $(".zwsj-box").show();
            $('#loading').remove();
          }
        } else mui.toast(data.msg);
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 0);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 0);
  }
  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').show();
      $('.page2').animate({
        "top": '3.6rem'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-8rem'
      }, 300, function () {
        $('.page2').hide();
        mask.close();
        flag = false;
        $('.page2').css('display', 'none');
      });
    }
  });
  // 筛选栏插入日期选择
  var stime = null;
  var etime = null;
  function timers() {
    stime = new Date().Format("yyyy-MM-01");
    etime = new Date().Format("yyyy-MM-dd");
    var html = '<label>选择时间</label><div class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></div>&nbsp;—';
    html += '&nbsp;<div class="btn endTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></div>';
    $('.timeList').html(html);
  }
  timers();
  // 筛选栏日期选择
  var id = 'this.getAttribute()';
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  var btns = $('.btn');
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#require-btn').on('tap', function () {
    if ($('#require-btn').hasClass('huise')) {
      return false;
    }
    pullPublic();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancel-btn').on('tap', function () {
    $(".start-time").text(new Date().Format("yyyy-MM-01"));
    $(".end-time").text(new Date().Format("yyyy-MM-dd"));
    $('#branches').text('无');
    branchStoreId = '';
    $('#orderSearchText').text('');
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    pullPublic();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  // 点击下方导航栏跳转
  $(".bottom-nav").on("tap", "a", function () {
    window.location.href = $(this).attr("targetHref");
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = 'index.html';
    sessionStorage.removeItem('branchStoreId');
  });
});