function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  computed = _Vue.computed;
var _ElementPlus = ElementPlus,
  ElTag = _ElementPlus.ElTag,
  ElIcon = _ElementPlus.ElIcon;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Female = _ElementPlusIconsVue.Female,
  Male = _ElementPlusIconsVue.Male,
  Edit = _ElementPlusIconsVue.Edit,
  ArrowLeftBold = _ElementPlusIconsVue.ArrowLeftBold;
var isMainStore = !!localStorage.getItem('hasChain');
createApp({
  components: {
    ElTag: ElTag,
    ElIcon: ElIcon,
    Female: Female,
    Male: Male,
    Edit: Edit,
    ArrowLeftBold: ArrowLeftBold
  },
  setup: function setup() {
    var data = reactive({
      visible: false,
      loading: false,
      curRecord: {},
      //当前选中会员
      departmentTag: '',
      //会员类型
      detail: {},
      //会员详情
      statistics: {},
      //统计信息
      storePermissions: {},
      //店铺权限
      cropList: [] //作物信息
    });

    data.departmentTag = computed(function () {
      var detail = data.detail;
      var tag = '普通农户';
      switch (detail.departmentTag) {
        case 1:
          tag = '拾荒者';
          break;
        case 2:
          tag = '环卫工人';
          break;
        case 3:
          tag = '环保公司';
          break;
        case 4:
          tag = '第三方公司';
          break;
        case 5:
          tag = '其他';
          break;
        default:
          break;
      }
      return tag;
    });
    onMounted(function () {
      //获取店对会员的控制权限
      !isMainStore && getPermissions();

      //获取本地存储的记录
      var temp = sessionStorage.getItem('currentMember');
      if (temp) {
        data.curRecord = JSON.parse(temp);
        getMemberDetail();
        getStatistics();
        getCropByMemberId();
      }
    });

    //获取用户详情
    var getMemberDetail = function getMemberDetail() {
      data.loading = true;
      $http({
        url: "/Api/Member/GetMemberById?memberId=".concat(data.curRecord.id)
      }).then(function (res) {
        if (res.code == 1) {
          data.detail = res.data;
          data.loading = false;
        } else {
          vant.Toast(res.msg);
        }
      }).catch(function (e) {
        data.loading = false;
      });
    };

    //获取统计信息
    var getStatistics = function getStatistics() {
      $http({
        url: "/Api/Member/GetMemberOrderStatistics?memberId=".concat(data.curRecord.id)
      }).then(function (res) {
        if (res.code == 1) {
          data.statistics = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //开关
    var openUser = function openUser() {
      data.visible = !data.visible;
    };

    //返回按钮
    var goBack = function goBack() {
      window.history.go(-1);
    };

    //跳转页面
    var toPage = function toPage(type) {
      var detail = data.detail,
        curRecord = data.curRecord,
        statistics = data.statistics;
      var path = '';
      switch (type) {
        case 'record':
          path = "xiaoshou_xiaoshoudanjue.html?name=".concat(detail.memberName, "&branchStoreId=").concat(curRecord.branchStoreId, "&pageType=member&storeMemberId=").concat(detail.id);
          break;
        case 'return':
          path = "xiaoshou_tuihuodanju.html?name=".concat(detail.memberName, "&branchStoreId=").concat(curRecord.branchStoreId, "&pageType=member&storeMemberId=").concat(detail.id);
          break;
        case 'integral':
          path = "pointsRecord.html?memberId=".concat(curRecord.id || detail.id);
          break;
        default:
          break;
      }
      location.href = path;
    };

    //编辑会员
    var editMember = function editMember() {
      if (!isMainStore && !data.storePermissions.isSetModify) {
        return mui.toast('暂无编辑连锁店会员资料权限，请联系总店开通！');
      }
      location.href = "ziliao_huiyuanguanli_edt.html?id=" + data.detail.id;
    };

    //获取店对会员的控制权限
    var getPermissions = function getPermissions() {
      $http({
        url: '/Api/Member/GetAll',
        data: {
          branchStoreId: localStorage.getItem('storeId')
        }
      }).then(function (res) {
        if (res.code == 1) {
          data.storePermissions = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    // 根据会员ID获取作物信息
    var getCropByMemberId = function getCropByMemberId() {
      $http({
        url: "/Api/Member/GetMemberCropInfoById?memberId=".concat(data.curRecord.id)
      }).then(function (res) {
        if (res.code == 1) {
          data.cropList = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      openUser: openUser,
      goBack: goBack,
      toPage: toPage,
      editMember: editMember
    });
  }
}).mount('#app');