function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  computed = _Vue.computed;
var _ElementPlus = ElementPlus,
  ElTag = _ElementPlus.ElTag,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  ArrowDown = _ElementPlusIconsVue.ArrowDown,
  RemoveFilled = _ElementPlusIconsVue.RemoveFilled,
  CirclePlusFilled = _ElementPlusIconsVue.CirclePlusFilled;
var configHidden = menuNotShow; //配置项中不显示的菜单

//调试使用
if (window.vDebug) {
  new VConsole();
}
createApp({
  components: {
    ElTag: ElTag,
    ElIcon: ElIcon,
    ArrowDown: ArrowDown,
    RemoveFilled: RemoveFilled,
    CirclePlusFilled: CirclePlusFilled,
    ElEmpty: ElEmpty
  },
  setup: function setup() {
    var data = reactive({
      showTop: true,
      //展开首页菜单开关
      showManager: true,
      //编辑开关
      menu: [],
      //全部菜单
      check: [],
      //选中的菜单
      uncheck: [],
      //未选中的菜单
      allMenu: [] //全部的菜单
    });

    onMounted(function () {
      getLocalMenu();
    });

    //获取本地存储的菜单
    var getLocalMenu = function getLocalMenu() {
      var temp = localStorage.getItem("menuList".concat(localStorage.getItem('userId')));
      var all = localStorage.getItem('menuAllList');
      if (temp) {
        var list = JSON.parse(temp);
        data.menu = list;
        data.check = list.filter(function (ele) {
          return ele.isShow;
        }).map(function (m) {
          var obj = JSON.parse(JSON.stringify(m));
          obj['id'] = m.dataId;
          // ({id:m.dataId,...m})
          return obj;
        });

        //如果是手机端取手机数据库中的数据
        if (useLocal) {
          data.check = JSON.parse(JiaoHu.GetAllMenu()).map(function (ele) {
            var obj = JSON.parse(JSON.stringify(ele));
            obj['id'] = ele.dataId;
            obj['isShow'] = ele.isShow == 1 ? true : false;
            return obj;
            // return {
            //     id:ele.dataId,
            //     ...ele,
            //     isShow:ele.isShow==1?true:false,
            // }
          });
        }

        if (all) {
          var allMenu = JSON.parse(all);
          var other = [];

          //处理显示和隐藏的菜单
          allMenu.forEach(function (ele) {
            //排除配置项中不展示的菜单
            configHidden.forEach(function (c) {
              if (ele.id == c) {
                ele.hasConfig = true;
              }
            });

            //排除已经选中的菜单
            ele.children && ele.children.forEach(function (i) {
              data.check.forEach(function (c) {
                if (c.dataId == i.id) {
                  i.hasCheck = true;
                }
              });
            });

            //将没有子级菜单的菜单分到其他中
            if (!ele.children) {
              other.push(ele);
            }
          });
          allMenu.push({
            name: '其他',
            children: other,
            id: 'other'
          });
          data.allMenu = allMenu;
        }
      }
    };

    //更新选中和未选中的状态
    var updateCheck = function updateCheck() {
      var allMenu = data.allMenu,
        check = data.check;
      var list = _toConsumableArray(allMenu);
      var checkList = _toConsumableArray(check);
      for (var i = 0; i < list.length; i++) {
        if (list[i].children) {
          for (var j = 0; j < list[i].children.length; j++) {
            if (checkList.length == 0) {
              list[i].children[j].hasCheck = false;
            }
            for (var k = 0; k < checkList.length; k++) {
              list[i].children[j].hasCheck = false;
              if (checkList[k].id == list[i].children[j].id) {
                list[i].children[j].hasCheck = true;
                break;
              }
            }
          }
        }
      }
      data.allMenu = list;
    };

    //打开首页菜单
    var openTopMenu = function openTopMenu() {
      data.showTop = !data.showTop;
    };

    //打开管理
    var openManager = function openManager() {
      data.showManager = !data.showManager;

      //保存
      if (!data.showManager) {
        saveMenu();
      }
    };

    //保存菜单
    var saveMenu = function saveMenu() {
      var list = data.check.map(function (ele) {
        if (ele.approute) {
          var _obj = {
            dataId: ele.id,
            isShow: true,
            parentId: ele.bpid,
            targetUrl: ele.approute
          };
          return Object.assign({}, _obj, ele);
          // return {
          //     dataId:ele.id,
          //     isShow:true,
          //     parentId:ele.bpid,
          //     targetUrl:ele.approute,
          //     ...ele
          // }
        }

        return ele;
      });

      //真机保存到手机数据库，浏览器保存到storage
      if (useLocal) {
        var check = data.check;

        //初始数据
        var initList = JSON.parse(JiaoHu.GetAllMenu()).map(function (ele) {
          var obj = {
            id: ele.dataId,
            isShow: ele.isShow == 1 ? true : false
          };
          return Object.assign({}, obj, ele);
          // return {
          //     id:ele.dataId,
          //     ...ele,
          //     isShow:ele.isShow==1?true:false,
          // }
        });

        //新增的数据
        var addList = [];
        //删除的数据
        var deleteList = [];
        var overlap = [];
        //找出数组中的交集
        check.forEach(function (ele) {
          if (!initList.find(function (f) {
            return f.id == ele.id;
          })) {
            addList.push(ele);
          } else {
            overlap.push(ele);
          }
        });
        initList.forEach(function (ele) {
          if (!check.find(function (f) {
            return f.id == ele.id;
          })) {
            deleteList.push(ele);
          }
        });

        //操作安卓新增
        addList.forEach(function (ele) {
          // const IsShow = ele.isShow ? 1 : 0;
          var IsShow = 1;
          JiaoHu.SaveMenu(ele.dataId || ele.id, ele.name, IsShow, ele.targetUrl || ele.approute, ele.parentId || ele.bpid, ele.appicon, parseInt(ele.sort));
        });

        //操作安卓删除菜单
        deleteList.forEach(function (ele) {
          JiaoHu.DeleteMenu(ele.dataId);
        });
      } else {
        localStorage.setItem("menuList".concat(localStorage.getItem("userId")), JSON.stringify(list));
      }
      window.history.go(-1);
    };

    //菜单新增
    var addMenu = function addMenu(item) {
      if (data.showManager) {
        //菜单已被选中
        if (item.hasCheck) {
          return;
        }
        if (data.check.find(function (f) {
          return f.id == item.id;
        })) {
          return;
        }
        data.check.push(item);
        updateCheck();
      }
    };

    //删除菜单
    var removeMenu = function removeMenu(item, index) {
      if (data.showManager) {
        data.check.splice(index, 1);
        updateCheck();
      }
    };

    //返回
    var goBack = function goBack() {
      if (data.showManager) {
        mui.toast('请先保存');
        return;
      }
      window.history.go(-1);
    };

    //取消编辑
    var cancel = function cancel() {
      data.showManager = false;
      getLocalMenu();
    };
    var obj = {
      openTopMenu: openTopMenu,
      openManager: openManager,
      addMenu: addMenu,
      removeMenu: removeMenu,
      goBack: goBack,
      cancel: cancel
    };
    return Object.assign({}, obj, toRefs(data));
    // return {
    //     ...toRefs(data),
    //     openTopMenu,
    //     openManager,
    //     addMenu,
    //     removeMenu,
    //     goBack,
    //     cancel
    // }
  }
}).mount('#app');