$(function () {
  //初始化地区控件并默认选择四川省乐山市市中区
  var city_picker = null;
  var regionId = null;
  var pageIndex = 1;
  //重置地区
  $('#resetAddress').on('tap', function () {
    regionId = null;
    $("#city_text").html('请选择地区');
    pageIndex = 1;
    loadSplist();
  });
  //选择地区
  $("#city_text1").on("tap", function () {
    city_picker = new mui.PopPicker({
      layer: 4
    });
    city_picker.setData(init_city_picker);
    city_picker.pickers[0].setSelectedIndex(6);
    city_picker.pickers[1].setSelectedIndex(7);
    city_picker.pickers[2].setSelectedIndex(4);
    setTimeout(function () {
      city_picker.show(function (items) {
        var ppvalue = items[0].value;
        var pptext = items[0].text;
        if (ppvalue == undefined || pptext == undefined) {
          ppvalue = "";
        }
        var ccvalue = items[2].value;
        if (ccvalue == undefined || pptext == undefined) {
          ccvalue = "";
        }
        var civalue = items[1].value;
        if (civalue == undefined || pptext == undefined) {
          civalue = "";
        }
        var ttvalue = items[3].value;
        if (ttvalue == undefined || pptext == undefined) {
          ttvalue = "";
        }
        if (pptext == undefined) pptext = "";
        var cctext = items[2].text;
        if (cctext == undefined) cctext = "";
        var citext = items[1].text;
        if (citext == undefined) citext = "";
        var tttext = items[3].text;
        if (tttext == undefined) tttext = "";
        $("#city_text").html(pptext + citext + cctext + tttext);
        regionId = ppvalue + "/" + civalue + "/" + ccvalue + "/" + ttvalue;
        pageIndex = 1;
        loadSplist();
      });
    }, 200);
  });
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      loadSplist();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  function pullupRefresh() {
    setTimeout(function () {
      loadSplist();
    }, 1500);
  }

  // 加载商品信息
  function loadSplist() {
    var requestData = {
      "regionId": regionId,
      "pageIndex": pageIndex,
      "pageSize": 10
    };
    //获取发布列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Message/GetPublishList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      async: true,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          var tpl = $('#publishListTemp').html();
          var html = juicer(tpl, data);
          if (pageIndex == 1 && (data.data == null || data.data.length == 0)) {
            $(".zwsj-box").show();
            $("#publisgList").html("");
            return;
          }
          if (pageIndex == 1) {
            $(".zwsj-box").hide();
            $("#pullrefresh").show();
            $("#publisgList").html(html);
          } else {
            $(".zwsj-box").hide();
            $("#publisgList").append(html);
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.alert(err.message);
      }
    });
  }
  $('#publisgList').on('tap', '.list-info', function () {
    var data_id = $(this).attr('data_id');
    location.href = 'publistDetail.html?id=' + data_id;
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});