$(function () {
  //隐私协议内容
  if (!isProjectGx) {
    $('.privacy-wrapper').show();
    if (!localStorage.getItem('agreePrivacy')) {
      showPrivacy(1);
      // showPrivacy(2, function () {
      //     showPrivacy(1)
      // })
    }
  }

  //展示隐私政策
  function showPrivacy(type, cb) {
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent('<iframe style="height:10rem;width:100%;border:none;" src=' + (type === 1 ? "https://acc.yoonop.com/files/protocol.html" : "https://acc.yoonop.com/files/privacy.html") + '/>');
    layer.setTitle(type === 1 ? "用户服务协议" : "隐私政策");
    layer.setCancelText("关闭");
    layer.setOkText("我已知晓");
    $("#cancel-btn").bind("tap", function () {
      // $('#privacy-checkbox').prop('checked', false)
      if (type === 2) {
        localStorage.removeItem('agreePrivacy');
        useLocal && JiaoHu.agreePrivacy(false);
      }
      layer.close();
      $(".dialog-mask ").remove();
      cb && cb();
      return false;
    });
    $("#require-btn").bind("tap", function () {
      if (type === 2) {
        localStorage.setItem('agreePrivacy', true);
        useLocal && JiaoHu.agreePrivacy(true);
      }
      if (type === 1) {
        localStorage.setItem('agreePrivacy', true);
        useLocal && JiaoHu.agreePrivacy(true);
        // $('#privacy-checkbox').prop("checked", true)
      }

      layer.close();
      $(".dialog-mask ").remove();
      cb && cb();
      return false;
    });
  }
  $('.privacy').on('tap', function () {
    showPrivacy($(this).text() === '用户服务协议' ? 1 : 2);
  });
  $('#privacy-checkbox').on('input propertychange', function () {
    $(this).prop('checked') ? localStorage.setItem('agreePrivacy', true) : localStorage.removeItem('agreePrivacy');
  });

  // 验证码计时
  createCode();
  var canRegister = false;
  function resetCode() {
    var second = 59;
    var timer = null;
    timer = setInterval(function () {
      second -= 1;
      if (second > 0) {
        $('#yzm-btn').html(second + "秒后点击");
        $('#yzm-btn').addClass("disable");
        $('#yzm-btn').attr("disabled", "true");
      } else {
        clearInterval(timer);
        $('#yzm-btn').html("获取验证码");
        $('#yzm-btn').removeClass("disable");
        $('#yzm-btn').removeAttr("disabled");
      }
    }, 1000);
  }
  $('#yzm-btn').on('tap', function () {
    yzmSend();
  });
  //在手机号码输入到11位时判断是否重复
  $("body").on("input propertychange", "#phone", function () {
    if ($("#phone").val().length == 11) {
      validUserAndPhone();
    }
  });
  var code; //在全局定义验证码  
  function createCode() {
    code = "";
    var codeLength = 4; //验证码的长度  
    var checkCode = document.getElementById("code");
    var random = new Array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9); //随机数  
    for (var i = 0; i < codeLength; i++) {
      //循环操作  
      var index = Math.floor(Math.random() * 10); //取得随机数的索引（0~35）  
      code += random[index]; //根据索引取得随机数加到code上  
    }

    checkCode.value = code; //把code值赋给验证码  
  }

  var mask = mui.createMask();
  //点击下一步时的验证
  $('#nextStep').on('tap', function () {
    var inputCode = document.getElementById("input").value.toUpperCase(); //取得输入的验证码并转化为大写   
    var phone = $("#phone").val();
    var reg = /^1\d{10}$/;
    if (phone == "") {
      // mask.show();
      mui.toast('请输入你的电话号码');
      return false;
    }
    if (!reg.test(phone)) {
      // mask.show();
      mui.toast('您输入的电话号码不正确');
      return false;
    }
    if (inputCode.length <= 0) {
      //若输入的验证码长度为0  
      mui.toast("请输入图片验证码！"); //则弹出请输入验证码  
      return;
    }
    if (inputCode != code) {
      //若输入的验证码与产生的验证码不一致时  
      mui.toast("图片验证码输入错误");
      createCode(); //刷新验证码  
      document.getElementById("input").value = ""; //清空文本框  
      return;
    }
    if (canRegister == true) {
      yzmSend();
    } else {
      mui.toast("电话号码已注册或电话号码错误!");
      return false;
    }
  });
  $('#code').on('tap', function () {
    createCode();
  });
  function validUserAndPhone() {
    var phone = $("#phone").val() == "" ? null : $("#phone").val();
    var requestData = {
      "loginName": phone,
      "phone": phone
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/UserVerification",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      success: function success(data) {
        // if (data.data == false) {
        //     if (phone) {
        //         // $('#yzm-btn').removeClass("disable");
        //         // $('#yzm-btn').removeAttr("disabled");
        //     }
        // } else {
        //     // $('#yzm-btn').addClass("disable");
        //     // $('#yzm-btn').attr("disabled", "true");
        // }
        if (data.data) {
          mui.toast(data.msg);
          canRegister = false;
        } else {
          canRegister = true;
        }
      },
      error: function error() {
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  ;
  $('#zhuce-btn').on('tap', function () {
    zhuceCheck();
  });
  //注册
  function zhuceCheck() {
    var $this = $(this);
    $this.addClass("disable");
    $this.attr("disabled", "true");
    // var user = $("#user").val();
    var password = $("#password").val();
    // var password2 = $("#password2").val();
    var yzm = $("#yzm").val();
    var phone = $("#phone").val();
    var reg = /^1[0-9]{10}$/;
    var userReg = /^[\u4e00-\u9fa5]{2,10}$|^[\dA-Za-z_]{4,20}$/;
    // var pwdReg = /^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z\S\s]{6,16}$/;     //密码正则判断

    if (password == "") {
      // mask.show();
      mui.toast('请输入你的密码');
      return false;
    }
    if (yzm == "" || yzm.length > 6) {
      // mask.show();
      mui.toast('请输入正确的验证码!');
      return false;
    }
    // if ((password && !pwdReg.test(password))) {
    //     mui.toast('密码至少使用两种字符组合！');
    //     return false;
    // }
    if (password.length < 6 || password.length > 16) {
      mui.toast('密码长度为6到16位!');
      return false;
    }
    if (!isProjectGx && !$('#privacy-checkbox').prop('checked')) return mui.toast('请勾选同意用户服务协议和隐私政策');
    var requestData = {
      "loginName": phone,
      "phone": phone,
      "password": password,
      "confirmPassword": password,
      "verificationCode": yzm
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/ERP/Register",
      data: JSON.stringify(requestData),
      contentType: 'application/json; charset=utf-8',
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var requestdata = {
            loginName: phone,
            loginPwd: password
          };
          $.ajax({
            type: "POST",
            url: baseRequestUrl + "/api/erp/login",
            contentType: 'application/json; charset=utf-8',
            data: JSON.stringify(requestdata),
            dataType: "json",
            beforeSend: function beforeSend() {
              loading();
              $("#app-mask").show();
            },
            success: function (_success2) {
              function success(_x2) {
                return _success2.apply(this, arguments);
              }
              success.toString = function () {
                return _success2.toString();
              };
              return success;
            }(function (data) {
              setTimeout(function () {
                $('#loading').remove();
              }, 50);
              if (data.code == 1) {
                mui.toast("恭喜注册成功");
                setTimeout(function () {
                  window.location.href = "login.html";
                }, 1000);
                success();
              }
            })
          });
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //软键盘 点击开始    开始
  del = function keyLogin() {
    if (13 == event.keyCode) {
      zhuceCheck();
      document.activeElement.blur();
    }
  };
  $("#phone").on("change", function (e) {
    //console.log("phone blur==", e.target.value)
    window.getPhoneCode(e.target.value);
  });
  function yzmSend() {
    if (!window.phoneCode) {
      window.getPhoneCode($("#phone").val(), function () {
        _yzmSend();
      });
    } else {
      _yzmSend();
    }
  }
  function _yzmSend() {
    var requestData = {
      phoneCode: window.phoneCode,
      phone: $("#phone").val(),
      sendType: 1,
      soureType: erpSourceType
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/SendPhoneMsg",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success3) {
        function success(_x3) {
          return _success3.apply(this, arguments);
        }
        success.toString = function () {
          return _success3.toString();
        };
        return success;
      }(function (data) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          resetCode(); //验证码倒计时
          mui.toast("验证码已发送，请注意查收");
          success();
          $('.phoneNum').css('display', 'none');
          $('#nextStep').css('display', 'none');
          $('.pass-form-item-submit').css('display', 'none');
          $('.goBack').css('display', 'block');
          $('.passwordBox').css('display', 'block');
          $('#zhuce-btn').css('display', 'block');
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  ;
  $("#imgSrc").on('tap', function () {
    var mm = $('#password').attr('type');
    var obj = $("#imgSrc");
    if (obj.attr("src") == "img/eyes.svg") {
      obj.attr("src", "img/eyesClose.svg");
      $('#password').attr('type', "password");
    } else {
      obj.attr("src", "img/eyes.svg");
      $('#password').attr('type', "text");
    }
  });
  var winHeight = $(window).height(); //获取当前页面高度
  $(window).resize(function () {
    var thisHeight = $(this).height();
    if (winHeight - thisHeight > 50) {
      //当软键盘弹出，在这里面操作
      $(".logo-mid").hide();
    } else {
      //当软键盘收起，在此处操作
      $(".logo-mid").show();
    }
  });
});
window.zhuceVal;
window.del;