$(function () {
  pageIndex = 0;
  pageSize = 10;
  timers();
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  // 上拉加载
  function pullupRefresh() {
    pageIndex++;
    pullPublic();
  }

  // 下拉刷新
  function pullfreshF5() {
    pageIndex = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
  }

  // 获取交易数据
  function pullPublic() {
    var mystartTime = $(".start-time").text(); //开始时间
    var myendTime = $(".end-time").text(); //结束时间
    var obj = {
      pageIndex: pageIndex,
      pageSize: 10,
      payType: '',
      startTime: mystartTime,
      endTime: myendTime
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/StoreTransactionList",
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(obj),
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * pageSize >= data.totalCount); //参数为true代表没有更多数据了。
        $('#loading').remove();
        if (data.code == 1) {
          var tpl = $("#payRecordListTemp").html();
          var html = juicer(tpl, data);
          if (pageIndex == 1) $("#newsChaxunList").html(html);else $("#newsChaxunList").append(html);
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }

  // 点击返回按钮
  $('.tops').on('tap', '.goBack-btn', function () {
    window.location.href = 'payment.html';
  });

  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').animate({
        "top": '2.5rem'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-6rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  // 筛选栏插入日期选择
  function timers() {
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var day = myDate.getDate();
    if (month < 10) {
      month = "0" + month;
    }
    if (day < 10) {
      day = "0" + day;
    }
    var stime = year + "-" + month + "-01";
    var etime = year + "-" + month + "-" + day;
    var html = '<label>时间：</label><p class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></p>&nbsp;—';
    html += '&nbsp;<p class="btn endTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></p>';
    $('.timeList').html(html);
  }

  // 筛选栏日期选择
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  var btns = $('.btn');
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-6rem'
    }, 300, function () {
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#require-btn').on('tap', function () {
    pageIndex = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-6rem'
    }, 300, function () {
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancel-btn').on('tap', function () {
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var day = myDate.getDate();
    if (month < 10) {
      month = "0" + month;
    }
    if (day < 10) {
      day = "0" + day;
    }
    var stime = year + "-" + month + "-01";
    var etime = year + "-" + month + "-" + day;
    $(".start-time").text(stime); //开始时间
    $(".end-time").text(etime); //结束时间
  });
});