function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag,
  ElCascader = _ElementPlus.ElCascader,
  ElMessageBox = _ElementPlus.ElMessageBox,
  ElDialog = _ElementPlus.ElDialog,
  ElForm = _ElementPlus.ElForm,
  ElFormItem = _ElementPlus.ElFormItem,
  ElSwitch = _ElementPlus.ElSwitch;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus,
  ArrowUp = _ElementPlusIconsVue.ArrowUp;
var m = moment;
var storeId = localStorage.getItem("storeId");
var app = createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus,
    ElCascader: ElCascader,
    ElMessageBox: ElMessageBox,
    ElDialog: ElDialog,
    ElForm: ElForm,
    ElFormItem: ElFormItem,
    ElSwitch: ElSwitch
  },
  setup: function setup() {
    var data = reactive({
      queryParams: {
        id: "",
        goodsName: "",
        firstLetter: '',
        goodsCategoryCode: "",
        goodsType: "",
        isShelves: 99,
        storeId: storeId,
        pageIndex: 1,
        pageSize: 10,
        sortName: 'goodsSort',
        isSort: false,
        isExpand: true
      },
      screenVisible: false,
      //筛选开关
      branches: [{
        text: '全部',
        value: 99
      }, {
        text: '上架',
        value: 1
      }, {
        text: '下架',
        value: 2
      }, {
        text: '同步未上架',
        value: 0
      }],
      options: [],
      goodsTypeArry: [],
      state: 99,
      //通过状态决定是否显示全部添加
      list: [],
      totalCount: 0,
      //数据总条数
      loading: false,
      form: {
        stockQuantity: 0,
        goodsSort: 1,
        isAllGoods: true,
        //是否全部添加
        erpStockQuantity: 0,
        goodsId: "",
        isOnLinePay: true,
        //是否在线支付
        isSigningPay: true,
        // 是否支持货到付款
        isStorePickup: true,
        // 是否支持自提 
        isStoreDelivery: true,
        // 是否支持外送 
        goodsExtendInfo: '',
        //商品补充信息
        goodsBaseInfo: '' //商品展示信息
      },

      visible: false,
      isInitualize: true,
      //是否已经初始化商品
      activeList: [],
      //操作项
      activeVisable: false,
      sortList: [{
        type: 'goodsSort',
        isSort: false,
        name: '销售排序'
      },
      //true从大到小
      {
        type: 'erpStockQuantity',
        isSort: false,
        name: '商品库存'
      }],
      showInfoVisable: false,
      onlinePayState: 9,
      //农资店初始是否开通线上支付9:初始已开通，其他为未开通
      shareVisible: false,
      shareList: [{
        name: "分享微信",
        imgUrl: './img/peripheryStore/weixin.png'
      }, {
        name: "生成海报",
        imgUrl: './img/peripheryStore/poster.png'
      }],
      storeInfo: {},
      isOpenStore: false //是否开通农资微店
    });

    onMounted(function () {
      getStoreInfo();
      isPeripheryStore(function () {
        getGoodsType();
        getList();
        getIsInitializeGoods();
        getOnlinePayment();
      });
      setTimeout(function () {
        mui.init({
          swipeBack: true,
          //启用右滑关闭功能
          pullRefresh: {
            container: '#refreshContainer',
            subpages: [{
              url: window.location.href,
              //下拉刷新内容页面地址
              id: '#refreshContainer',
              //内容页面标志
              styles: {
                top: 148 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
                //其它参数定义
              }
            }],

            up: {
              contentrefresh: '正在加载...',
              callback: function callback() {
                setTimeout(function () {
                  data.queryParams.pageIndex += 1;
                  getList(function (res) {
                    mui('#refreshContainer').pullRefresh().endPullupToRefresh(data.list.length >= res.totalCount); //参数为true代表没有更多数据了。
                  });
                }, 1000);
              },
              auto: false
            },
            down: {
              style: 'circle',
              //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
              auto: false,
              //可选,默认false.首次加载自动上拉刷新一次
              callback: function callback() {
                data.queryParams.pageIndex = 1;
                setTimeout(function () {
                  getList(function () {
                    mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
                    mui('#refreshContainer').pullRefresh().refresh(true);
                  });
                }, 1000);
              } //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
            }
          }
        });
      }, 500);
    });
    watchEffect(function () {
      if (data.screenVisible == true) {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '7.5rem'
        });
      } else {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '2rem'
        });
      }
    });
    // 检查店铺是否申请线上收款
    var getOnlinePayment = function getOnlinePayment() {
      $http({
        url: '/Api/Store/GetOnlinePayment'
      }).then(function (res) {
        if (res.code == 1) {
          data.onlinePayState = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    // 获取是否开通农资店
    var isPeripheryStore = function isPeripheryStore() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      // 先获取是否开通了农资微店
      $http({
        url: "/Api/Store/GetPeripheryStore"
      }).then(function (res) {
        if (res.code == 1) {
          if (res.data === true) {
            data.isOpenStore = true;
            cb && cb();
          } else {
            ElMessageBox.confirm('当前店铺暂未开通农资微店功能，是否前往开通？', '提示', {
              confirmButtonText: '确定',
              cancelButtonText: '取消',
              type: 'warning'
            }).then(function () {
              window.location.href = 'peripheryStoreDetail.html';
            }).catch(function () {
              window.location.href = 'index.html';
            });
          }
        }
      });
    };
    // 获取商品类型
    var getGoodsType = function getGoodsType() {
      $http({
        url: '/Api/GoodsBase/GoodsType'
      }).then(function (res) {
        if (res.code == 1) {
          var goodsType = res.data.goodsType;
          var goodsCategory = res.data.goodsCategory;
          goodsCategory = goodsCategory.filter(function (i) {
            return i.value != '5';
          });
          goodsCategory.forEach(function (i) {
            i.children = [];
            goodsType.forEach(function (n) {
              if (i.value == n.parentId) {
                i.children.push(n);
              }
            });
          });
          data.options = goodsCategory;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    //获取列表
    var getList = function getList() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      data.loading = true;
      data.state = data.queryParams.isShelves;
      $http({
        url: "/Api/PripheryStoreGoods/GetPeripheryStoreGooodsList",
        data: _objectSpread({}, data.queryParams)
      }).then(function (res) {
        data.loading = false;
        if (res.code == 1) {
          res.data.forEach(function (i) {
            i.isMore = false; //是否展开更多信息
            if (i.syncTime) {
              i.syncTime = moment(i.syncTime).format('YYYY-MM-DD');
            }
            i.memberPrice = toThousands(i.memberPrice);
          });
          if (cb) cb(res);
          if (data.queryParams.pageIndex == 1) {
            data.list = _toConsumableArray(res.data);
            if (type == 1) {
              mui('#refreshContainer').pullRefresh().scrollTo(0, 0, 100);
              mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
              mui('#refreshContainer').pullRefresh().refresh(true);
            }
          } else {
            data.list = [].concat(_toConsumableArray(data.list), _toConsumableArray(res.data));
          }
          data.totalCount = res.totalCount;
        } else {
          vant.Toast(res.msg);
        }
      }).catch(function (err) {
        data.loading = false;
      });
    };
    // 检查是否初始化
    var getIsInitializeGoods = function getIsInitializeGoods() {
      $http({
        url: '/Api/PripheryStoreGoods/GetIsInitializeGoods'
      }).then(function (res) {
        if (res.code == 1) {
          data.isInitualize = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    // 全部添加
    var allAdd = function allAdd() {
      data.form.stockQuantity = 0;
      data.form.isAllGoods = true;
      data.form.goodsExtendInfo = '';
      data.form.goodsBaseInfo = '';
      data.form.isOnLinePay = true;
      data.form.isSigningPay = true;
      data.form.isStorePickup = true;
      data.form.isStoreDelivery = true;
      data.visible = true;
    };

    // 弹出框取消
    var handleCancel = function handleCancel() {
      data.visible = false;
    };
    // 弹出框确定
    var handleOk = function handleOk() {
      var form = data.form;
      var pattren = /^0?$|^([1-9][0-9]*)?$/;
      var pricePattren = /(^[1-9]\d*(\.\d{1,2})?$)|(^0(\.\d{1,2})?$)/;
      //  /^\d+(\.\d{1,2})?$/
      if (!form.stockQuantity || !pattren.test(form.stockQuantity)) {
        vant.Toast("请输入正确的库存量");
        return;
      }
      if (!form.memberPrice || !pricePattren.test(form.memberPrice)) {
        vant.Toast("请输入正确的微店售价");
        return;
      }
      if (!form.isAllGoods && (!form.goodsSort || !pattren.test(form.goodsSort))) {
        //如果不是全部添加判读销售排序
        vant.Toast("请输入正确的销售排序");
        return;
      }
      if (!form.isAllGoods && form.goodsSort == 0) {
        vant.Toast("销售排序不能为0");
        return;
      }
      if (!form.isOnLinePay && !form.isSigningPay) {
        vant.Toast("在线支付和货到付款不能同时为否");
        return;
      }
      if (!form.isStorePickup && !form.isStoreDelivery) {
        vant.Toast("是否自提和是否外送不能同时为否");
        return;
      }
      var payload = {
        isAllGoods: form.isAllGoods,
        stockQuantity: form.isAllGoods ? form.stockQuantity : 0,
        goodsExtendInfo: form.isAllGoods ? form.goodsExtendInfo : '',
        isOnLinePay: isPeripheryStoreOnlinePay ? false : form.isAllGoods ? form.isOnLinePay : false,
        isSigningPay: isPeripheryStoreOnlinePay ? true : form.isAllGoods ? form.isSigningPay : false,
        isStorePickup: form.isAllGoods ? form.isStorePickup : false,
        isStoreDelivery: form.isAllGoods ? form.isStoreDelivery : false,
        list: form.isAllGoods ? [] : [{
          goodsId: form.goodsId,
          stockQuantity: form.stockQuantity,
          goodsSort: form.goodsSort,
          goodsExtendInfo: form.goodsExtendInfo,
          isOnLinePay: isPeripheryStoreOnlinePay ? false : form.isOnLinePay,
          isSigningPay: isPeripheryStoreOnlinePay ? true : form.isSigningPay,
          isStorePickup: form.isStorePickup,
          isStoreDelivery: form.isStoreDelivery,
          goodsPrice: Number(form.memberPrice)
        }]
      };
      console.log(payload, 'ppppppppp');
      // return
      if (payload.isAllGoods && data.totalCount >= 50) {
        // 全部添加时，数据超过50条则先执行回调关闭弹窗再执行接口，防止接口刷新过久导致等待时间过长
        vant.Toast({
          message: "操作成功,当前数据过多服务器正在加速处理，请稍后手动刷新查看！",
          duration: 4000
        });
        data.visible = false;
        data.queryParams.pageIndex = 1;
        getList(function () {}, 1);
        $http({
          url: '/Api/PripheryStoreGoods/Add',
          data: payload
        });
      } else {
        data.loading = true;
        $http({
          url: '/Api/PripheryStoreGoods/Add',
          data: payload
        }).then(function (res) {
          data.loading = false;
          if (res.code == 1) {
            vant.Toast("操作成功");
            data.visible = false;
            data.queryParams.pageIndex = 1;
            getList(function () {}, 1);
          } else {
            vant.Toast(res.msg);
          }
        }).catch(function (err) {
          data.loading = false;
        });
      }
    };
    // 上下架
    var batchState = function batchState(state, id) {
      //state==1上架，2下架
      var url = state == 1 ? '/Api/PripheryStoreGoods/ListingGoods' : '/Api/PripheryStoreGoods/DelistingGoods';
      var goodsIdArr = [id];
      $http({
        url: url,
        data: goodsIdArr
      }).then(function (res) {
        if (res.code == 1) {
          vant.Toast("操作成功");
          data.queryParams.pageIndex = 1;
          getList(function () {}, 1);
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    // 点击更多操作
    var moreActive = function moreActive(item) {
      if (!item.isShelves) {
        data.activeList = [{
          name: "添加",
          imgUrl: './img/peripheryStore/zhoubian_bianji.png'
        }];
      } else if (item.isShelves == 2) {
        data.activeList = [{
          name: "编辑并上架",
          imgUrl: './img/peripheryStore/zhoubian_shangjia.png'
        }, {
          name: "展示信息",
          imgUrl: './img/peripheryStore/zhoubian_zhanshi.png'
        }];
      } else if (item.isShelves == 1) {
        data.activeList = [{
          name: "编辑",
          imgUrl: './img/peripheryStore/zhoubian_bianji.png'
        }, {
          name: "下架",
          imgUrl: './img/peripheryStore/zhoubian_xiajia.png'
        }, {
          name: "展示信息",
          imgUrl: './img/peripheryStore/zhoubian_zhanshi.png'
        }, {
          name: "分享微信",
          imgUrl: './img/peripheryStore/weixin.png'
        }, {
          name: "生成海报",
          imgUrl: './img/peripheryStore/poster.png'
        }];
      } else {
        data.activeList = [{
          name: "编辑",
          imgUrl: './img/peripheryStore/zhoubian_bianji.png'
        }, {
          name: "展示信息",
          imgUrl: './img/peripheryStore/zhoubian_zhanshi.png'
        }];
      }
      data.form = _objectSpread(_objectSpread({}, item), {}, {
        isAllGoods: false,
        goodsId: item.id,
        isOnLinePay: data.onlinePayState == 9 ? true : item.isOnLinePay,
        //如果当前店铺开通了在线支付则直接赋值不允许修改
        goodsExtendInfo: item.goodsExtendInfo ? item.goodsExtendInfo : '',
        goodsBaseInfo: item.goodsBaseInfo ? item.goodsBaseInfo : ''
      });
      data.activeVisable = true;
    };
    // 点击操作项
    var handelMenuClick = function handelMenuClick(name) {
      if (name == '下架') {
        batchState(2, data.form.goodsId);
      }
      if (name == '编辑并上架' || name == '编辑' || name == '添加') {
        data.visible = true;
      }
      if (name == '展示信息') {
        if (!data.form.isUpGoodsInfo) {
          vant.Toast({
            message: "当前商品展示信息暂未同步，请稍后手动刷新再试！",
            duration: 4000
          });
          return;
        }
        data.showInfoVisable = true;
      }
      if (name == '分享微信') {
        getShareCode('goods', function (res) {
          if (JiaoHu) {
            var code = encodeURIComponent(res.data.shareCode);
            JiaoHu.shareMiniProgram("/pagesAgriculturalShop/pages/shop/shop?scene=".concat(code), data.form.goodsName, "\uFFE5".concat(data.form.memberPrice, "(").concat(data.form.specifications, ")"), data.form.minImgUrl);
          }
        });
      }
      if (name == '生成海报') {
        window.location.href = 'sharePoster.html?type=goods';
        sessionStorage.setItem('shareData', JSON.stringify(data.form));
      }
      data.activeVisable = false;
    };
    //分享点击操作项
    var handelMenuClickByShare = function handelMenuClickByShare(name) {
      data.shareVisible = false;
      if (name == '分享微信') {
        getShareCode('store', function (res) {
          if (JiaoHu) {
            var code = encodeURIComponent(res.data.shareCode);
            JiaoHu.shareMiniProgram("/pagesAgriculturalShop/pages/shop/shop?scene=".concat(code), data.storeInfo.name, "", 'https://yoonop.oss-cn-hangzhou.aliyuncs.com/yoonopApp/static/01f75c198b6285037a5239c5fb7562ec.png');
          }
        });
      } else {
        window.location.href = 'sharePoster.html?type=store';
      }
    };
    //点击分享门店
    var clickShareStore = function clickShareStore() {
      setTimeout(function () {
        data.shareVisible = true;
      }, 100);
    };
    //获取分享参数
    var getShareCode = function getShareCode(type, callback) {
      var form = data.form,
        storeInfo = data.storeInfo;
      var postFunc = type === 'goods' ? '/Api/PripheryStoreGoods/ShareOnlineGoodsAddData' : '/Api/PripheryStoreGoods/ShareOnlineStoreAddData';
      var payload = {
        goodsId: form.baseGoodsId,
        parameterJson: '',
        startDate: moment(i.syncTime).format('YYYY-MM-DD HH:mm:ss'),
        endDate: moment().format('YYYY-MM-DD HH:mm:ss'),
        isIndefinite: true
      };
      if (type === 'store') {
        payload.goodsId = storeInfo.id;
      }
      data.loading = true;
      $http({
        url: postFunc,
        data: payload
      }).then(function (res) {
        data.loading = false;
        if (res.code === 1) {
          callback(res);
        } else {
          vant.Toast({
            message: res.msg,
            duration: 4000
          });
        }
      }).catch(function () {
        data.loading = false;
      });
    };

    //获取门店信息
    var getStoreInfo = function getStoreInfo() {
      $http({
        url: '/Api/Store/GetStoreInfo'
      }).then(function (res) {
        if (res.code === 1) {
          data.storeInfo = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //    点击更多信息
    var handleMore = function handleMore(item) {
      item.isMore = !item.isMore;
    };
    // 排序按钮点击事件
    var sortChange = function sortChange(i, index) {
      data.sortList[index].isSort = !data.sortList[index].isSort;
      data.queryParams.isSort = data.sortList[index].isSort;
      data.queryParams.sortName = data.sortList[index].type;
    };
    // 搜索框完成时间
    var searchInput = function searchInput() {
      data.queryParams.pageIndex = 1;
      getList(function () {}, 1);
    };
    //筛选开关
    var clickScreen = function clickScreen() {
      data.screenVisible = !data.screenVisible;
    };
    // 级联回调
    var handleChange = function handleChange(value) {
      if (!value) {
        data.queryParams.goodsType = '';
        data.queryParams.goodsCategoryCode = '';
      } else if (value.length == 1) {
        data.queryParams.goodsType = value[0];
        data.queryParams.goodsCategoryCode = '';
      } else if (value.length == 2) {
        data.queryParams.goodsCategoryCode = value[1];
      } else {
        data.queryParams.goodsType = '';
        data.queryParams.goodsCategoryCode = '';
      }
    };
    // 重置
    var reset = function reset() {
      data.queryParams.goodsType = '';
      data.queryParams.goodsCategoryCode = '';
      data.queryParams.goodsName = '';
      data.queryParams.isShelves = 99;
      data.goodsTypeArry = [];
      data.queryParams.pageIndex = 1;
      data.state = 99;
      data.queryParams.isSort = false;
      data.queryParams.sortName = 'goodsSort';
      data.sortList = [{
        type: 'goodsSort',
        isSort: false,
        name: '销售排序'
      },
      //true从大到小
      {
        type: 'erpStockQuantity',
        isSort: false,
        name: '商品库存'
      }];
      getList(function () {}, 1);
    };
    var closeShowInfoVisable = function closeShowInfoVisable() {
      data.showInfoVisable = false;
      data.form.goodsBaseInfo = '';
    };

    //返回按钮
    var goBack = function goBack() {
      window.location.href = 'allMenu.html';
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      goBack: goBack,
      searchInput: searchInput,
      clickScreen: clickScreen,
      getList: getList,
      handleChange: handleChange,
      reset: reset,
      allAdd: allAdd,
      handleCancel: handleCancel,
      handleOk: handleOk,
      batchState: batchState,
      handleMore: handleMore,
      moreActive: moreActive,
      handelMenuClick: handelMenuClick,
      sortChange: sortChange,
      closeShowInfoVisable: closeShowInfoVisable,
      clickShareStore: clickShareStore,
      handelMenuClickByShare: handelMenuClickByShare
    });
  }
});
app.use(vant);
app.mount('#app');