function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag,
  ElCascader = _ElementPlus.ElCascader,
  ElMessageBox = _ElementPlus.ElMessageBox,
  ElDialog = _ElementPlus.ElDialog,
  ElForm = _ElementPlus.ElForm,
  ElFormItem = _ElementPlus.ElFormItem,
  ElSwitch = _ElementPlus.ElSwitch,
  ElRadioGroup = _ElementPlus.ElRadioGroup,
  ElRadio = _ElementPlus.ElRadio,
  ElDatePicker = _ElementPlus.ElDatePicker;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus,
  ArrowUp = _ElementPlusIconsVue.ArrowUp;
var m = moment;
var storeId = localStorage.getItem("storeId");
var app = createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus,
    ElCascader: ElCascader,
    ElMessageBox: ElMessageBox,
    ElDialog: ElDialog,
    ElForm: ElForm,
    ElFormItem: ElFormItem,
    ElSwitch: ElSwitch,
    ElRadioGroup: ElRadioGroup,
    ElRadio: ElRadio,
    ElDatePicker: ElDatePicker
  },
  setup: function setup() {
    var radio = ref(3);
    var data = reactive({
      queryParams: {
        id: "",
        goodsName: "",
        firstLetter: '',
        goodsCategoryCode: "",
        goodsType: "",
        isShelves: 99,
        storeId: storeId,
        pageIndex: 1,
        pageSize: 10,
        sortName: 'goodsSort',
        isSort: false,
        isExpand: true,
        startTime: ''
      },
      screenVisible: false,
      //筛选开关
      branches: [{
        text: '全部',
        value: 99
      }, {
        text: '上架',
        value: 1
      }, {
        text: '下架',
        value: 2
      }, {
        text: '同步未上架',
        value: 0
      }],
      options: [],
      goodsTypeArry: [],
      state: 99,
      //通过状态决定是否显示全部添加
      list: [],
      totalCount: 0,
      //数据总条数
      loading: false,
      form: {
        isIndefinite: 1,
        startTime: '',
        endTime: ''
      },
      visible: false,
      isInitualize: true,
      //是否已经初始化商品
      activeList: [],
      //操作项
      activeVisable: false,
      sortList: [{
        type: 'goodsSort',
        isSort: false,
        name: '销售排序'
      },
      //true从大到小
      {
        type: 'erpStockQuantity',
        isSort: false,
        name: '商品库存'
      }],
      showInfoVisable: false,
      onlinePayState: 9,
      //农资店初始是否开通线上支付9:初始已开通，其他为未开通
      pageType: '',
      shareData: {},
      storeInfo: {},
      miniProgramCode: '',
      posterUrl: ''
    });
    onMounted(function () {
      var params = getSearchParams();
      if (params && params.type) {
        data.pageType = params.type;
      }
      getStoreInfo();
    });
    watchEffect(function () {
      if (data.screenVisible == true) {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '7.5rem'
        });
      } else {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '2rem'
        });
      }
    });

    //点击生成海报
    var generatePoster = function generatePoster() {
      var form = data.form;
      if (form.isIndefinite === 2) {
        if (!Boolean(form.startTime)) {
          vant.Toast('请选择有效期开始时间');
          return;
        }
        if (!Boolean(form.endTime)) {
          vant.Toast('请选择有效期结束时间');
          return;
        }
      }
      getShareCode();
    };

    //获取分享参数
    var getShareCode = function getShareCode() {
      var pageType = data.pageType,
        form = data.form,
        storeInfo = data.storeInfo;
      var postFunc = pageType === 'goods' ? '/Api/PripheryStoreGoods/ShareOnlineGoodsAddData' : '/Api/PripheryStoreGoods/ShareOnlineStoreAddData';
      var payload = {
        goodsId: '',
        parameterJson: '',
        startDate: form.isIndefinite === 1 ? moment().format('YYYY-MM-DD HH:mm:ss') : moment(form.startTime).format('YYYY-MM-DD HH:mm:ss'),
        endDate: form.isIndefinite === 1 ? moment().format('YYYY-MM-DD HH:mm:ss') : moment(form.endTime).format('YYYY-MM-DD HH:mm:ss'),
        isIndefinite: form.isIndefinite === 1
      };
      if (pageType === 'goods') {
        var storage = sessionStorage.getItem('shareData');
        if (storage) {
          var value = JSON.parse(storage);
          payload.goodsId = value.baseGoodsId;
        }
      } else {
        payload.goodsId = storeInfo.id;
      }
      data.loading = true;
      $http({
        url: postFunc,
        data: payload
      }).then(function (res) {
        if (res.code === 1) {
          data.shareData = res.data;
          getMiniProgramCode();
        } else {
          vant.Toast(res.msg);
          data.loading = false;
        }
      }).catch(function () {
        data.loading = false;
      });
    };

    //获取小程序码
    var getMiniProgramCode = function getMiniProgramCode() {
      var pageType = data.pageType,
        shareData = data.shareData;
      $http({
        url: "/Api/PripheryStoreGoods/Getwxacodeunlimit",
        data: {
          shareCode: shareData.shareCode,
          shareType: pageType === 'goods' ? 2 : 1
        }
      }).then(function (res) {
        if (res.code === 1) {
          data.miniProgramCode = res.data;
          getPoster();
        } else {
          vant.Toast(res.msg);
          data.loading = false;
        }
      }).catch(function () {
        data.loading = false;
      });
    };

    //生成海报
    var getPoster = function getPoster() {
      var shareData = data.shareData,
        pageType = data.pageType,
        miniProgramCode = data.miniProgramCode,
        storeInfo = data.storeInfo;
      var payload = {
        image_url_to_embed: 'https://picx.zhimg.com/80/v2-fb8e658102ec4094213254a1170d1001_720w.webp?source=1def8aca',
        base64_image_qr: miniProgramCode,
        text_1: storeInfo.name,
        text_2: '1',
        text_3: '2',
        image_type: 2
      };
      if (pageType == 'goods') {
        var storage = sessionStorage.getItem('shareData');
        if (storage) {
          var value = JSON.parse(storage);
          payload.image_url_to_embed = value.minImgUrl;
          payload.text_2 = '￥' + Number(value.memberPrice).toFixed(2);
          payload.text_3 = value.goodsName;
          payload.image_type = 1;
        }
      }
      $.ajax({
        type: 'POST',
        url: 'https://da.yoonop.com/image/image_processing',
        data: JSON.stringify(payload),
        dataType: "json",
        success: function success(res) {
          data.loading = false;
          if (res.code === 1) {
            data.posterUrl = res.image;
          } else {
            vant.Toast(res.msg);
          }
        },
        error: function error(err) {
          data.loading = false;
          vant.Toast(err);
        }
      });
    };

    //保存图片到相册
    var saveImgByPhoto = function saveImgByPhoto() {
      var f = dataURLtoFile(data.posterUrl, 'test.png');
      var prePath = window.isDev ? 'http://test-yoonop.oss-cn-hangzhou.aliyuncs.com/' : 'http://yoonop.oss-cn-hangzhou.aliyuncs.com/';
      data.loading = true;
      uploadOSS(f).then(function (res) {
        if (JiaoHu) {
          data.loading = false;
          JiaoHu.saveImageToGallery(prePath + res.name);
        }
      });
    };

    //将base64转换为文件对象
    function dataURLtoFile(dataurl, filename) {
      var arr = dataurl.split(',');
      var mime = arr[0].match(/:(.*?);/)[1];
      var bstr = atob(arr[1]);
      var n = bstr.length;
      var u8arr = new Uint8Array(n);
      while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
      }
      //转换成file对象
      return new File([u8arr], filename, {
        type: mime
      });
      //转换成成blob对象
      //return new Blob([u8arr],{type:mime});
    }

    //获取门店信息
    var getStoreInfo = function getStoreInfo() {
      $http({
        url: '/Api/Store/GetStoreInfo'
      }).then(function (res) {
        if (res.code === 1) {
          data.storeInfo = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    // 检查店铺是否申请线上收款
    var getOnlinePayment = function getOnlinePayment() {
      $http({
        url: '/Api/Store/GetOnlinePayment'
      }).then(function (res) {
        if (res.code == 1) {
          data.onlinePayState = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    // 获取是否开通农资店
    var isPeripheryStore = function isPeripheryStore() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      // 先获取是否开通了农资微店
      $http({
        url: "/Api/Store/GetPeripheryStore"
      }).then(function (res) {
        if (res.code == 1) {
          if (res.data === true) {
            cb && cb();
          } else {
            ElMessageBox.confirm('当前店铺暂未开通农资微店功能，是否前往开通？', '提示', {
              confirmButtonText: '确定',
              cancelButtonText: '取消',
              type: 'warning'
            }).then(function () {
              window.location.href = 'peripheryStoreDetail.html';
            }).catch(function () {
              window.location.href = 'index.html';
            });
          }
        }
      });
    };
    // 获取商品类型
    var getGoodsType = function getGoodsType() {
      $http({
        url: '/Api/GoodsBase/GoodsType'
      }).then(function (res) {
        if (res.code == 1) {
          var goodsType = res.data.goodsType;
          var goodsCategory = res.data.goodsCategory;
          goodsCategory = goodsCategory.filter(function (i) {
            return i.value != '5';
          });
          goodsCategory.forEach(function (i) {
            i.children = [];
            goodsType.forEach(function (n) {
              if (i.value == n.parentId) {
                i.children.push(n);
              }
            });
          });
          data.options = goodsCategory;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    //获取列表
    var getList = function getList() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      data.loading = true;
      data.state = data.queryParams.isShelves;
      $http({
        url: "/Api/PripheryStoreGoods/GetPeripheryStoreGooodsList",
        data: _objectSpread({}, data.queryParams)
      }).then(function (res) {
        data.loading = false;
        if (res.code == 1) {
          res.data.forEach(function (i) {
            i.isMore = false; //是否展开更多信息
            if (i.syncTime) {
              i.syncTime = moment(i.syncTime).format('YYYY-MM-DD');
            }
            i.memberPrice = toThousands(i.memberPrice);
          });
          if (cb) cb(res);
          if (data.queryParams.pageIndex == 1) {
            data.list = _toConsumableArray(res.data);
            if (type == 1) {
              mui('#refreshContainer').pullRefresh().scrollTo(0, 0, 100);
              mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
              mui('#refreshContainer').pullRefresh().refresh(true);
            }
          } else {
            data.list = [].concat(_toConsumableArray(data.list), _toConsumableArray(res.data));
          }
          data.totalCount = res.totalCount;
        } else {
          vant.Toast(res.msg);
        }
      }).catch(function (err) {
        data.loading = false;
      });
    };
    // 检查是否初始化
    var getIsInitializeGoods = function getIsInitializeGoods() {
      $http({
        url: '/Api/PripheryStoreGoods/GetIsInitializeGoods'
      }).then(function (res) {
        if (res.code == 1) {
          data.isInitualize = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    // 全部添加
    var allAdd = function allAdd() {
      data.form.stockQuantity = 0;
      data.form.isAllGoods = true;
      data.form.goodsExtendInfo = '';
      data.form.goodsBaseInfo = '';
      data.form.isOnLinePay = true;
      data.form.isSigningPay = true;
      data.form.isStorePickup = true;
      data.form.isStoreDelivery = true;
      data.visible = true;
    };

    // 弹出框取消
    var handleCancel = function handleCancel() {
      data.visible = false;
    };
    // 弹出框确定
    var handleOk = function handleOk() {
      var form = data.form;
      var pattren = /^0?$|^([1-9][0-9]*)?$/;
      if (!form.stockQuantity || !pattren.test(form.stockQuantity)) {
        vant.Toast("请输入正确的库存量");
        return;
      }
      if (!form.isAllGoods && (!form.goodsSort || !pattren.test(form.goodsSort))) {
        //如果不是全部添加判读销售排序
        vant.Toast("请输入正确的销售排序");
        return;
      }
      if (!form.isAllGoods && form.goodsSort == 0) {
        vant.Toast("销售排序不能为0");
        return;
      }
      if (!form.isOnLinePay && !form.isSigningPay) {
        vant.Toast("在线支付和货到付款不能同时为否");
        return;
      }
      if (!form.isStorePickup && !form.isStoreDelivery) {
        vant.Toast("是否自提和是否外送不能同时为否");
        return;
      }
      var payload = {
        isAllGoods: form.isAllGoods,
        stockQuantity: form.isAllGoods ? form.stockQuantity : 0,
        goodsExtendInfo: form.isAllGoods ? form.goodsExtendInfo : '',
        isOnLinePay: isPeripheryStoreOnlinePay ? false : form.isAllGoods ? form.isOnLinePay : false,
        isSigningPay: isPeripheryStoreOnlinePay ? true : form.isAllGoods ? form.isSigningPay : false,
        isStorePickup: form.isAllGoods ? form.isStorePickup : false,
        isStoreDelivery: form.isAllGoods ? form.isStoreDelivery : false,
        list: form.isAllGoods ? [] : [{
          goodsId: form.goodsId,
          stockQuantity: form.stockQuantity,
          goodsSort: form.goodsSort,
          goodsExtendInfo: form.goodsExtendInfo,
          isOnLinePay: isPeripheryStoreOnlinePay ? false : form.isOnLinePay,
          isSigningPay: isPeripheryStoreOnlinePay ? true : form.isSigningPay,
          isStorePickup: form.isStorePickup,
          isStoreDelivery: form.isStoreDelivery
        }]
      };
      if (payload.isAllGoods && data.totalCount >= 50) {
        // 全部添加时，数据超过50条则先执行回调关闭弹窗再执行接口，防止接口刷新过久导致等待时间过长
        vant.Toast({
          message: "操作成功,当前数据过多服务器正在加速处理，请稍后手动刷新查看！",
          duration: 4000
        });
        data.visible = false;
        data.queryParams.pageIndex = 1;
        getList(function () {}, 1);
        $http({
          url: '/Api/PripheryStoreGoods/Add',
          data: payload
        });
      } else {
        data.loading = true;
        $http({
          url: '/Api/PripheryStoreGoods/Add',
          data: payload
        }).then(function (res) {
          data.loading = false;
          if (res.code == 1) {
            vant.Toast("操作成功");
            data.visible = false;
            data.queryParams.pageIndex = 1;
            getList(function () {}, 1);
          } else {
            vant.Toast(res.msg);
          }
        }).catch(function (err) {
          data.loading = false;
        });
      }
    };
    // 上下架
    var batchState = function batchState(state, id) {
      //state==1上架，2下架
      var url = state == 1 ? '/Api/PripheryStoreGoods/ListingGoods' : '/Api/PripheryStoreGoods/DelistingGoods';
      var goodsIdArr = [id];
      $http({
        url: url,
        data: goodsIdArr
      }).then(function (res) {
        if (res.code == 1) {
          vant.Toast("操作成功");
          data.queryParams.pageIndex = 1;
          getList(function () {}, 1);
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    // 点击更多操作
    var moreActive = function moreActive(item) {
      if (!item.isShelves) {
        data.activeList = [{
          name: "添加",
          imgUrl: './img/peripheryStore/zhoubian_bianji.png'
        }];
      } else if (item.isShelves == 2) {
        data.activeList = [{
          name: "编辑并上架",
          imgUrl: './img/peripheryStore/zhoubian_shangjia.png'
        }, {
          name: "展示信息",
          imgUrl: './img/peripheryStore/zhoubian_zhanshi.png'
        }];
      } else if (item.isShelves == 1) {
        data.activeList = [{
          name: "编辑",
          imgUrl: './img/peripheryStore/zhoubian_bianji.png'
        }, {
          name: "下架",
          imgUrl: './img/peripheryStore/zhoubian_xiajia.png'
        }, {
          name: "展示信息",
          imgUrl: './img/peripheryStore/zhoubian_zhanshi.png'
        }];
      } else {
        data.activeList = [{
          name: "编辑",
          imgUrl: './img/peripheryStore/zhoubian_bianji.png'
        }, {
          name: "展示信息",
          imgUrl: './img/peripheryStore/zhoubian_zhanshi.png'
        }];
      }
      data.form = _objectSpread(_objectSpread({}, item), {}, {
        isAllGoods: false,
        goodsId: item.id,
        isOnLinePay: data.onlinePayState == 9 ? true : item.isOnLinePay,
        //如果当前店铺开通了在线支付则直接赋值不允许修改
        goodsExtendInfo: item.goodsExtendInfo ? item.goodsExtendInfo : '',
        goodsBaseInfo: item.goodsBaseInfo ? item.goodsBaseInfo : ''
      });
      data.activeVisable = true;
    };
    // 点击操作项
    var handelMenuClick = function handelMenuClick(name) {
      if (name == '下架') {
        batchState(2, data.form.goodsId);
      }
      if (name == '编辑并上架' || name == '编辑' || name == '添加') {
        data.visible = true;
      }
      if (name == '展示信息') {
        if (!data.form.isUpGoodsInfo) {
          vant.Toast({
            message: "当前商品展示信息暂未同步，请稍后手动刷新再试！",
            duration: 4000
          });
          return;
        }
        data.showInfoVisable = true;
      }
      data.activeVisable = false;
    };
    //    点击更多信息
    var handleMore = function handleMore(item) {
      item.isMore = !item.isMore;
    };
    // 排序按钮点击事件
    var sortChange = function sortChange(i, index) {
      data.sortList[index].isSort = !data.sortList[index].isSort;
      data.queryParams.isSort = data.sortList[index].isSort;
      data.queryParams.sortName = data.sortList[index].type;
    };
    // 搜索框完成时间
    var searchInput = function searchInput() {
      data.queryParams.pageIndex = 1;
      getList(function () {}, 1);
    };
    //筛选开关
    var clickScreen = function clickScreen() {
      data.screenVisible = !data.screenVisible;
    };
    // 级联回调
    var handleChange = function handleChange(value) {
      if (!value) {
        data.queryParams.goodsType = '';
        data.queryParams.goodsCategoryCode = '';
      } else if (value.length == 1) {
        data.queryParams.goodsType = value[0];
        data.queryParams.goodsCategoryCode = '';
      } else if (value.length == 2) {
        data.queryParams.goodsCategoryCode = value[1];
      } else {
        data.queryParams.goodsType = '';
        data.queryParams.goodsCategoryCode = '';
      }
    };
    // 重置
    var reset = function reset() {
      data.queryParams.goodsType = '';
      data.queryParams.goodsCategoryCode = '';
      data.queryParams.goodsName = '';
      data.queryParams.isShelves = 99;
      data.goodsTypeArry = [];
      data.queryParams.pageIndex = 1;
      data.state = 99;
      data.queryParams.isSort = false;
      data.queryParams.sortName = 'goodsSort';
      data.sortList = [{
        type: 'goodsSort',
        isSort: false,
        name: '销售排序'
      },
      //true从大到小
      {
        type: 'erpStockQuantity',
        isSort: false,
        name: '商品库存'
      }];
      getList(function () {}, 1);
    };
    var closeShowInfoVisable = function closeShowInfoVisable() {
      data.showInfoVisable = false;
      data.form.goodsBaseInfo = '';
    };

    //返回按钮
    var goBack = function goBack() {
      window.location.href = 'allMenu.html';
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      goBack: goBack,
      searchInput: searchInput,
      clickScreen: clickScreen,
      getList: getList,
      handleChange: handleChange,
      reset: reset,
      allAdd: allAdd,
      handleCancel: handleCancel,
      handleOk: handleOk,
      batchState: batchState,
      handleMore: handleMore,
      moreActive: moreActive,
      handelMenuClick: handelMenuClick,
      sortChange: sortChange,
      closeShowInfoVisable: closeShowInfoVisable,
      radio: radio,
      generatePoster: generatePoster,
      saveImgByPhoto: saveImgByPhoto
    });
  }
});
app.use(vant);
app.mount('#app');