function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch;
var m = moment;

//调试使用
if (window.vDebug) {
  var vConsole = new VConsole();
  vConsole.show();
}
createApp({
  components: {
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty
  },
  setup: function setup() {
    var data = reactive({
      screenVisible: false,
      //筛选开关
      dateList: [{
        label: '今日',
        startTime: m().startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '本周',
        startTime: m().weekday(1).startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().weekday(7).endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '本月',
        startTime: m().startOf('month').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().endOf('month').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '本年',
        startTime: m().startOf('year').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().endOf('year').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '昨日',
        startTime: m().day(m().day() - 1).startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().day(m().day() - 1).endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '上周',
        startTime: m().week(m().week() - 1).weekday(1).startOf('day').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().week(m().week() - 1).weekday(1).endOf('day').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '上月',
        startTime: m().month(m().month() - 1).startOf('month').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().month(m().month() - 1).endOf('month').format('YYYY-MM-DD HH:mm:ss')
      }, {
        label: '去年',
        startTime: m().year(m().year() - 1).startOf('year').format('YYYY-MM-DD HH:mm:ss'),
        endTime: m().year(m().year() - 1).endOf('year').format('YYYY-MM-DD HH:mm:ss')
      }],
      customerTime: {
        start: '开始时间',
        end: '结束时间'
      },
      //自定义时间
      curSelecct: {},
      //当前选中的时间段
      queryParams: {
        end: '',
        start: '',
        pageIndex: 1,
        pageSize: 10,
        memberId: ''
      },
      loading: true,
      list: [],
      showOption: false,
      options: [],
      value: ''
    });
    onMounted(function () {
      var dateList = data.dateList;
      //设置默认选中时间
      data.curSelecct = dateList[3];

      //设置销售员ID
      var searchParams = getSearchParams();
      var memberId = searchParams.memberId;
      data.queryParams.memberId = memberId;
      // data.loading = true

      setTimeout(function () {
        getList();
        mui.init({
          swipeBack: true,
          //启用右滑关闭功能
          pullRefresh: {
            container: '#refreshContainer',
            subpages: [{
              url: window.location.href,
              //下拉刷新内容页面地址
              id: '#refreshContainer' //内容页面标志
              // styles: {
              //     top: 48,//内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
              //     //其它参数定义
              // }
            }],

            up: {
              contentrefresh: '正在加载...',
              callback: function callback() {
                setTimeout(function () {
                  data.queryParams.pageIndex += 1;
                  getList(function (res) {
                    mui('#refreshContainer').pullRefresh().endPullupToRefresh(data.list.length >= res.totalCount); //参数为true代表没有更多数据了。
                  });
                }, 1000);
              },
              auto: false
            },
            down: {
              style: 'circle',
              //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
              auto: false,
              //可选,默认false.首次加载自动上拉刷新一次
              callback: function callback() {
                data.queryParams = {
                  end: '',
                  start: '',
                  pageIndex: 1,
                  pageSize: 10,
                  memberId: memberId
                };
                setTimeout(function () {
                  getList(function () {
                    mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
                    mui('#refreshContainer').pullRefresh().refresh(true);
                  });
                }, 1000);
              } //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
            }
          }
        });

        //跳转销售详情
        // $('.list_item').on('tap',(e)=>{
        //     window.location = `xiaoshou_xiaoshoudanju.html`
        // })

        // data.loading = false
      }, 100);
    });
    watchEffect(function () {
      if (data.screenVisible == true) {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '8rem'
        });
      } else {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '2rem'
        });
      }
    });

    //跳转详情
    var toDetail = function toDetail() {
      // window.location = `xiaoshou_xiaoshoudanju.html`
    };

    //筛选开关
    var clickScreen = function clickScreen() {
      data.screenVisible = !data.screenVisible;
    };

    //搜索框完成事件
    var searchInput = function searchInput() {
      data.queryParams.pageIndex = 1;
      getList();
    };

    //点击时间段
    var clickTimeBtn = function clickTimeBtn(item) {
      data.curSelecct = item;
      data.customerTime = {
        start: '开始时间',
        end: '结束时间'
      };
      data.screenVisible = false;
      data.queryParams.pageIndex = 1;
      getList();
    };

    //打开时间选择器
    var openPick = function openPick(type) {
      var _data$customerTime = data.customerTime,
        start = _data$customerTime.start,
        end = _data$customerTime.end;
      if (type == 'end' && start == '开始时间') {
        mui.toast('请先选择开始时间');
        return;
      }
      var t = start.split('-');
      var picker = new mui.DtPicker({
        type: 'date',
        //已选择结束时间重新选择开始时间重置
        beginDate: type == 'start' ? '' : new Date(t[0], Number(t[1]) - 1, t[2])
      }).show(function (res) {
        data.customerTime[type] = res.value;
        //选择开始时间且已选择结束时间则重置结束时间
        if (type == 'start' && end != '结束时间') {
          data.customerTime.end = '结束时间';
        }
        if (data.customerTime.start != '开始时间' && data.customerTime.end != '结束时间') {
          data.curSelecct = {
            label: "".concat(data.customerTime.start, "~").concat(data.customerTime.end),
            startTime: data.customerTime.start,
            endTime: data.customerTime.end
          };
          data.screenVisible = false;
          data.queryParams.pageIndex = 1;
          getList();
        }
      });
    };

    //获取列表
    var getList = function getList(cb) {
      // data.loading = true
      var queryParams = data.queryParams;
      $http({
        url: "/Api/Member/SearchScoreExchange",
        data: _objectSpread(_objectSpread({}, data.queryParams), {}, {
          start: data.curSelecct.startTime,
          end: data.curSelecct.endTime
        })
      }).then(function (res) {
        // data.loading = false
        if (res.code == 1) {
          if (cb) cb(res);
          if (data.queryParams.pageIndex == 1) {
            data.list = res.data;
          } else {
            data.list = [].concat(_toConsumableArray(data.list), _toConsumableArray(res.data));
          }
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //获取会员列表
    var getMemberList = function getMemberList() {
      var queryParams = data.queryParams;

      // data.loading = true

      $http({
        url: '/Api/Member/GetSaleMemberList'
      }).then(function (res) {
        // data.loading = false
        if (res.code == 1) {
          data.options = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //返回按钮
    var goBack = function goBack() {
      window.history.go(-1);
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      clickScreen: clickScreen,
      openPick: openPick,
      clickTimeBtn: clickTimeBtn,
      goBack: goBack,
      searchInput: searchInput,
      toDetail: toDetail
    });
  }
}).mount('#app');