$(function () {
  var pageindex = 1; //count 表示页数'
  var pagesize = 10;
  var href = false;
  var mystoreSupplierName = getUrlParamZW("name");
  if (mystoreSupplierName) {
    $("#orderSearch ").val(mystoreSupplierName);
    href = true;
  }
  //加载进货单据数据
  function loadList(startTime, endTime, pageIndex, pageSize, orderNo, isMsgType, isSnedsType) {
    var postdata = {
      startTime: startTime,
      endTime: endTime,
      orderNo: orderNo,
      pageIndex: pageIndex,
      pageSize: pageSize,
      messageType: isMsgType,
      state: isSnedsType
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SMS/SMSOrderList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(postdata),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (data.data && data.data.length > 0) {
            var tpl = historyRecordListTemp.html();
            var html = juicer(tpl, data);
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              $("#historyList").html(html);
            } else {
              $("#historyList").append(html);
            }
            pageindex++;
          }
          if (data.data == null || data.data.length == 0) {
            notdata = true;
            if (pageIndex == 1) {
              $("#historyList").html("");
              $(".zwsj-box").show();
              // $("#pullrefresh").hide();
              $('#loading').remove();
            } else {
              mui.toast("未查询到更多数据");
            }
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }

  //时间
  Date.prototype.DateAdd = function (strInterval, Number) {
    var dtTmp = this;
    switch (strInterval) {
      case 's':
        return new Date(Date.parse(dtTmp) + 1000 * Number);
      case 'n':
        return new Date(Date.parse(dtTmp) + 60000 * Number);
      case 'h':
        return new Date(Date.parse(dtTmp) + 3600000 * Number);
      case 'd':
        return new Date(Date.parse(dtTmp) + 86400000 * Number);
      case 'w':
        return new Date(Date.parse(dtTmp) + 86400000 * 7 * Number);
      case 'q':
        return new Date(dtTmp.getFullYear(), dtTmp.getMonth() + Number * 3, dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
      case 'm':
        return new Date(dtTmp.getFullYear(), dtTmp.getMonth() + Number, dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
      case 'y':
        return new Date(dtTmp.getFullYear() + Number, dtTmp.getMonth(), dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds());
    }
  };

  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  // 上下拉刷新加载公共代码
  function pullPublic() {
    //短信历史
    var orderNo = $("#orderSearch").val(); //收件人名称
    var mystartTime = $(".start-time").text(); //开始时间
    var myendTime = $(".end-time").text(); //结束时间
    var isMsgType = parseInt($('.search_box_fenlei .activeBtn').val());
    var isSnedsType = parseInt($('.search_box_sendfenlei .activeBtn1').val()); //发送状态
    // var orderState = 1;
    if (mystartTime == undefined || mystartTime == "") {
      var myDate = new Date();
      mystartTime = myDate.DateAdd("d", -30);
      myendTime = myDate.DateAdd("d", 0);
    }
    loadList(mystartTime, myendTime, pageindex, pagesize, orderNo, isMsgType, isSnedsType);
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageindex = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  var historyRecordListTemp = $("#historyRecordListTemp");
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }
  //短信 详情
  $('body').on('tap', '.orderList', function (e) {
    e.stopPropagation();
    var parentLi = $(this).parents("li");
    var id = $(parentLi).attr("data-id"); //id
    location.href = "orderHistoryDetailRecord.html?id=" + id;
  });
  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').animate({
        "top": '2.5rem'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-8rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  // 筛选栏插入日期选择
  function timers() {
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var day = myDate.getDate();
    if (month < 10) {
      month = "0" + month;
    }
    if (day < 10) {
      day = "0" + day;
    }
    var stime = year + "-" + month + "-01";
    var etime = year + "-" + month + "-" + day;
    var html = '<label>时间：</label><p class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></p>&nbsp;—';
    html += '&nbsp;<p class="btn endTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></p>';
    $('.timeList').html(html);
  }

  // 筛选栏日期选择
  function timeChoose() {
    var obj = "this.getElementsByClassName()[0]";
    var picker = null;
    var btns = $('.btn');
    btns.each(function (i, btn) {
      btn.addEventListener('tap', function () {
        if (picker) {
          picker.dispose();
        }
        var $this = $(this);
        var year = new Date().getFullYear();
        var month = new Date().getMonth() + 1;
        var day = new Date().getDate();
        var option = {
          "type": "date",
          "endYear": year,
          "endMonth": month,
          "endDay": day //设置开始日期
        };

        id = this.getAttribute('id');
        obj = this.getElementsByClassName("timer")[0];
        picker = new mui.DtPicker(option);
        picker.show(function (rs) {
          if ($this.hasClass('endTime')) {
            var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
            var da2 = new Date(rs.text.replace(/\-/g, "\/"));
            if (da1 != "" && da2 != "" && da1 > da2) {
              mui.toast("开始时间不能大于结束时间！");
              return false;
            }
          } else if ($this.hasClass('startTime')) {
            var da1 = new Date(rs.text.replace(/\-/g, "\/"));
            var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
            if (da1 != "" && da2 != "" && da1 > da2) {
              mui.toast("开始时间不能大于结束时间！");
              return false;
            }
          }
          obj.innerHTML = rs.text;
          picker.dispose();
        });
      }, false);
    });
  }
  timers();
  timeChoose();
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#require-btn').on('tap', function () {
    pageindex = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancel-btn').on('tap', function () {
    $('.orderType button').eq(0).addClass('activeBtn').siblings().removeClass('activeBtn');
    $('.sendsType button').eq(0).addClass('activeBtn1').siblings().removeClass('activeBtn1');
    $('#orderSearch').val('');
    timers();
    timeChoose();
  });

  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageindex = 1;
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    pullPublic();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    // mui('#pullrefresh').pullRefresh().refresh(true);
  });
  //选择商品分类
  $('.search_box_fenlei button').on('tap', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
  });
  $('.search_box_sendfenlei button').on('tap', function () {
    $(this).addClass('activeBtn1').siblings().removeClass('activeBtn1');
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    history.go(-1);
  });
});