$(function () {
  var pageindex = 0; //count 表示页数'
  var pagesize = 10;
  var id = getUrlParamZW("id");
  //加载进货单据数据
  function loadList() {
    var postdata = {
      pageIndex: pageindex,
      pageSize: pagesize,
      orderId: id
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SMS/SMSOrderById",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(postdata),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageindex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (data.data && data.data.length > 0) {
            var tpl = historyRecordListTemp.html();
            var html = juicer(tpl, data);
            if (pageindex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              $("#historyList").html(html);
            } else {
              $("#historyList").append(html);
            }
            pageindex++;
          }
          if (data.data == null || data.data.length == 0) {
            notdata = true;
            if (pageindex == 1) {
              $("#historyList").html("");
              $(".zwsj-box").show();
              // $("#pullrefresh").hide();
              $('#loading').remove();
            } else {
              mui.toast("未查询到更多数据");
            }
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }

  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  // 上下拉刷新加载公共代码
  function pullPublic() {
    pageindex++;
    loadList();
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageindex = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  var historyRecordListTemp = $("#historyRecordListTemp");
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    history.go(-1);
  });
});